/*
 * Decompiled with CFR 0.152.
 */
package com.arm.rosetta;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CoprocConfig
extends Structure {
    public byte[] coproc = new byte[8];

    public void set(CoprocType ... coprocs) {
        if (coprocs.length > 8) {
            throw new IllegalArgumentException("Only p0-p7 can be configured as CDE.");
        }
        for (int i = 0; i < coprocs.length; ++i) {
            this.set(i, coprocs[i]);
        }
    }

    public void set(int cpIndex, CoprocType type) {
        if (cpIndex < 0 || cpIndex > 7) {
            throw new IllegalArgumentException("Only p0-p7 can be configured as CDE.");
        }
        this.coproc[cpIndex] = type.val;
    }

    protected List<String> getFieldOrder() {
        return Arrays.asList("coproc");
    }

    public static class ByVal
    extends CoprocConfig
    implements Structure.ByValue {
    }

    public static enum CoprocType {
        CP_GCP(0),
        CP_CDEv1(1);

        private byte val;

        private CoprocType(byte val) {
            this.val = val;
        }
    }
}

