/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.swig;

import com.arm.debug.icodec.swig.Architecture;
import com.arm.debug.icodec.swig.SWIGicodecJNI;

public class TargetArch
implements AutoCloseable {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected TargetArch(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(TargetArch obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SWIGicodecJNI.delete_TargetArch(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public TargetArch(Architecture arch) {
        this(SWIGicodecJNI.new_TargetArch(Architecture.getCPtr(arch), arch), true);
    }

    public void retarget(Architecture new_arch) {
        SWIGicodecJNI.TargetArch_retarget(this.swigCPtr, this, Architecture.getCPtr(new_arch), new_arch);
    }

    public boolean select(FeatureStateSelection selection) {
        return SWIGicodecJNI.TargetArch_select(this.swigCPtr, this, selection.swigValue());
    }

    public Architecture getArchitecture() {
        return new Architecture(SWIGicodecJNI.TargetArch_getArchitecture(this.swigCPtr, this), false);
    }

    public FeatureStateSelection primaryState() {
        return FeatureStateSelection.swigToEnum(SWIGicodecJNI.TargetArch_primaryState(this.swigCPtr, this));
    }

    public long archARMIsa() {
        return SWIGicodecJNI.TargetArch_archARMIsa(this.swigCPtr, this);
    }

    public long archThumbIsa() {
        return SWIGicodecJNI.TargetArch_archThumbIsa(this.swigCPtr, this);
    }

    public long archVFPIsa() {
        return SWIGicodecJNI.TargetArch_archVFPIsa(this.swigCPtr, this);
    }

    public long archNEONIsa() {
        return SWIGicodecJNI.TargetArch_archNEONIsa(this.swigCPtr, this);
    }

    public long archRegPC() {
        return SWIGicodecJNI.TargetArch_archRegPC(this.swigCPtr, this);
    }

    public long archRegSP() {
        return SWIGicodecJNI.TargetArch_archRegSP(this.swigCPtr, this);
    }

    public long archRegSpec() {
        return SWIGicodecJNI.TargetArch_archRegSpec(this.swigCPtr, this);
    }

    public boolean archHasProcessorMode(long mode) {
        return SWIGicodecJNI.TargetArch_archHasProcessorMode(this.swigCPtr, this, mode);
    }

    public boolean hasDSP() {
        return SWIGicodecJNI.TargetArch_hasDSP(this.swigCPtr, this);
    }

    public boolean hasMedia() {
        return SWIGicodecJNI.TargetArch_hasMedia(this.swigCPtr, this);
    }

    public boolean hasSEV() {
        return SWIGicodecJNI.TargetArch_hasSEV(this.swigCPtr, this);
    }

    public static enum FeatureStateSelection {
        feature_default,
        feature_ARM,
        feature_Thumb,
        feature_Java,
        feature_T2EE,
        feature_A64,
        feature_Thumb64(SWIGicodecJNI.TargetArch_feature_Thumb64_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static FeatureStateSelection swigToEnum(int swigValue) {
            FeatureStateSelection[] swigValues = (FeatureStateSelection[])FeatureStateSelection.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (FeatureStateSelection swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + FeatureStateSelection.class + " with value " + swigValue);
        }

        private FeatureStateSelection() {
            this.swigValue = SwigNext.next++;
        }

        private FeatureStateSelection(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private FeatureStateSelection(FeatureStateSelection swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

