/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.swig;

import com.arm.debug.icodec.swig.AsmError;
import com.arm.debug.icodec.swig.AsmInstruction;
import com.arm.debug.icodec.swig.AsmToken;
import com.arm.debug.icodec.swig.ClientAsmOperand;
import com.arm.debug.icodec.swig.ExpectedAsmOperandType;
import com.arm.debug.icodec.swig.SWIGicodecJNI;

public class ClientInterface {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected ClientInterface(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ClientInterface obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SWIGicodecJNI.delete_ClientInterface(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    protected void swigDirectorDisconnect() {
        this.swigCMemOwn = false;
        this.delete();
    }

    public void swigReleaseOwnership() {
        this.swigCMemOwn = false;
        SWIGicodecJNI.ClientInterface_change_ownership(this, this.swigCPtr, false);
    }

    public void swigTakeOwnership() {
        this.swigCMemOwn = true;
        SWIGicodecJNI.ClientInterface_change_ownership(this, this.swigCPtr, true);
    }

    public void currentToken(AsmToken token) {
        SWIGicodecJNI.ClientInterface_currentToken(this.swigCPtr, this, AsmToken.getCPtr(token), token);
    }

    public void nextToken() {
        SWIGicodecJNI.ClientInterface_nextToken(this.swigCPtr, this);
    }

    public GetOperandStatus getOperand(ExpectedAsmOperandType expect, AsmInstruction asminstr, ClientAsmOperand operand) {
        return GetOperandStatus.swigToEnum(SWIGicodecJNI.ClientInterface_getOperand(this.swigCPtr, this, ExpectedAsmOperandType.getCPtr(expect), expect, AsmInstruction.getCPtr(asminstr), asminstr, ClientAsmOperand.getCPtr(operand), operand));
    }

    public boolean diagnoseError(AsmError err) {
        return SWIGicodecJNI.ClientInterface_diagnoseError(this.swigCPtr, this, AsmError.getCPtr(err), err);
    }

    public ClientInterface() {
        this(SWIGicodecJNI.new_ClientInterface(), true);
        SWIGicodecJNI.ClientInterface_director_connect(this, this.swigCPtr, this.swigCMemOwn, true);
    }

    public static enum GetOperandStatus {
        agos_notFound,
        agos_syntaxError,
        agos_found;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static GetOperandStatus swigToEnum(int swigValue) {
            GetOperandStatus[] swigValues = (GetOperandStatus[])GetOperandStatus.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (GetOperandStatus swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + GetOperandStatus.class + " with value " + swigValue);
        }

        private GetOperandStatus() {
            this.swigValue = SwigNext.next++;
        }

        private GetOperandStatus(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private GetOperandStatus(GetOperandStatus swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

