/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.swig;

import com.arm.debug.icodec.swig.SWIGicodecJNI;

public class Architecture
implements AutoCloseable {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected Architecture(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Architecture obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SWIGicodecJNI.delete_Architecture(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public boolean allowsVFPCommonSubarchRegs() {
        return SWIGicodecJNI.Architecture_allowsVFPCommonSubarchRegs(this.swigCPtr, this);
    }

    public Architecture() {
        this(SWIGicodecJNI.new_Architecture__SWIG_0(), true);
    }

    public Architecture(CoreVersion core) {
        this(SWIGicodecJNI.new_Architecture__SWIG_1(core.swigValue()), true);
    }

    public Architecture(CoreVersion core, VFPNEONVersion vfpneon) {
        this(SWIGicodecJNI.new_Architecture__SWIG_2(core.swigValue(), vfpneon.swigValue()), true);
    }

    public void setCoreAndVFPNEON(CoreVersion core_version, VFPNEONVersion vfpneon_version) {
        SWIGicodecJNI.Architecture_setCoreAndVFPNEON(this.swigCPtr, this, core_version.swigValue(), vfpneon_version.swigValue());
    }

    public void setCore(CoreVersion version) {
        SWIGicodecJNI.Architecture_setCore(this.swigCPtr, this, version.swigValue());
    }

    public void setVFPNEON(VFPNEONVersion version) {
        SWIGicodecJNI.Architecture_setVFPNEON(this.swigCPtr, this, version.swigValue());
    }

    public void addExtension(ArchExtension extension) {
        SWIGicodecJNI.Architecture_addExtension(this.swigCPtr, this, extension.swigValue());
    }

    public CoreVersion getCore() {
        return CoreVersion.swigToEnum(SWIGicodecJNI.Architecture_getCore(this.swigCPtr, this));
    }

    public VFPNEONVersion getVFPNEON() {
        return VFPNEONVersion.swigToEnum(SWIGicodecJNI.Architecture_getVFPNEON(this.swigCPtr, this));
    }

    public static CoreVersion coreNameToVersion(String arg0) {
        return CoreVersion.swigToEnum(SWIGicodecJNI.Architecture_coreNameToVersion(arg0));
    }

    public static String coreVersionToName(CoreVersion arg0) {
        return SWIGicodecJNI.Architecture_coreVersionToName(arg0.swigValue());
    }

    public Architecture intersect(Architecture a) {
        return new Architecture(SWIGicodecJNI.Architecture_intersect(this.swigCPtr, this, Architecture.getCPtr(a), a), false);
    }

    public Architecture unite(Architecture a) {
        return new Architecture(SWIGicodecJNI.Architecture_unite(this.swigCPtr, this, Architecture.getCPtr(a), a), false);
    }

    public CoreProfile archCoreProfile() {
        return CoreProfile.swigToEnum(SWIGicodecJNI.Architecture_archCoreProfile(this.swigCPtr, this));
    }

    public boolean archHasMProfile() {
        return SWIGicodecJNI.Architecture_archHasMProfile(this.swigCPtr, this);
    }

    public boolean archHasARM() {
        return SWIGicodecJNI.Architecture_archHasARM(this.swigCPtr, this);
    }

    public boolean archHasThumb() {
        return SWIGicodecJNI.Architecture_archHasThumb(this.swigCPtr, this);
    }

    public boolean archHasJava() {
        return SWIGicodecJNI.Architecture_archHasJava(this.swigCPtr, this);
    }

    public boolean archHasT2EE() {
        return SWIGicodecJNI.Architecture_archHasT2EE(this.swigCPtr, this);
    }

    public boolean archHasA64() {
        return SWIGicodecJNI.Architecture_archHasA64(this.swigCPtr, this);
    }

    public boolean archHasThumb64() {
        return SWIGicodecJNI.Architecture_archHasThumb64(this.swigCPtr, this);
    }

    public long archARMIsa() {
        return SWIGicodecJNI.Architecture_archARMIsa(this.swigCPtr, this);
    }

    public long archThumbIsa() {
        return SWIGicodecJNI.Architecture_archThumbIsa(this.swigCPtr, this);
    }

    public long archVFPIsa() {
        return SWIGicodecJNI.Architecture_archVFPIsa(this.swigCPtr, this);
    }

    public long archNEONIsa() {
        return SWIGicodecJNI.Architecture_archNEONIsa(this.swigCPtr, this);
    }

    public long archRegPC() {
        return SWIGicodecJNI.Architecture_archRegPC(this.swigCPtr, this);
    }

    public long archRegSP() {
        return SWIGicodecJNI.Architecture_archRegSP(this.swigCPtr, this);
    }

    public long archRegSpec() {
        return SWIGicodecJNI.Architecture_archRegSpec(this.swigCPtr, this);
    }

    public boolean archHasMvfrRegisters() {
        return SWIGicodecJNI.Architecture_archHasMvfrRegisters(this.swigCPtr, this);
    }

    public boolean archHasMvfr2Register() {
        return SWIGicodecJNI.Architecture_archHasMvfr2Register(this.swigCPtr, this);
    }

    public boolean archDefinesAccess(long arg0, boolean forRead) {
        return SWIGicodecJNI.Architecture_archDefinesAccess(this.swigCPtr, this, arg0, forRead);
    }

    public boolean archHasApsrGEBits() {
        return SWIGicodecJNI.Architecture_archHasApsrGEBits(this.swigCPtr, this);
    }

    public boolean archHasVFPShortVectors() {
        return SWIGicodecJNI.Architecture_archHasVFPShortVectors(this.swigCPtr, this);
    }

    public boolean archHasDeprecatedT2EE() {
        return SWIGicodecJNI.Architecture_archHasDeprecatedT2EE(this.swigCPtr, this);
    }

    public boolean archHasProcessorMode(long mode) {
        return SWIGicodecJNI.Architecture_archHasProcessorMode(this.swigCPtr, this, mode);
    }

    public boolean compareConfigAArch32(Architecture a) {
        return SWIGicodecJNI.Architecture_compareConfigAArch32(this.swigCPtr, this, Architecture.getCPtr(a), a);
    }

    public boolean compareConfigExtra(Architecture a) {
        return SWIGicodecJNI.Architecture_compareConfigExtra(this.swigCPtr, this, Architecture.getCPtr(a), a);
    }

    public boolean compareConfigAArch64(Architecture a) {
        return SWIGicodecJNI.Architecture_compareConfigAArch64(this.swigCPtr, this, Architecture.getCPtr(a), a);
    }

    public boolean compareConfig(Architecture a) {
        return SWIGicodecJNI.Architecture_compareConfig(this.swigCPtr, this, Architecture.getCPtr(a), a);
    }

    public static enum CoreProcessorMode {
        mode_user(SWIGicodecJNI.Architecture_mode_user_get()),
        mode_fiq(SWIGicodecJNI.Architecture_mode_fiq_get()),
        mode_irq(SWIGicodecJNI.Architecture_mode_irq_get()),
        mode_svc(SWIGicodecJNI.Architecture_mode_svc_get()),
        mode_mon(SWIGicodecJNI.Architecture_mode_mon_get()),
        mode_abt(SWIGicodecJNI.Architecture_mode_abt_get()),
        mode_hyp(SWIGicodecJNI.Architecture_mode_hyp_get()),
        mode_und(SWIGicodecJNI.Architecture_mode_und_get()),
        mode_sys(SWIGicodecJNI.Architecture_mode_sys_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CoreProcessorMode swigToEnum(int swigValue) {
            CoreProcessorMode[] swigValues = (CoreProcessorMode[])CoreProcessorMode.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (CoreProcessorMode swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + CoreProcessorMode.class + " with value " + swigValue);
        }

        private CoreProcessorMode() {
            this.swigValue = SwigNext.next++;
        }

        private CoreProcessorMode(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private CoreProcessorMode(CoreProcessorMode swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum CoreProfile {
        profile_none,
        profile_A,
        profile_R,
        profile_M,
        profile_S;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CoreProfile swigToEnum(int swigValue) {
            CoreProfile[] swigValues = (CoreProfile[])CoreProfile.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (CoreProfile swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + CoreProfile.class + " with value " + swigValue);
        }

        private CoreProfile() {
            this.swigValue = SwigNext.next++;
        }

        private CoreProfile(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private CoreProfile(CoreProfile swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum ArchExtension {
        extension_none(SWIGicodecJNI.Architecture_extension_none_get()),
        extension_thumbee,
        extension_security,
        extension_jazelle,
        extension_multiprocessing,
        extension_virtualization,
        extension_thumbdivide,
        extension_armthumbdivide,
        extension_marvelldivide,
        extension_xscale,
        extension_wmmx,
        extension_wmmx2,
        extension_fusedmultiplyaccumulate,
        extension_vmsav7,
        extension_pmsav7,
        extension_pmsav8,
        extension_cryptography,
        extension_largesystem,
        extension_dsp,
        extension_ras,
        extension_dotproduct,
        extension_lastplusone,
        extension_last(SWIGicodecJNI.Architecture_extension_last_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static ArchExtension swigToEnum(int swigValue) {
            ArchExtension[] swigValues = (ArchExtension[])ArchExtension.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (ArchExtension swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + ArchExtension.class + " with value " + swigValue);
        }

        private ArchExtension() {
            this.swigValue = SwigNext.next++;
        }

        private ArchExtension(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private ArchExtension(ArchExtension swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum VFPNEONVersion {
        vfpneon_none(SWIGicodecJNI.Architecture_vfpneon_none_get()),
        vfpneon_vfpv2,
        vfpneon_vfpv3,
        vfpneon_vfpv3_16,
        vfpneon_vfpv3_neonv1,
        vfpneon_neonv1_integer,
        vfpneon_vfpv3_hpfp,
        vfpneon_vfpv3_hpfp_16,
        vfpneon_vfpv3_hpfp_neonv1_hpfp,
        vfpneon_vfpv2_sp,
        vfpneon_vfpv3_sp,
        vfpneon_vfpv3_sp_16,
        vfpneon_vfpv3_sp_hpfp,
        vfpneon_vfpv3_sp_hpfp_16,
        vfpneon_vfpv4,
        vfpneon_vfpv4_16,
        vfpneon_vfpv4_sp,
        vfpneon_vfpv4_sp_16,
        vfpneon_vfpv4_neonv2,
        vfpneon_fpv5_16,
        vfpneon_fpv5_sp_16,
        vfpneon_unsafe,
        vfpneon_v8A_fp,
        vfpneon_v8A_sp_16,
        vfpneon_v8A_fp_neon,
        vfpneon_oban_fp,
        vfpneon_oban_fp_neon,
        vfpneon_v8_2A_fp,
        vfpneon_v8_2A_fp_neon,
        vfpneon_v8_3A_fp_neon,
        vfpneon_v8_3A_fp_neon_fp16,
        vfpneon_lastplusone,
        vfpneon_last(SWIGicodecJNI.Architecture_vfpneon_last_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static VFPNEONVersion swigToEnum(int swigValue) {
            VFPNEONVersion[] swigValues = (VFPNEONVersion[])VFPNEONVersion.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (VFPNEONVersion swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + VFPNEONVersion.class + " with value " + swigValue);
        }

        private VFPNEONVersion() {
            this.swigValue = SwigNext.next++;
        }

        private VFPNEONVersion(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private VFPNEONVersion(VFPNEONVersion swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum CoreVersion {
        core_pre_v4(SWIGicodecJNI.Architecture_core_pre_v4_get()),
        core_v4,
        core_v4T,
        core_v5T,
        core_v5TE,
        core_v5TEJ,
        core_v6,
        core_v6K,
        core_v6Z,
        core_v6T2,
        core_v7A,
        core_v7R,
        core_v7M,
        core_v6M,
        core_v6SM,
        core_v7S,
        core_v7,
        core_oban,
        core_v7EM,
        core_v8M_baseline,
        core_v8M_mainline,
        core_v8A,
        core_v8A_32,
        core_v8A_64,
        core_v8R_32,
        core_v8S_32,
        core_v8_1A,
        core_v8_1A_32,
        core_v8_1A_64,
        core_v8_2A,
        core_v8_2A_32,
        core_v8_2A_64,
        core_v8_3A,
        core_v8_3A_32,
        core_v8_3A_64,
        core_unsafe,
        core_lastplusone,
        core_last(SWIGicodecJNI.Architecture_core_last_get()),
        core_proteus(SWIGicodecJNI.Architecture_core_proteus_get()),
        core_proteus_osextension(SWIGicodecJNI.Architecture_core_proteus_osextension_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CoreVersion swigToEnum(int swigValue) {
            CoreVersion[] swigValues = (CoreVersion[])CoreVersion.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (CoreVersion swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + CoreVersion.class + " with value " + swigValue);
        }

        private CoreVersion() {
            this.swigValue = SwigNext.next++;
        }

        private CoreVersion(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private CoreVersion(CoreVersion swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

