/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.asm;

import com.arm.debug.icodec.asm.Assembler;
import com.arm.debug.icodec.asm.AssemblyDirective;
import com.arm.debug.icodec.asm.DirectiveOperand;
import com.arm.debug.icodec.asm.Messages;
import com.arm.debug.icodec.swig.Architecture;
import com.arm.debug.icodec.swig.TargetArch;
import com.arm.text.FormattedException;
import com.arm.util.HexNumberHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirectiveAssembler {
    private static Pattern DIRECTIVE_NAME = Pattern.compile("\\s*(\\w+(\\.w|\\.W)?|\\w+)");
    private static Pattern DIRECTIVE_OPERAND = Pattern.compile("\\s*([\\w\\.+-]+|\"[^\"]+\"|;.*$)\\s*");
    private static Pattern OPERATOR_STRING = Pattern.compile("\\s*\"([^\"]+)\"");
    private static Pattern OPERATOR_INT = Pattern.compile("\\s*([+-]?\\d+|0x[\\da-fA-F]+|2_[10]+)\\s*");
    private static Pattern OPERATOR_FLOAT = Pattern.compile("\\s*([+-]?\\d+\\.?\\d*([eE][+-]?\\d*)?)\\s*");

    private List<String> simpleDirectiveLexer(String mnemonic) {
        Matcher nameMatcher = DIRECTIVE_NAME.matcher(mnemonic);
        Matcher operandMatcher = DIRECTIVE_OPERAND.matcher(mnemonic);
        ArrayList<String> tokens = new ArrayList<String>();
        if (nameMatcher.find()) {
            tokens.add(nameMatcher.group(1).replace(".", "_"));
            int last_idx_matched = nameMatcher.end();
            while (operandMatcher.find(last_idx_matched)) {
                tokens.add(operandMatcher.group(1));
                last_idx_matched = operandMatcher.end();
            }
        }
        return tokens;
    }

    private AssemblyDirective simpleDirectiveParser(String mnemonic) throws FormattedException {
        List<String> tokens = this.simpleDirectiveLexer(mnemonic);
        AssemblyDirective.IDirective directive = AssemblyDirective.stringToDirective(tokens.get(0));
        if (directive == null) {
            return null;
        }
        ArrayList<DirectiveOperand> operands = new ArrayList<DirectiveOperand>();
        for (String token : tokens.subList(1, tokens.size())) {
            Matcher stringMatch = OPERATOR_STRING.matcher(token);
            Matcher intMatch = OPERATOR_INT.matcher(token);
            Matcher floatMatch = OPERATOR_FLOAT.matcher(token);
            DirectiveOperand op = null;
            if (token.startsWith(";")) break;
            if (stringMatch.matches()) {
                op = new DirectiveOperand(DirectiveOperand.DIRECTIVE_OPERAND_TYPE.STRING, stringMatch.group(1));
            } else if (intMatch.matches()) {
                op = new DirectiveOperand(DirectiveOperand.DIRECTIVE_OPERAND_TYPE.INT, intMatch.group(1));
            } else if (floatMatch.matches()) {
                op = new DirectiveOperand(DirectiveOperand.DIRECTIVE_OPERAND_TYPE.FLOAT, floatMatch.group(1));
            }
            if (op != null) {
                operands.add(op);
                continue;
            }
            throw new FormattedException(Messages.ERRORS_DIRECTIVE_PARSE.format(mnemonic));
        }
        AssemblyDirective dinfo = new AssemblyDirective(mnemonic, directive, operands);
        return dinfo;
    }

    private void rangeCheck(long value, int bytes) throws FormattedException {
        long topLimit = 1L << bytes * 8;
        long bottomLimit = -(1L << (bytes - 1) * 8);
        if (value > topLimit - 1L || value < bottomLimit + 1L) {
            throw new FormattedException(Messages.ERRORS_IMM_VAL_RANGE_A1170E.format(HexNumberHelper.longToHexString((long)value), HexNumberHelper.longToHexString((long)topLimit)));
        }
    }

    private long parseLong(String text) throws FormattedException {
        try {
            long value = text.startsWith("0x") ? Long.parseLong(text.substring(2), 16) : (text.startsWith("2_") ? Long.parseLong(text.substring(2), 2) : Long.parseLong(text));
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormattedException(Messages.ERRORS_NUM_OVER_A1183E.format(new Object[0]));
        }
    }

    private float parseFloat(String text) throws FormattedException {
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormattedException(Messages.ERRORS_NUM_OVER_A1183E.format(new Object[0]));
        }
    }

    private double parseDouble(String text) throws FormattedException {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormattedException(Messages.ERRORS_NUM_OVER_A1183E.format(new Object[0]));
        }
    }

    private List<Assembler.AsmInfo> assembleDCB(long address, AssemblyDirective dinfo) throws FormattedException {
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        int align = 1;
        block4: for (DirectiveOperand op : dinfo.operands) {
            switch (op.type) {
                case INT: {
                    long value = this.parseLong(op.text);
                    this.rangeCheck(value, 1);
                    assembled.add(new Assembler.AsmInfo("DCB " + value, 1, (int)value, address, align, true));
                    ++address;
                    break;
                }
                case STRING: {
                    byte[] byArray = op.text.getBytes();
                    int n = byArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        assembled.add(new Assembler.AsmInfo("DCB \"" + (char)b + "\"", 1, b, address, align, true));
                        ++address;
                        ++n2;
                    }
                    continue block4;
                }
                default: {
                    throw new FormattedException(Messages.ERRORS_DIRECTIVE_DATA.format("DCB", "INT, STRING"));
                }
            }
        }
        return assembled;
    }

    private List<Assembler.AsmInfo> assembleDCW(long address, AssemblyDirective dinfo) throws FormattedException {
        int align;
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        switch ((AssemblyDirective.DATA_DIRECTIVE)dinfo.directive) {
            case DCW: {
                align = 2;
                break;
            }
            case DCWU: {
                align = 1;
                break;
            }
            default: {
                return assembled;
            }
        }
        for (DirectiveOperand op : dinfo.operands) {
            switch (op.type) {
                case INT: {
                    long value = this.parseLong(op.text);
                    this.rangeCheck(value, 2);
                    assembled.add(new Assembler.AsmInfo("DCW " + value, 2, (int)value, address, align, true));
                    address += 4L;
                    break;
                }
                default: {
                    throw new FormattedException(Messages.ERRORS_DIRECTIVE_DATA.format("DCW", "INT"));
                }
            }
        }
        return assembled;
    }

    private List<Assembler.AsmInfo> assembleDCD(long address, AssemblyDirective dinfo) throws FormattedException {
        int align;
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        switch ((AssemblyDirective.DATA_DIRECTIVE)dinfo.directive) {
            case DCD: {
                align = 4;
                break;
            }
            case DCDU: {
                align = 1;
                break;
            }
            default: {
                return assembled;
            }
        }
        for (DirectiveOperand op : dinfo.operands) {
            switch (op.type) {
                case INT: {
                    long value = this.parseLong(op.text);
                    this.rangeCheck(value, 4);
                    assembled.add(new Assembler.AsmInfo("DCD " + (int)value, 4, (int)value, address, align, true));
                    address += 4L;
                    break;
                }
                default: {
                    throw new FormattedException(Messages.ERRORS_DIRECTIVE_DATA.format("DCD", "INT"));
                }
            }
        }
        return assembled;
    }

    private List<Assembler.AsmInfo> assembleDCI(long address, AssemblyDirective dinfo, TargetArch ta) throws FormattedException {
        int wordsize;
        int align;
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        switch ((AssemblyDirective.DATA_DIRECTIVE)dinfo.directive) {
            case DCI: {
                if (ta.primaryState() == TargetArch.FeatureStateSelection.feature_Thumb || ta.primaryState() == TargetArch.FeatureStateSelection.feature_T2EE || ta.primaryState() == TargetArch.FeatureStateSelection.feature_Thumb64) {
                    align = 2;
                    wordsize = 2;
                    break;
                }
                align = 4;
                wordsize = 4;
                break;
            }
            case DCI_W: {
                if (ta.primaryState() == TargetArch.FeatureStateSelection.feature_Thumb || ta.primaryState() == TargetArch.FeatureStateSelection.feature_T2EE || ta.primaryState() == TargetArch.FeatureStateSelection.feature_Thumb64) {
                    align = 2;
                    wordsize = 4;
                    break;
                }
                throw new FormattedException(Messages.ERRORS_WIDTH_NOT_SUPPORTED_ON_THIS_TARGET_A1617E.format(new Object[0]));
            }
            default: {
                return assembled;
            }
        }
        for (DirectiveOperand op : dinfo.operands) {
            switch (op.type) {
                case INT: {
                    long value = this.parseLong(op.text);
                    this.rangeCheck(value, wordsize);
                    assembled.add(new Assembler.AsmInfo("DCD " + (int)value, wordsize, (int)value, address, align, false));
                    address += (long)wordsize;
                    break;
                }
                default: {
                    throw new FormattedException(Messages.ERRORS_DIRECTIVE_DATA.format("DCI", "INT"));
                }
            }
        }
        return assembled;
    }

    private List<Assembler.AsmInfo> assembleDCQ(long address, AssemblyDirective dinfo) throws FormattedException {
        int align;
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        switch ((AssemblyDirective.DATA_DIRECTIVE)dinfo.directive) {
            case DCQ: {
                align = 4;
                break;
            }
            case DCQU: {
                align = 1;
                break;
            }
            default: {
                return assembled;
            }
        }
        for (DirectiveOperand op : dinfo.operands) {
            switch (op.type) {
                case INT: {
                    long value = this.parseLong(op.text);
                    assembled.add(new Assembler.AsmInfo("DCD " + (int)(value & 0xFFFFFFFFL), 4, (int)(value & 0xFFFFFFFFL), address, align, true));
                    assembled.add(new Assembler.AsmInfo("DCD " + (int)(value >> 32 & 0xFFFFFFFFL), 4, (int)(value >> 32 & 0xFFFFFFFFL), address += 4L, align, true));
                    address += 4L;
                    break;
                }
                default: {
                    throw new FormattedException(Messages.ERRORS_DIRECTIVE_DATA.format("DCQ", "INT"));
                }
            }
        }
        return assembled;
    }

    private List<Assembler.AsmInfo> assembleDCFS(long address, AssemblyDirective dinfo) throws FormattedException {
        int align;
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        switch ((AssemblyDirective.DATA_DIRECTIVE)dinfo.directive) {
            case DCFS: {
                align = 4;
                break;
            }
            case DCFSU: {
                align = 1;
                break;
            }
            default: {
                return assembled;
            }
        }
        for (DirectiveOperand op : dinfo.operands) {
            switch (op.type) {
                case INT: 
                case FLOAT: {
                    float fpval = this.parseFloat(op.text);
                    long value = Float.floatToRawIntBits(fpval);
                    if (fpval > Float.MAX_VALUE || fpval < -3.4028235E38f) {
                        throw new FormattedException(Messages.ERRORS_FP_VERY_BIG_A1407E.format(new Object[0]));
                    }
                    assembled.add(new Assembler.AsmInfo("DCD " + value, 4, (int)value, address, align, true));
                    address += 4L;
                    break;
                }
                default: {
                    throw new FormattedException(Messages.ERRORS_DIRECTIVE_DATA.format("DCFS", "INT, FLOAT"));
                }
            }
        }
        return assembled;
    }

    private List<Assembler.AsmInfo> assembleDCFD(long address, AssemblyDirective dinfo) throws FormattedException {
        int align;
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        switch ((AssemblyDirective.DATA_DIRECTIVE)dinfo.directive) {
            case DCFD: {
                align = 4;
                break;
            }
            case DCFDU: {
                align = 1;
                break;
            }
            default: {
                return assembled;
            }
        }
        for (DirectiveOperand op : dinfo.operands) {
            switch (op.type) {
                case INT: 
                case FLOAT: {
                    double fpval = this.parseDouble(op.text);
                    long value = Double.doubleToRawLongBits(fpval);
                    if (fpval > Double.MAX_VALUE || fpval < Double.MIN_NORMAL) {
                        throw new FormattedException(Messages.ERRORS_FP_VERY_BIG_A1407E.format(new Object[0]));
                    }
                    assembled.add(new Assembler.AsmInfo("DCD " + (int)(value & 0xFFFFFFFFL), 4, (int)(value & 0xFFFFFFFFL), address, align, true));
                    assembled.add(new Assembler.AsmInfo("DCD " + (int)(value >> 32 & 0xFFFFFFFFL), 4, (int)(value >> 32 & 0xFFFFFFFFL), address += 4L, align, true));
                    address += 4L;
                    break;
                }
                default: {
                    throw new FormattedException(Messages.ERRORS_DIRECTIVE_DATA.format("DCFD", "INT, FLOAT"));
                }
            }
        }
        return assembled;
    }

    private List<Assembler.AsmInfo> assembleDataDirective(long address, AssemblyDirective dinfo, TargetArch ta) throws FormattedException {
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        switch ((AssemblyDirective.DATA_DIRECTIVE)dinfo.directive) {
            case DCB: {
                assembled.addAll(this.assembleDCB(address, dinfo));
                break;
            }
            case DCD: 
            case DCDU: {
                assembled.addAll(this.assembleDCD(address, dinfo));
                break;
            }
            case DCW: 
            case DCWU: {
                assembled.addAll(this.assembleDCW(address, dinfo));
                break;
            }
            case DCQ: 
            case DCQU: {
                assembled.addAll(this.assembleDCQ(address, dinfo));
                break;
            }
            case DCFS: 
            case DCFSU: {
                assembled.addAll(this.assembleDCFS(address, dinfo));
                break;
            }
            case DCFD: 
            case DCFDU: {
                assembled.addAll(this.assembleDCFD(address, dinfo));
                break;
            }
            case DCI: 
            case DCI_W: {
                assembled.addAll(this.assembleDCI(address, dinfo, ta));
                break;
            }
            default: {
                throw new FormattedException(Messages.ERRORS_DIRECTIVE_NOT_SUPPORTED_A1994E.format("DS5 Inline Assembler"));
            }
        }
        return assembled;
    }

    private TargetArch.FeatureStateSelection featureStateFromArchEnum(AssemblyDirective dir) {
        switch ((AssemblyDirective.ARCH_DIRECTIVE)dir.directive) {
            case A64: {
                return TargetArch.FeatureStateSelection.feature_A64;
            }
            case ARM: 
            case CODE32: {
                return TargetArch.FeatureStateSelection.feature_ARM;
            }
            case THUMBX: {
                return TargetArch.FeatureStateSelection.feature_T2EE;
            }
            case THUMB: 
            case CODE16: {
                return TargetArch.FeatureStateSelection.feature_Thumb;
            }
        }
        return null;
    }

    private AssemblyDirective processDirective(String mnemonic) throws FormattedException {
        return this.simpleDirectiveParser(mnemonic);
    }

    public List<Assembler.AsmInfo> assembleDirective(long address, TargetArch ta, String mnemonic) throws FormattedException {
        ArrayList<Assembler.AsmInfo> assembled = new ArrayList<Assembler.AsmInfo>();
        AssemblyDirective dinfo = this.processDirective(mnemonic);
        if (dinfo == null) {
            return null;
        }
        if (dinfo.isValidCodeDirective()) {
            TargetArch.FeatureStateSelection newmode = this.featureStateFromArchEnum(dinfo);
            if (!ta.select(newmode)) {
                if (!ta.getArchitecture().archHasARM() || !ta.getArchitecture().archHasThumb()) {
                    ta.retarget(new Architecture(Architecture.CoreVersion.core_v7A));
                } else if (!ta.getArchitecture().archHasA64()) {
                    ta.retarget(new Architecture(Architecture.CoreVersion.core_v8A_64));
                }
                ta.select(newmode);
            }
        } else if (dinfo.isValidDataDirective()) {
            assembled.addAll(this.assembleDataDirective(address, dinfo, ta));
        }
        return assembled;
    }
}

