/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec.asm;

import com.arm.debug.icodec.asm.Messages;
import com.arm.debug.icodec.swig.AsmError;
import com.arm.debug.icodec.swig.AsmInstruction;
import com.arm.debug.icodec.swig.AsmOperandType;
import com.arm.debug.icodec.swig.AsmToken;
import com.arm.debug.icodec.swig.AsmTokenType;
import com.arm.debug.icodec.swig.ClientAsmOperand;
import com.arm.debug.icodec.swig.ClientInterface;
import com.arm.debug.icodec.swig.ExpectedAsmOperandType;
import com.arm.debug.icodec.swig.GenericRegisterModel;
import com.arm.debug.icodec.swig.GenericRegisterSpecial;
import com.arm.debug.icodec.swig.SWIGTYPE_p_unsigned_int;
import com.arm.debug.icodec.swig.SWIGTYPE_p_void;
import com.arm.debug.icodec.swig.SWIGicodec;
import com.arm.text.FormattedException;
import com.arm.text.IMessage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsmLibClient
extends ClientInterface {
    private final String line;
    private TokenInfo currentToken;
    private TokenInfo failedToken;
    private boolean error_caught = false;
    private AsmError err = null;
    private List<SWIGTYPE_p_unsigned_int> allocated;
    private static final Map<String, Long> ARMRegNumMap = new HashMap<String, Long>();
    private static final Map<String, Long> XRegNumMap;
    private static final Map<String, Long> WRegNumMap;
    private static final Map<String, Long> extRegSNumMap;
    private static final Map<String, Long> extRegDNumMap;
    private static final Map<String, Long> extRegBNumMap;
    private static final Map<String, Long> extRegHNumMap;
    private static final Map<String, Long> extRegQNumMap;
    private static final Map<String, Long> extRegVNumMap;

    static {
        AsmLibClient.initRegMap(16, "R", ARMRegNumMap);
        AsmLibClient.initRegMap(16, "P", ARMRegNumMap);
        AsmLibClient.initRegMap(16, "C", ARMRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch32, GenericRegisterSpecial.grs_LR, "LR", ARMRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch32, GenericRegisterSpecial.grs_SP, "SP", ARMRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch32, GenericRegisterSpecial.grs_PC, "PC", ARMRegNumMap);
        extRegSNumMap = new HashMap<String, Long>();
        AsmLibClient.initRegMap(31, "S", extRegSNumMap);
        extRegDNumMap = new HashMap<String, Long>();
        AsmLibClient.initRegMap(31, "D", extRegDNumMap);
        extRegBNumMap = new HashMap<String, Long>();
        AsmLibClient.initRegMap(16, "B", extRegBNumMap);
        extRegHNumMap = new HashMap<String, Long>();
        AsmLibClient.initRegMap(16, "H", extRegHNumMap);
        extRegQNumMap = new HashMap<String, Long>();
        AsmLibClient.initRegMap(16, "Q", extRegQNumMap);
        extRegVNumMap = new HashMap<String, Long>();
        AsmLibClient.initRegMap(16, "V", extRegVNumMap);
        WRegNumMap = new HashMap<String, Long>();
        AsmLibClient.initRegMap(31, "W", WRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch64, GenericRegisterSpecial.grs_LR, "WLR", WRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch64, GenericRegisterSpecial.grs_SP, "WSP", WRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch64, GenericRegisterSpecial.grs_PC, "WPC", WRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch64, GenericRegisterSpecial.grs_ZERO, "WZR", WRegNumMap);
        XRegNumMap = new HashMap<String, Long>();
        AsmLibClient.initRegMap(31, "X", XRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch64, GenericRegisterSpecial.grs_LR, "LR", XRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch64, GenericRegisterSpecial.grs_SP, "SP", XRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch64, GenericRegisterSpecial.grs_PC, "PC", XRegNumMap);
        AsmLibClient.addSpecialReg(GenericRegisterModel.grm_aarch64, GenericRegisterSpecial.grs_ZERO, "XZR", XRegNumMap);
    }

    public AsmLibClient(String line) {
        this.line = line;
        this.allocated = new ArrayList<SWIGTYPE_p_unsigned_int>();
        this.currentToken = new TokenInfo(0, AsmTokenType.at_unknown, null);
        this.nextToken();
    }

    @Override
    public void currentToken(AsmToken token) {
        token.setType(this.currentToken.tokenType);
        switch (this.currentToken.tokenType) {
            case at_word: {
                token.setWord(this.currentToken.text);
                break;
            }
            case at_integer: {
                try {
                    token.setInteger(Integer.valueOf(this.currentToken.text, 10).intValue());
                    token.setInteger64(Long.valueOf(this.currentToken.text, 10));
                }
                catch (NumberFormatException numberFormatException) {
                    token.setType(AsmTokenType.at_unknown);
                }
                break;
            }
        }
    }

    @Override
    public void nextToken() {
        this.currentToken = this.computeCurrentToken();
    }

    private TokenInfo computeCurrentToken() {
        TokenInfo result;
        int index = this.currentToken.nextTokenIndex;
        while (index < this.line.length()) {
            if (!Character.isWhitespace(this.line.charAt(index))) break;
            ++index;
        }
        if (index == this.line.length()) {
            return new TokenInfo(index, AsmTokenType.at_eol, "");
        }
        char currentChar = this.line.charAt(index);
        switch (currentChar) {
            case ';': {
                result = new TokenInfo(index, AsmTokenType.at_eol, "");
                break;
            }
            case '!': {
                result = new TokenInfo(index + 1, AsmTokenType.at_shriek, "");
                break;
            }
            case '#': {
                result = new TokenInfo(index + 1, AsmTokenType.at_hash, "");
                break;
            }
            case '+': {
                result = new TokenInfo(index + 1, AsmTokenType.at_plus, "");
                break;
            }
            case '-': {
                result = new TokenInfo(index + 1, AsmTokenType.at_minus, "");
                break;
            }
            case ',': {
                result = new TokenInfo(index + 1, AsmTokenType.at_comma, "");
                break;
            }
            case ':': 
            case '@': {
                result = new TokenInfo(index + 1, AsmTokenType.at_align, "");
                break;
            }
            case '[': {
                result = new TokenInfo(index + 1, AsmTokenType.at_squarebra, "");
                break;
            }
            case ']': {
                result = new TokenInfo(index + 1, AsmTokenType.at_squareket, "");
                break;
            }
            case '{': {
                result = new TokenInfo(index + 1, AsmTokenType.at_curlybra, "");
                break;
            }
            case '}': {
                result = new TokenInfo(index + 1, AsmTokenType.at_curlyket, "");
                break;
            }
            case '^': {
                result = new TokenInfo(index + 1, AsmTokenType.at_hat, "");
                break;
            }
            default: {
                if (this.isWordStart(currentChar)) {
                    StringBuilder b = new StringBuilder();
                    b.append(currentChar);
                    ++index;
                    while (index < this.line.length()) {
                        char candidate = this.line.charAt(index);
                        if (!this.isWordEnd(candidate)) break;
                        b.append(candidate);
                        ++index;
                    }
                    result = new TokenInfo(index, AsmTokenType.at_word, b.toString());
                    break;
                }
                if (this.isDecimalInt(currentChar)) {
                    int imm_type_index = index + 1;
                    StringBuilder b = new StringBuilder();
                    b.append(currentChar);
                    ++index;
                    while (index < this.line.length()) {
                        char candidate = this.line.charAt(index);
                        if ((!this.isBaseImmediateChar(candidate) || index != imm_type_index) && !this.isDecimalInt(candidate) && !this.isHexInt(candidate)) break;
                        b.append(candidate);
                        ++index;
                    }
                    result = new TokenInfo(index, AsmTokenType.at_integer, b.toString());
                    break;
                }
                result = new TokenInfo(index, AsmTokenType.at_unknown, "");
            }
        }
        return result;
    }

    private ClientInterface.GetOperandStatus setRegister(String tokentext, Map<String, Long> map, ClientAsmOperand operand, AsmOperandType type) {
        Long regnum = map.get(tokentext);
        if (regnum != null) {
            operand.setType(type);
            operand.setValue(this.getOpaqueUintPointer(regnum));
            return ClientInterface.GetOperandStatus.agos_found;
        }
        return ClientInterface.GetOperandStatus.agos_notFound;
    }

    private ClientInterface.GetOperandStatus setRegisterContinueParse(String tokentext, Map<String, Long> map, ClientAsmOperand operand, AsmOperandType type) {
        ClientInterface.GetOperandStatus status = this.setRegister(tokentext, map, operand, type);
        if (status == ClientInterface.GetOperandStatus.agos_found) {
            this.nextToken();
        }
        return status;
    }

    private ClientInterface.GetOperandStatus setRegList(TokenInfo token, Map<String, Long> regmap, ClientAsmOperand operand, AsmOperandType type) {
        Long reglist = this.parseRegList(token, regmap);
        if (reglist == null) {
            return ClientInterface.GetOperandStatus.agos_notFound;
        }
        operand.setType(type);
        if (operand.isExtRegList()) {
            long eatList = reglist;
            int firstReg = -1;
            int count = 0;
            int i = 0;
            while (i < 31) {
                if (firstReg == -1) {
                    if ((eatList & 1L) == 1L) {
                        firstReg = i;
                        count = 1;
                    }
                } else {
                    if ((eatList & 1L) != 1L) break;
                    ++count;
                }
                eatList >>>= 1;
                ++i;
            }
            long encoded = 0x10000000 | count << 16 | firstReg << 0;
            operand.setValue(this.getOpaqueUintPointer(encoded));
        } else {
            operand.setValue(this.getOpaqueUintPointer(reglist));
        }
        this.nextToken();
        return ClientInterface.GetOperandStatus.agos_found;
    }

    private ClientInterface.GetOperandStatus setVectorRegister(String tokentext, Map<String, Long> regmap, ClientAsmOperand operand, AsmOperandType type) {
        String[] d = tokentext.split("\\.");
        String[] valid_types = new String[]{"B", "H", "S", "D"};
        Long lanes = 0L;
        if (d.length != 2) {
            return ClientInterface.GetOperandStatus.agos_notFound;
        }
        String lanes_string = d[1].replaceAll("\\D+", "");
        char arrangement_type = d[1].charAt(d[1].length() - 1);
        if (lanes_string.length() != 0) {
            lanes = Long.parseLong(lanes_string);
            operand.setArrangementType(arrangement_type, lanes);
        } else if (Arrays.asList(valid_types).contains(d[1])) {
            operand.setArrangementType(arrangement_type, lanes);
        } else {
            return ClientInterface.GetOperandStatus.agos_notFound;
        }
        this.nextToken();
        if (this.currentToken.tokenType == AsmTokenType.at_squarebra) {
            this.nextToken();
            operand.setScalarIndex(Integer.parseInt(this.currentToken.text));
            this.nextToken();
            this.nextToken();
        }
        operand.setType(type);
        return this.setRegister(d[0], regmap, operand, type);
    }

    @Override
    public ClientInterface.GetOperandStatus getOperand(ExpectedAsmOperandType expect, AsmInstruction asminstr, ClientAsmOperand operand) {
        if (expect.isSingleExpect()) {
            AsmOperandType expectedOpType = expect.getSingleExpect();
            return this.processAsmOperand(operand, this.currentToken, expectedOpType);
        }
        AsmOperandType[] asmOperandTypeArray = AsmOperandType.values();
        int n = asmOperandTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsmOperandType type = asmOperandTypeArray[n2];
            if (expect.isSet(type)) {
                ClientInterface.GetOperandStatus result = null;
                result = this.processAsmOperand(operand, this.currentToken, type);
                if (result == ClientInterface.GetOperandStatus.agos_found) {
                    return result;
                }
            }
            ++n2;
        }
        return ClientInterface.GetOperandStatus.agos_notFound;
    }

    protected ClientInterface.GetOperandStatus processAsmOperand(ClientAsmOperand operand, TokenInfo currentToken, AsmOperandType type) {
        switch (type) {
            case ao_armreg: 
            case ao_coproname: 
            case ao_coproreg: {
                return this.setRegisterContinueParse(currentToken.text, ARMRegNumMap, operand, type);
            }
            case ao_extreg_S: {
                return this.setRegisterContinueParse(currentToken.text, extRegSNumMap, operand, type);
            }
            case ao_extreg_D: {
                return this.setRegisterContinueParse(currentToken.text, extRegDNumMap, operand, type);
            }
            case ao_extreg_Q: {
                return this.setRegisterContinueParse(currentToken.text, extRegQNumMap, operand, type);
            }
            case ao_extreg_B: {
                return this.setRegisterContinueParse(currentToken.text, extRegBNumMap, operand, type);
            }
            case ao_extreg_H: {
                return this.setRegisterContinueParse(currentToken.text, extRegHNumMap, operand, type);
            }
            case ao_xreg: {
                return this.setRegisterContinueParse(currentToken.text, XRegNumMap, operand, type);
            }
            case ao_wreg: {
                return this.setRegisterContinueParse(currentToken.text, WRegNumMap, operand, type);
            }
            case ao_extreg_vector: {
                return this.setVectorRegister(currentToken.text, extRegVNumMap, operand, type);
            }
            case ao_imm: {
                Long immediate = this.parseImmediate(currentToken);
                if (immediate == null) break;
                operand.setType(AsmOperandType.ao_imm);
                operand.setValue(this.getOpaqueUintPointer(immediate));
                this.currentToken = this.computeCurrentToken();
                return ClientInterface.GetOperandStatus.agos_found;
            }
            case ao_wreg_list: {
                return this.setRegList(currentToken, WRegNumMap, operand, type);
            }
            case ao_xreg_list: {
                return this.setRegList(currentToken, XRegNumMap, operand, type);
            }
            case ao_armreglist: {
                return this.setRegList(currentToken, ARMRegNumMap, operand, type);
            }
            case ao_extreg_S_list: {
                return this.setRegList(currentToken, extRegSNumMap, operand, type);
            }
            case ao_extreg_D_list: {
                return this.setRegList(currentToken, extRegDNumMap, operand, type);
            }
            case ao_extreg_Q_list: {
                return this.setRegList(currentToken, extRegQNumMap, operand, type);
            }
            case ao_extreg_vector_list: {
                return this.parseSimdRegList(operand);
            }
            case ao_label: {
                return this.parsePCRelLabel(currentToken, operand, type);
            }
        }
        return ClientInterface.GetOperandStatus.agos_notFound;
    }

    private ClientInterface.GetOperandStatus parsePCRelLabel(TokenInfo currentToken, ClientAsmOperand operand, AsmOperandType type) {
        int currentIndex = currentToken.nextTokenIndex - currentToken.text.length();
        if (this.currentToken.tokenType == AsmTokenType.at_curlybra) {
            this.nextToken();
            if (this.currentToken.tokenType != AsmTokenType.at_word) {
                return ClientInterface.GetOperandStatus.agos_notFound;
            }
            if (!this.currentToken.text.equalsIgnoreCase("PC")) {
                return ClientInterface.GetOperandStatus.agos_notFound;
            }
            this.nextToken();
            if (this.currentToken.tokenType != AsmTokenType.at_curlyket) {
                return ClientInterface.GetOperandStatus.agos_notFound;
            }
            operand.setType(AsmOperandType.ao_label);
            operand.setValue(this.getOpaqueUintPointer(currentIndex - 1));
            return ClientInterface.GetOperandStatus.agos_found;
        }
        if (this.currentToken.tokenType == AsmTokenType.at_word) {
            operand.setType(AsmOperandType.ao_label);
            operand.setValue(this.getOpaqueUintPointer(currentIndex - 1));
            return ClientInterface.GetOperandStatus.agos_found;
        }
        return ClientInterface.GetOperandStatus.agos_notFound;
    }

    private ClientInterface.GetOperandStatus parseSimdRegList(ClientAsmOperand operand) {
        boolean isFirstReg = true;
        boolean isInRange = false;
        Long increment = 0L;
        Long lastRegSeen = 0L;
        Long count = 0L;
        Long firstReg = 0L;
        Long rangeStart = 0L;
        char arrangement_type = '\u0000';
        int lanes = 0;
        while (this.currentToken.tokenType != AsmTokenType.at_curlyket) {
            if (this.currentToken.tokenType == AsmTokenType.at_word) {
                String str = this.currentToken.text;
                if (str.toLowerCase().charAt(0) == 'v') {
                    String[] d = this.currentToken.text.split("\\.");
                    if (d.length != 2) {
                        return ClientInterface.GetOperandStatus.agos_notFound;
                    }
                    lastRegSeen = extRegVNumMap.get(d[0]);
                    if (lastRegSeen == null) {
                        return ClientInterface.GetOperandStatus.agos_notFound;
                    }
                    String lanes_string = d[1].replaceAll("\\D+", "");
                    arrangement_type = d[1].charAt(d[1].length() - 1);
                    if (lanes_string.length() != 0) {
                        lanes = Integer.parseInt(lanes_string);
                    }
                    if (isFirstReg) {
                        operand.setType(AsmOperandType.ao_extreg_vector_list);
                        firstReg = lastRegSeen;
                        isFirstReg = false;
                    } else if (increment == 0L) {
                        increment = isInRange ? Long.valueOf(1L) : (firstReg < lastRegSeen ? Long.valueOf(lastRegSeen - firstReg) : Long.valueOf((32L + lastRegSeen - firstReg) % 32L));
                    }
                    count = isInRange ? Long.valueOf(count + (lastRegSeen - rangeStart)) : Long.valueOf(count + 1L);
                }
                this.nextToken();
                continue;
            }
            if (this.currentToken.tokenType == AsmTokenType.at_comma || this.currentToken.tokenType == AsmTokenType.at_curlybra) {
                this.nextToken();
                continue;
            }
            if (this.currentToken.tokenType == AsmTokenType.at_minus) {
                isInRange = true;
                rangeStart = lastRegSeen;
                this.nextToken();
                continue;
            }
            return ClientInterface.GetOperandStatus.agos_notFound;
        }
        if (count == 1L) {
            increment = 1L;
        }
        this.nextToken();
        if (this.currentToken.tokenType == AsmTokenType.at_squarebra) {
            this.nextToken();
            operand.setScalarIndex(Integer.parseInt(this.currentToken.text));
            this.nextToken();
            this.nextToken();
        }
        if (arrangement_type == '\u0000') {
            return ClientInterface.GetOperandStatus.agos_syntaxError;
        }
        Long value = increment << 28 | count << 16 | firstReg << 0;
        operand.setValue(this.getOpaqueUintPointer(value));
        operand.setArrangementType(arrangement_type, lanes);
        return ClientInterface.GetOperandStatus.agos_found;
    }

    /*
     * Unable to fully structure code
     */
    private Long parseRegList(TokenInfo token, Map<String, Long> regmap) {
        armRegPrevNum = 0L;
        reglist = 0L;
        inRange = false;
        if (token.tokenType != AsmTokenType.at_curlybra) {
            return null;
        }
        peek = this.computeCurrentToken();
        if (peek.tokenType.equals((Object)AsmTokenType.at_word) && regmap.containsKey(peek.text)) ** GOTO lbl36
        return null;
lbl-1000:
        // 1 sources

        {
            switch (AsmLibClient.$SWITCH_TABLE$com$arm$debug$icodec$swig$AsmTokenType()[this.currentToken.tokenType.ordinal()]) {
                case 12: {
                    armRegNum = regmap.get(this.currentToken.text);
                    if (armRegNum == null) {
                        return null;
                    }
                    if (!inRange) {
                        reglist = reglist | 1L << (int)armRegNum.longValue();
                    } else {
                        i = armRegPrevNum;
                        while (i <= armRegNum) {
                            reglist = reglist | 1L << (int)i;
                            ++i;
                        }
                        inRange = false;
                    }
                    armRegPrevNum = armRegNum;
                    break;
                }
                case 5: {
                    inRange = false;
                    break;
                }
                case 4: {
                    inRange = true;
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    return null;
                }
            }
            this.nextToken();
lbl36:
            // 2 sources

            ** while (this.currentToken.tokenType != AsmTokenType.at_curlyket)
        }
lbl37:
        // 1 sources

        return reglist;
    }

    private Long parseImmediate(TokenInfo token) {
        int base;
        String s = token.text;
        if (s.toLowerCase().startsWith("0b")) {
            if (s.length() < 3) {
                return null;
            }
            s = s.substring(2);
            base = 2;
        } else if (s.toLowerCase().startsWith("0x")) {
            if (s.length() < 3) {
                return null;
            }
            s = s.substring(2);
            base = 16;
        } else {
            if (s.isEmpty()) {
                return null;
            }
            base = 10;
        }
        try {
            return new BigInteger(s, base).longValue();
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static void addSpecialReg(GenericRegisterModel model, GenericRegisterSpecial special, String name, Map<String, Long> dest) {
        if (SWIGicodec.genericRegisterSpecialExists(model, special)) {
            long genericNum = SWIGicodec.genericRegisterForSpecial(model, special);
            dest.put(name, genericNum);
            dest.put(name.toLowerCase(), genericNum);
        }
    }

    private static void initRegMap(int nregs, String name, Map<String, Long> regmap) {
        long i = 0L;
        while (i < 32L) {
            regmap.put(String.valueOf(name) + i, i);
            regmap.put(String.valueOf(name.toLowerCase()) + i, i);
            ++i;
        }
    }

    public SWIGTYPE_p_void getOpaqueUintPointer(long value) {
        SWIGTYPE_p_unsigned_int resgNum = SWIGicodec.new_uint_p();
        this.allocated.add(resgNum);
        SWIGicodec.uint_p_assign(resgNum, value);
        return SWIGicodec.uint_p_to_void_p(resgNum);
    }

    @Override
    public boolean diagnoseError(AsmError err) {
        if (this.error_caught) {
            return false;
        }
        this.failedToken = new TokenInfo(this.currentToken.nextTokenIndex - 1, this.currentToken.tokenType, this.currentToken.text);
        this.err = new AsmError(err.getType(), err.getExpectedTokenType());
        this.error_caught = true;
        return true;
    }

    public void raiseErrorExceptionExpectToken(AsmError err) throws FormattedException {
        AsmTokenType type = err.getExpectedTokenType();
        switch (type) {
            case at_comma: {
                throw new FormattedException((IMessage)Messages.ERRORS_COMMA_MISSING_A1106E);
            }
            case at_squarebra: {
                throw new FormattedException((IMessage)Messages.ERRORS_MISS_BRA_A1211E);
            }
            case at_squareket: {
                throw new FormattedException((IMessage)Messages.ERRORS_MISS_SQ_KET_A1169E);
            }
            case at_shriek: {
                throw new FormattedException((IMessage)Messages.ERRORS_SHRIEK_MISSING_A1244E);
            }
            case at_hash: {
                throw new FormattedException((IMessage)Messages.ERRORS_HASH_MISSING_A1189E);
            }
            case at_curlybra: {
                throw new FormattedException((IMessage)Messages.ERRORS_BRA_MISS_A1156E);
            }
            case at_curlyket: {
                throw new FormattedException((IMessage)Messages.ERRORS_KET_MISS_A1171E);
            }
            case at_integer: {
                throw new FormattedException((IMessage)Messages.ERRORS_BAD_DEC_A1406E);
            }
        }
        throw new FormattedException(Messages.GENERIC_UNHANDLED_ERROR_NC.format(""));
    }

    public void raiseErrorExceptionExpectOperand(AsmError err) throws FormattedException {
    }

    public void deallocate() {
        for (SWIGTYPE_p_unsigned_int p : this.allocated) {
            SWIGicodec.delete_uint_p(p);
        }
    }

    public void raiseErrorException() throws FormattedException {
        try {
            switch (this.err.getType()) {
                case ae_badInstr: 
                case ae_instrNotValidInISA: {
                    throw new FormattedException((IMessage)Messages.ERRORS_INSTR_NOT_SUPPORTED_ON_THIS_TARGET_A1618E);
                }
                case ae_expectToken: {
                    this.raiseErrorExceptionExpectToken(this.err);
                    break;
                }
                case ae_expectOperand: {
                    throw new FormattedException((IMessage)Messages.ERRORS_SPECIFIED_OPERAND_NOT_ALLOWED_A1913E);
                }
                case ae_badShift: {
                    throw new FormattedException((IMessage)Messages.ERRORS_BAD_SHIFT_A1147E);
                }
                case ae_expectBEorLE: {
                    throw new FormattedException(Messages.ERRORS_EXPECT_WORDS_A1838E.format("BE", "LE"));
                }
                case ae_expectROR: {
                    throw new FormattedException(Messages.P1LINE_EXPECT_WORD_A1500E.format("ROR"));
                }
                case ae_expectLSL: {
                    throw new FormattedException(Messages.P1LINE_EXPECT_WORD_A1500E.format("LSL"));
                }
                case ae_expectASR: {
                    throw new FormattedException(Messages.P1LINE_EXPECT_WORD_A1500E.format("ASR"));
                }
                case ae_noShiftAllowed: {
                    throw new FormattedException((IMessage)Messages.ERRORS_SHIFT_NOT_ALLOWED_A1856E);
                }
                case ae_shiftTypeNotAllowed: {
                    throw new FormattedException((IMessage)Messages.ERRORS_SHIFT_TYPE_NOT_ALLOWED_A1857E);
                }
                case ae_expectFlagsAIF: {
                    throw new FormattedException(Messages.ERRORS_EXPECTED_FLAGS_A1574E.format("AIF"));
                }
                case ae_expectSpecReg: 
                case ae_badSpecReg: {
                    throw new FormattedException(Messages.ERRORS_BADPSR_A1715E.format(this.failedToken.text));
                }
                case ae_expectPsrFlags: {
                    throw new FormattedException((IMessage)Messages.ERRORS_BAD_CSPSR_FIELDS_A1846E);
                }
                case ae_expectApsrBits: {
                    throw new FormattedException((IMessage)Messages.EXPR_APSR_BADFIELD_A1713E);
                }
                case ae_deprecatedSpecRegNoFields: 
                case ae_deprecatedSpecRegFieldAll: {
                    throw new FormattedException((IMessage)Messages.EXPR_PSR_DEPRECATED_CF_A1450E);
                }
                case ae_deprecatedSpecRegFieldFlg: {
                    throw new FormattedException((IMessage)Messages.EXPR_PSR_DEPRECATED_F_A1448E);
                }
                case ae_deprecatedSpecRegFieldCtl: {
                    throw new FormattedException((IMessage)Messages.EXPR_PSR_DEPRECATED_C_A1449E);
                }
                case ae_badSpecRegFlags: {
                    throw new FormattedException((IMessage)Messages.EXPR_MRS_DOES_NOT_SELECT_FIELDS_A1261E);
                }
                case ae_expectBarrierOption: {
                    throw new FormattedException((IMessage)Messages.ERRORS_UNKNOWN_MEM_BARRIER_OPTION_A1753E);
                }
                case ae_expectCondition: {
                    throw new FormattedException(Messages.ERRORS_BAD_CONDITION_CODE_A1541E.format(new Object[0]));
                }
                case ae_expectExtSysReg: {
                    throw new FormattedException((IMessage)Messages.ERRORS_BAD_VFPOP_NEON_SYSTEM_REGISTER_A1769E);
                }
                case ae_noVcvtFixed: {
                    throw new FormattedException((IMessage)Messages.ERRORS_CONVERT_FIXED_POINT_A1774E);
                }
                case ae_noVcvtTypes: {
                    throw new FormattedException((IMessage)Messages.ERRORS_CONVERT_NOT_POSSIBLE_A1775E);
                }
                case ae_badType: {
                    throw new FormattedException((IMessage)Messages.ERRORS_TYPE_NOT_MATCHED_A1683E);
                }
                case ae_incompleteType: {
                    throw new FormattedException((IMessage)Messages.ERRORS_MISSING_DATA_TYPES_A1835E);
                }
                case ae_tooManyTypes: {
                    throw new FormattedException((IMessage)Messages.ERRORS_TOO_MANY_DATA_TYPES_A1668E);
                }
                case ae_badVldstAlign: {
                    throw new FormattedException((IMessage)Messages.ERRORS_BAD_VLDST_ALIGN_A1841E);
                }
                case ae_noVstAllLanes: {
                    throw new FormattedException((IMessage)Messages.ERRORS_VST_NOT_ALLOWED_A1615E);
                }
                case ae_badScalarReg: {
                    break;
                }
                case ae_expectScalarDest: {
                    throw new FormattedException((IMessage)Messages.ERRORS_EXPECT_SCALAR_DEST_A1839E);
                }
                case ae_expectScalarSource1: {
                    throw new FormattedException((IMessage)Messages.ERRORS_EXPECT_SCALAR_SOURCE1_A1840E);
                }
                case ae_expectScalarSource2: {
                    throw new FormattedException((IMessage)Messages.ERRORS_DM_MUST_BE_SCALAR_A1706E);
                }
                case ae_expectTypeDest: {
                    throw new FormattedException(Messages.ERRORS_EXPECT_DATA_TYPE_DEST_A1836E.format(new Object[0]));
                }
                case ae_expectTypeDestDowngradable: 
                case ae_expectTypeSource1Downgradable: {
                    break;
                }
                case ae_expectTypeSource1: {
                    throw new FormattedException(Messages.ERRORS_EXPECT_DATA_TYPE_SOURCE1_A1837E.format(new Object[0]));
                }
                case ae_scalarIndexOutOfRange: {
                    throw new FormattedException((IMessage)Messages.ERRORS_SCALAR_INDEX_OUT_OF_RANGE_A1849E);
                }
                case ae_noDpImmMode: {
                    throw new FormattedException((IMessage)Messages.ERRORS_BAD_SYNTAX_FOR_PSEUDO_A1842E);
                }
                case ae_writebackNoOffset: {
                    throw new FormattedException((IMessage)Messages.ERRORS_WRITEBACK_AMBIGUOUS_A1810E);
                }
                case ae_disallowType: {
                    throw new FormattedException((IMessage)Messages.ERRORS_DATA_TYPE_NOT_ALLOWED_A1669E);
                }
                case ae_nonUalInstrQuals: {
                    throw new FormattedException((IMessage)Messages.ERRORS_NON_UAL_QUALIFIERS_A1850E);
                }
                case ae_noHashImmediate: {
                    throw new FormattedException((IMessage)Messages.ERRORS_HASHLESS_CONSTANT_A1865W);
                }
                case ae_unsupportedSpecReg: {
                    throw new FormattedException((IMessage)Messages.ERRORS_UNSUPPORTED_SPEC_REG_A1902E);
                }
                case ae_readOnlySpecReg: {
                    throw new FormattedException((IMessage)Messages.ERRORS_REGISTER_READ_ONLY_A1805E);
                }
                case ae_writeOnlySpecReg: {
                    throw new FormattedException((IMessage)Messages.ERRORS_REGISTER_WRITE_ONLY_A1806E);
                }
                case ae_expectArrangementDest: {
                    throw new FormattedException((IMessage)Messages.ERRORS_EXPECT_ARRANGEMENT_DEST_A1918E);
                }
                case ae_expectArrangementSource1: {
                    throw new FormattedException((IMessage)Messages.ERRORS_EXPECT_ARRANGEMENT_SOURCE1_A1919E);
                }
                case ae_expectArrangementSource2: {
                    throw new FormattedException((IMessage)Messages.ERRORS_EXPECT_ARRANGEMENT_SOURCE2_A1920E);
                }
                case ae_expectNumLanes: {
                    throw new FormattedException((IMessage)Messages.ERRORS_EXPECTED_NUMBER_OF_LANES_A1924E);
                }
                case ae_badDestOperand: 
                case ae_badSource1Operand: 
                case ae_badSource2Operand: {
                    throw new FormattedException((IMessage)Messages.ERRORS_UN_EXP_OP_A1152E);
                }
                default: {
                    throw new FormattedException(Messages.GENERIC_UNHANDLED_ERROR_NC.format("DS5 Inline Assembler"));
                }
            }
        }
        finally {
            this.err.delete();
            this.err = null;
        }
    }

    private boolean isDecimalInt(char candidate) {
        return candidate >= '0' && candidate <= '9';
    }

    private boolean isHexInt(char candidate) {
        return candidate >= '0' && candidate <= '9' || candidate >= 'a' && candidate <= 'f' || candidate >= 'A' && candidate <= 'F';
    }

    private boolean isBaseImmediateChar(char candidate) {
        return candidate == 'x' || candidate == 'b';
    }

    private boolean isWordStart(char candidate) {
        return candidate >= 'A' && candidate <= 'Z' || candidate >= 'a' && candidate <= 'z' || candidate == '_' || candidate == '.' || candidate == '$';
    }

    private boolean isWordEnd(char candidate) {
        return candidate >= 'A' && candidate <= 'Z' || candidate >= 'a' && candidate <= 'z' || candidate >= '0' && candidate <= '9' || candidate == '_' || candidate == '.' || candidate == '$';
    }

    private static final class TokenInfo {
        public int nextTokenIndex;
        public final AsmTokenType tokenType;
        public String text;

        public TokenInfo(int index, AsmTokenType tokenType, String text) {
            this.nextTokenIndex = index;
            this.tokenType = tokenType;
            this.text = text;
        }
    }
}

