/*
 * Decompiled with CFR 0.152.
 */
package com.arm.debug.icodec;

import com.arm.debug.icodec.Instruction;
import com.arm.debug.icodec.Messages;
import com.arm.debug.icodec.swig.Architecture;
import com.arm.debug.icodec.swig.GenericRegisterModel;
import com.arm.debug.icodec.swig.IcodecWrapper;
import com.arm.debug.icodec.swig.TargetArch;
import com.arm.text.FormattedException;

public class InstructionDecoder {
    public Instruction decodeA64(long encodedInstruction, Architecture arch) throws FormattedException {
        return this.decode(encodedInstruction, arch, GenericRegisterModel.grm_aarch64, TargetArch.FeatureStateSelection.feature_A64, "A64");
    }

    public Instruction decodeA32(long encodedInstruction, Architecture arch) throws FormattedException {
        return this.decode(encodedInstruction, arch, GenericRegisterModel.grm_aarch32, TargetArch.FeatureStateSelection.feature_ARM, "A32");
    }

    public Instruction decodeThumb(long encodedInstruction, Architecture arch) throws FormattedException {
        return this.decode(encodedInstruction, arch, GenericRegisterModel.grm_aarch32, TargetArch.FeatureStateSelection.feature_Thumb, "T32");
    }

    public Instruction decodeT2EE(long encodedInstruction, Architecture arch) throws FormattedException {
        return this.decode(encodedInstruction, arch, GenericRegisterModel.grm_aarch32, TargetArch.FeatureStateSelection.feature_T2EE, "T32EE");
    }

    /*
     * Loose catch block
     */
    public Instruction decode(long encodedInstruction, Architecture arch, GenericRegisterModel regModel, TargetArch.FeatureStateSelection selection, String instSetName) throws FormattedException {
        Throwable throwable = null;
        Object var8_8 = null;
        try (TargetArch targetArch = new TargetArch(arch);){
            Instruction instruction;
            IcodecWrapper icodec;
            Throwable throwable2;
            block21: {
                if (!targetArch.select(selection)) {
                    String archName = arch.getCore().name();
                    if (archName.length() > 5) {
                        archName = archName.substring(5);
                    }
                    throw new FormattedException(Messages.INSTRUCTION_SET_NOT_SUPPORTED.format(archName, instSetName));
                }
                throwable2 = null;
                Object var11_14 = null;
                icodec = new IcodecWrapper(targetArch);
                instruction = new Instruction(icodec.decode(encodedInstruction), regModel, (int)encodedInstruction);
                if (icodec == null) break block21;
                icodec.close();
            }
            return instruction;
            {
                catch (Throwable throwable3) {
                    try {
                        if (icodec != null) {
                            icodec.close();
                        }
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }
}

