/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javafx.application.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class WeakProxyImageProvider
implements IImageProvider {
    private @NonNull WeakReference<@Nullable IImageProvider> imageProvider;

    public WeakProxyImageProvider(@NonNull IImageProvider imageProvider) {
        this.imageProvider = new WeakReference<IImageProvider>(imageProvider);
    }

    public void updateImageProvider(@NonNull IImageProvider newImageProvider) {
        this.imageProvider = new WeakReference<IImageProvider>(newImageProvider);
    }

    public @NonNull RGBAImageData getImageData() throws IImageProvider.ImageDataUnavailableException, IOException, IImageProvider.ImageConversionException {
        assert (!Platform.isFxApplicationThread());
        IImageProvider provider = (IImageProvider)this.imageProvider.get();
        if (provider == null) {
            throw new IImageProvider.ImageDataUnavailableException("Image has been garbage collected. This should only happen if the target has been closed.");
        }
        return provider.getImageData();
    }
}

