/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import javafx.beans.value.ChangeListener;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StyleOverridableTableRow<T>
implements Callback<TableView<T>, TableRow<T>> {
    private final @NonNull Callback<TableView<T>, TableRow<T>> originalFactory;
    private final @NonNull IStyleUpdater<T> styleUpdater;

    public StyleOverridableTableRow(@Nullable Callback<TableView<T>, TableRow<T>> originalFactory, @NonNull IStyleUpdater<T> styleUpdater) {
        this.originalFactory = originalFactory != null ? originalFactory : table -> new TableRow();
        this.styleUpdater = styleUpdater;
    }

    public StyleOverridableTableRow(@NonNull IStyleUpdater<T> styleUpdater) {
        this(null, styleUpdater);
    }

    public TableRow<T> call(TableView<T> tableView) {
        TableRow row = (TableRow)this.originalFactory.call(tableView);
        ChangeListener handler = (obs, oldValue, newValue) -> this.update((TableRow<T>)row, (Number)oldValue, (Number)newValue);
        row.indexProperty().addListener(handler);
        return row;
    }

    private void update(TableRow<T> row, Number oldValue, Number newValue) {
        this.styleUpdater.update(row, oldValue, newValue);
    }

    public static interface IStyleUpdater<T> {
        public void update(TableRow<T> var1, Number var2, Number var3);
    }
}

