/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.ui.controllers.ShadersViewListItem;
import com.arm.mgd.ui.views.widgets.TableCellContextualMessage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.Nullable;

public class ShadersViewTableCellFactory<S, T>
implements Callback<TableColumn<S, T>, TableCell<S, T>> {
    private final String format;
    private final List<TableCellContextualMessage<ShadersViewListItem>> contextualMessageList;
    private final NumberFormat numberFormat = NumberFormat.getInstance();

    public ShadersViewTableCellFactory(@Nullable String format) {
        this.format = format;
        this.contextualMessageList = new ArrayList<TableCellContextualMessage<ShadersViewListItem>>();
    }

    public void addContextualMessage(TableCellContextualMessage<ShadersViewListItem> contextualMessage) {
        this.contextualMessageList.add(contextualMessage);
    }

    public TableCell<S, T> call(TableColumn<S, T> column) {
        return new TableCell<S, T>(){
            private final Tooltip cachedTooltip = new Tooltip();

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    super.setText("");
                } else if (item == null) {
                    super.setText("N/A");
                } else if (item instanceof Number) {
                    if (!$assertionsDisabled && !Platform.isFxApplicationThread()) {
                        throw new AssertionError();
                    }
                    super.setText(ShadersViewTableCellFactory.this.numberFormat.format(item));
                } else {
                    super.setText(ShadersViewTableCellFactory.this.format != null ? String.format(ShadersViewTableCellFactory.this.format, item) : item.toString());
                }
                Tooltip tooltip = null;
                StringBuilder wholeTooltipTextBuilder = new StringBuilder();
                if (this.getTableRow() == null) {
                    return;
                }
                Object rowItem = this.getTableRow().getItem();
                if (rowItem instanceof ShadersViewListItem) {
                    ShadersViewListItem shaderViewListItem = (ShadersViewListItem)rowItem;
                    for (TableCellContextualMessage<ShadersViewListItem> contextualMessage : ShadersViewTableCellFactory.this.contextualMessageList) {
                        String tooltipText = contextualMessage.getText(shaderViewListItem);
                        if (wholeTooltipTextBuilder.length() > 0 && tooltipText.length() > 0) {
                            wholeTooltipTextBuilder.append("\n");
                        }
                        wholeTooltipTextBuilder.append(tooltipText);
                    }
                    if (wholeTooltipTextBuilder.length() > 0) {
                        tooltip = this.cachedTooltip;
                        tooltip.setText(wholeTooltipTextBuilder.toString());
                    }
                }
                if (this.getTooltip() != tooltip) {
                    this.setTooltip(tooltip);
                }
            }
        };
    }
}

