/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.ui.controllers.ShadersViewController;
import com.arm.mgd.ui.controllers.ShadersViewListItem;
import com.arm.mgd.ui.views.widgets.TableCellContextualMessage;
import org.eclipse.jdt.annotation.Nullable;

public class NotAvailableStatisticsContextualMessage
implements TableCellContextualMessage<ShadersViewListItem> {
    private final ShadersViewController controller;
    private final String statisticName;

    public NotAvailableStatisticsContextualMessage(ShadersViewController controller, String statisticName) {
        this.controller = controller;
        this.statisticName = statisticName;
    }

    @Override
    public String getText(@Nullable ShadersViewListItem shadersViewListItem) {
        GlShaderAsset shaderAsset;
        String messageText = "";
        if (shadersViewListItem != null && (shaderAsset = shadersViewListItem.getShader()) != null) {
            FrameRenderPass renderPass;
            if (shaderAsset.getType().equals(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER) && (renderPass = this.controller.getCurrentRenderPass()) != null && !renderPass.getCaptureMode().equals((Object)FramebufferFeature.CaptureMode.FRAGMENT_COUNT)) {
                messageText = "Fragment count statistics were not captured for this frame.";
                return messageText;
            }
            if (this.statisticName != null && shadersViewListItem.totalCyclesProperty().getValue() == null) {
                messageText = "Required shader statistics are not available to calculate " + this.statisticName + ".";
            }
        }
        return messageText;
    }
}

