/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.core.offlinecompiler.GlShaderCompilerError;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.ui.controllers.ShadersViewListItem;
import com.arm.mgd.ui.views.widgets.TableCellContextualMessage;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NotAvailableShaderCompilerStatisticsContextualMessage
implements TableCellContextualMessage<ShadersViewListItem> {
    @Override
    public String getText(@NonNull ShadersViewListItem shadersViewListItem) {
        String reasonMessage = "";
        @Nullable GlShaderStats shaderStats = (GlShaderStats)shadersViewListItem.shaderStatsProperty().get();
        if (shaderStats == null) {
            reasonMessage = "Statistics have not yet been calculated for this shader.";
        } else {
            switch (shaderStats.getStatus()) {
                case COMPILED_WITH_ERRORS: {
                    List errors = shaderStats.getErrorMessages();
                    List warnings = shaderStats.getWarningMessages();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Shader failed to compile:");
                    for (GlShaderCompilerError glShaderCompilerError : warnings) {
                        stringBuffer.append("\n\t" + glShaderCompilerError.getErrorText());
                    }
                    for (GlShaderCompilerError glShaderCompilerError : errors) {
                        stringBuffer.append("\n\t" + glShaderCompilerError.getErrorText());
                    }
                    reasonMessage = stringBuffer.toString();
                    break;
                }
                case FAILED_TO_RUN_COMPILER: {
                    reasonMessage = "Unable to run the Mali Offline Compiler.";
                }
            }
        }
        return reasonMessage;
    }
}

