/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.ui.utils.JavaFXImageLoader;
import com.arm.mgd.ui.utils.RGBAImage;
import com.arm.mgd.utils.NullUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImageTableCellFactory<T>
implements Callback<TableColumn<T, IImageProvider>, TableCell<T, IImageProvider>> {
    private final @NonNull ReadOnlyObjectProperty<RGBAImage.AlphaMode> alphaModeProperty;
    private final @NonNull ExecutorService executor;
    private static final @NonNull PseudoClass IMAGE_LOADED_BACKGROUND = (PseudoClass)NullUtils.neverNull((Object)PseudoClass.getPseudoClass((String)"texturesViewImageBackground"));
    private static final @NonNull PseudoClass IMAGE_LOAD_ERROR = (PseudoClass)NullUtils.neverNull((Object)PseudoClass.getPseudoClass((String)"texturesViewImageNotAvailable"));

    public ImageTableCellFactory(@NonNull ReadOnlyObjectProperty<RGBAImage.AlphaMode> alphaModeProperty, @NonNull ExecutorService executor) {
        this.alphaModeProperty = alphaModeProperty;
        this.executor = executor;
    }

    public TableCell<T, IImageProvider> call(TableColumn<T, IImageProvider> column) {
        ImageTableCell<T> imageTableCell = new ImageTableCell<T>();
        imageTableCell.bindCellSizeToColumnWidth(column);
        return imageTableCell;
    }

    private static class ImageLoader
    extends JavaFXImageLoader {
        private final @NonNull AtomicBoolean isCancelled = new AtomicBoolean();

        private ImageLoader(@NonNull IImageProvider imageProvider) {
            super(imageProvider);
        }
    }

    private class ImageTableCell<S>
    extends TableCell<S, IImageProvider> {
        private final @NonNull ObjectProperty<@Nullable IImageProvider> imageProviderProperty = new SimpleObjectProperty();
        private final @NonNull ObjectProperty<@Nullable ImageLoader> imageLoaderProperty = new SimpleObjectProperty();
        private final @NonNull Tooltip tooltip = new Tooltip();
        private final @NonNull StringProperty imageLoadError = (StringProperty)NullUtils.neverNull((Object)this.tooltip.textProperty());
        private final @NonNull ImageView imageView = new ImageView();
        private final @NonNull ProgressIndicator progressIndicator;
        private final @NonNull StackPane pane;

        public ImageTableCell() {
            this.imageView.setPreserveRatio(true);
            this.progressIndicator = new ProgressIndicator();
            this.progressIndicator.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.progressIndicator.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.progressIndicator.setScaleShape(true);
            this.progressIndicator.setCenterShape(true);
            this.pane = new StackPane(new Node[]{this.progressIndicator, this.imageView});
            this.pane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.pane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.pane.setAlignment(Pos.CENTER);
            this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            this.setAlignment(Pos.CENTER);
            this.getStyleClass().add((Object)"image-table-cell");
            this.imageProviderProperty.addListener((observable, oldValue, newValue) -> {
                ImageLoader newLoader;
                StackPane graphic;
                if (newValue == null) {
                    graphic = null;
                    newLoader = null;
                } else {
                    graphic = this.pane;
                    newLoader = new ImageLoader((IImageProvider)newValue);
                }
                this.setGraphic((Node)graphic);
                this.imageLoaderProperty.set((Object)newLoader);
            });
            this.imageLoaderProperty.addListener((observable, oldValue, newValue) -> {
                if (oldValue != null) {
                    oldValue.isCancelled.set(true);
                }
                this.updateImage();
            });
            ImageTableCellFactory.this.alphaModeProperty.addListener((observable, oldValue, newValue) -> this.updateImage());
            this.imageLoadError.addListener((observable, oldValue, newValue) -> {
                String error = newValue != null && !newValue.isEmpty() ? newValue : null;
                TableRow row = this.getTableRow();
                if (row != null) {
                    if (error != null) {
                        row.setTooltip(this.tooltip);
                        row.pseudoClassStateChanged(IMAGE_LOAD_ERROR, true);
                    } else {
                        row.setTooltip(null);
                        row.pseudoClassStateChanged(IMAGE_LOAD_ERROR, false);
                    }
                }
            });
            BooleanBinding hasFailedToLoadImage = this.imageLoadError.isNotEmpty();
            BooleanBinding hasLoadedImage = this.imageView.imageProperty().isNotNull();
            this.imageView.visibleProperty().bind((ObservableValue)hasLoadedImage);
            this.imageView.visibleProperty().addListener((observable, oldValue, newValue) -> this.pseudoClassStateChanged(IMAGE_LOADED_BACKGROUND, (boolean)newValue));
            this.progressIndicator.visibleProperty().bind((ObservableValue)hasLoadedImage.not().and((ObservableBooleanValue)hasFailedToLoadImage.not()));
        }

        protected void updateItem(IImageProvider imageProvider, boolean empty) {
            super.updateItem((Object)imageProvider, empty);
            this.imageProviderProperty.set((Object)(empty ? null : imageProvider));
        }

        private void updateImage() {
            assert (Platform.isFxApplicationThread());
            this.imageView.setImage(null);
            this.imageLoadError.set(null);
            ImageLoader loader = (ImageLoader)this.imageLoaderProperty.get();
            RGBAImage.AlphaMode alphaMode = (RGBAImage.AlphaMode)((Object)ImageTableCellFactory.this.alphaModeProperty.get());
            if (loader != null && alphaMode != null) {
                ImageTableCellFactory.this.executor.execute(() -> {
                    if (imageLoader.isCancelled.get()) {
                        return;
                    }
                    Image image = null;
                    boolean isFlipped = false;
                    String loadError = null;
                    try {
                        JavaFXImageLoader.JavaFXImage javaFXImage = loader.getImage(alphaMode);
                        image = javaFXImage.image;
                        isFlipped = javaFXImage.rawImage.isFlipped();
                    }
                    catch (Throwable t) {
                        loadError = t.getMessage();
                    }
                    Image finalImage = image;
                    boolean finalIsFlipped = isFlipped;
                    String finalLoadError = loadError;
                    Platform.runLater(() -> {
                        RGBAImage.AlphaMode newAlphaMode = (RGBAImage.AlphaMode)((Object)((Object)((Object)ImageTableCellFactory.this.alphaModeProperty.get())));
                        if (!imageLoader.isCancelled.get() && newAlphaMode == alphaMode) {
                            this.imageView.setImage(finalImage);
                            this.imageView.setScaleY((double)(finalIsFlipped ? -1 : 1));
                            this.imageLoadError.set((Object)finalLoadError);
                        }
                    });
                });
            }
        }

        private void bindCellSizeToColumnWidth(TableColumn<S, IImageProvider> column) {
            this.prefWidthProperty().bind((ObservableValue)column.widthProperty());
            this.prefHeightProperty().bind((ObservableValue)column.widthProperty());
            this.pane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
            this.pane.prefHeightProperty().bind((ObservableValue)this.widthProperty());
            this.progressIndicator.prefWidthProperty().bind((ObservableValue)this.pane.widthProperty());
            this.progressIndicator.prefHeightProperty().bind((ObservableValue)this.pane.widthProperty());
            this.imageView.fitWidthProperty().bind((ObservableValue)this.pane.widthProperty());
            this.imageView.fitHeightProperty().bind((ObservableValue)this.pane.widthProperty());
        }
    }
}

