/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.ui.controllers.TraceOutlineItem;
import com.arm.mgd.ui.views.widgets.GraphicsContextStyleMapper;
import javafx.css.PseudoClass;
import javafx.scene.control.TreeCell;
import org.eclipse.jdt.annotation.NonNull;

public class GraphicsContextColouredTreeCell
extends TreeCell<TraceOutlineItem> {
    private @NonNull PseudoClass currentColour = GraphicsContextStyleMapper.getDefaultContextPseudoClass();

    public GraphicsContextColouredTreeCell() {
        this.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.pseudoClassStateChanged(this.currentColour, false);
            } else {
                this.updateStyle((TraceOutlineItem)this.getItem(), this.emptyProperty().getValue());
            }
        });
    }

    protected void updateItem(TraceOutlineItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.updateStyle(item, empty);
    }

    private void updateStyle(TraceOutlineItem item, boolean empty) {
        INavigationElement<?> navigationElement;
        this.pseudoClassStateChanged(this.currentColour, false);
        if (item != null && !empty && (navigationElement = item.getItem()) != null && navigationElement instanceof FrameRenderPass) {
            GraphicsContext graphicsContext = ((FrameRenderPass)navigationElement).getGraphicsContext();
            this.currentColour = GraphicsContextStyleMapper.getContextPseudoClass(graphicsContext.getIndex());
            this.pseudoClassStateChanged(this.currentColour, true);
        }
    }
}

