/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.ui.views.widgets.GraphicsContextStyleMapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GraphicsContextColouredTableCell<T>
extends TableCell<FunctionCall, T> {
    private final @NonNull SimpleObjectProperty<@Nullable PseudoClass> currentColour = new SimpleObjectProperty();
    private final @Nullable StringConverter<T> stringConverter;

    public GraphicsContextColouredTableCell() {
        this.stringConverter = null;
    }

    public GraphicsContextColouredTableCell(@NonNull StringConverter<T> stringConverter) {
        this.stringConverter = stringConverter;
    }

    public static <T> Callback<TableColumn<FunctionCall, T>, TableCell<FunctionCall, T>> forTableColumn(@NonNull StringConverter<T> converter) {
        return list -> new GraphicsContextColouredTableCell(converter);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        GraphicsContextColouredTableCell.updateTableCellColour(this, this.currentColour);
        if (item != null && !empty) {
            this.setText(this.stringConverter != null ? this.stringConverter.toString(item) : item.toString());
        } else {
            this.setText(null);
        }
    }

    public static void updateTableCellColour(@NonNull TableCell<FunctionCall, ?> tableCell, @NonNull SimpleObjectProperty<@Nullable PseudoClass> currentColourProperty) {
        PseudoClass currentColour;
        FrameRenderPass frameRenderPass;
        Frame parentFrame;
        FunctionCall fc;
        PseudoClass newColour = null;
        if (tableCell.getTableRow() != null && (fc = (FunctionCall)tableCell.getTableRow().getItem()) != null && (parentFrame = fc.getParentFrame()) != null && (frameRenderPass = parentFrame.getRenderPassFor(fc)) != null) {
            GraphicsContext graphicsContext = frameRenderPass.getGraphicsContext();
            newColour = GraphicsContextStyleMapper.getContextPseudoClass(graphicsContext.getIndex());
        }
        if (newColour == null) {
            newColour = GraphicsContextStyleMapper.getDefaultContextPseudoClass();
        }
        if (newColour != (currentColour = (PseudoClass)currentColourProperty.get())) {
            if (currentColour != null) {
                tableCell.pseudoClassStateChanged(currentColour, false);
            }
            tableCell.pseudoClassStateChanged(newColour, true);
            currentColourProperty.set((Object)newColour);
        }
    }
}

