/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.web.WebView;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ContextMenuHelper {
    public static <T> @NonNull MenuItem addItem(@NonNull ContextMenu contextMenu, @NonNull ICommandDispatcher<? extends T> dispatcher, @NonNull ICommand<? super T> command) {
        return ContextMenuHelper.addItem(contextMenu, null, dispatcher, command);
    }

    public static <T> @NonNull MenuItem addItem(@NonNull ContextMenu contextMenu, @Nullable KeyCodeCombination keyCombo, @NonNull ICommandDispatcher<? extends T> dispatcher, @NonNull ICommand<? super T> command) {
        return ContextMenuHelper.addItem(contextMenu, command.getLabel(), keyCombo, (EventHandler<ActionEvent>)((EventHandler)event -> dispatcher.dispatchCommand(command)));
    }

    public static @NonNull MenuItem addItem(@NonNull ContextMenu contextMenu, @NonNull String label, @NonNull EventHandler<ActionEvent> eventHandler) {
        return ContextMenuHelper.addItem(contextMenu, label, null, eventHandler);
    }

    public static @NonNull MenuItem addItem(@NonNull ContextMenu contextMenu, @NonNull String label, @Nullable KeyCodeCombination keyCombo, @NonNull EventHandler<ActionEvent> eventHandler) {
        MenuItem newMenuItem = new MenuItem(label);
        newMenuItem.setOnAction(event -> Platform.runLater(() -> eventHandler.handle(event)));
        if (keyCombo != null) {
            newMenuItem.setAccelerator((KeyCombination)keyCombo);
        }
        contextMenu.getItems().add((Object)newMenuItem);
        return newMenuItem;
    }

    public static <T> @NonNull MenuItem addCheckMenuItem(@NonNull ContextMenu contextMenu, @NonNull String id, @NonNull ICommandDispatcher<? extends T> dispatcher, @NonNull ICommand<? super T> command) {
        CheckMenuItem newMenuItem = new CheckMenuItem(command.getLabel());
        newMenuItem.setId(id);
        newMenuItem.setOnAction(event -> Platform.runLater(() -> dispatcher.dispatchCommand(command)));
        contextMenu.getItems().add((Object)newMenuItem);
        return newMenuItem;
    }

    public static void setContextMenu(@NonNull Node node, @NonNull ContextMenu menu) {
        node.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.CONTEXT_MENU || keyEvent.getCode() == KeyCode.F10 && keyEvent.isShiftDown()) {
                Bounds bounds = node.localToScreen(node.getBoundsInLocal());
                menu.show(node, bounds.getMinX(), bounds.getMinY());
            } else if (keyEvent.getCode() == KeyCode.ESCAPE && menu.isShowing()) {
                keyEvent.consume();
            }
        });
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                menu.show(node, mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
            if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                menu.hide();
            }
        });
        node.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                menu.hide();
            }
        });
        if (node instanceof Control) {
            node.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    ((Control)node).setContextMenu(menu);
                } else {
                    ((Control)node).setContextMenu(null);
                }
            });
        }
        node.addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, Event::consume);
    }

    public static void createAndSetContextMenuForTextInputField(@NonNull TextInputControl textControl, boolean isReadOnly) {
        ContextMenu menu = new ContextMenu();
        if (!isReadOnly) {
            MenuItem undo = new MenuItem("Undo");
            undo.setOnAction(e -> textControl.undo());
            undo.disableProperty().bind((ObservableValue)textControl.undoableProperty().not());
            undo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            menu.getItems().add((Object)undo);
            MenuItem cut = new MenuItem("Cut");
            cut.setOnAction(e -> textControl.cut());
            cut.disableProperty().bind((ObservableValue)textControl.selectedTextProperty().isEmpty());
            cut.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            menu.getItems().add((Object)cut);
        }
        MenuItem copy = new MenuItem("Copy");
        copy.setOnAction(e -> textControl.copy());
        copy.disableProperty().bind((ObservableValue)textControl.selectedTextProperty().isEmpty());
        copy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        menu.getItems().add((Object)copy);
        if (!isReadOnly) {
            MenuItem paste = new MenuItem("Paste");
            paste.setOnAction(e -> textControl.paste());
            paste.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
            menu.getItems().add((Object)paste);
            MenuItem delete = new MenuItem("Delete");
            delete.setOnAction(e -> {
                IndexRange selection = textControl.getSelection();
                textControl.deleteText(selection.getStart(), selection.getEnd());
            });
            delete.disableProperty().bind((ObservableValue)textControl.selectedTextProperty().isEmpty());
            menu.getItems().add((Object)delete);
        }
        MenuItem selectAll = new MenuItem("Select All");
        selectAll.setOnAction(e -> textControl.selectAll());
        menu.getItems().add((Object)selectAll);
        ContextMenuHelper.setContextMenu((Node)textControl, menu);
    }

    public static void createAndSetContextMenuForWebView(@NonNull WebView webView) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem copy = new MenuItem("Copy");
        copy.setOnAction(event -> {
            String selection = (String)webView.getEngine().executeScript("window.getSelection().toString()");
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            if (!selection.isEmpty()) {
                content.putString(selection);
                clipboard.setContent((Map)content);
            }
        });
        copy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        contextMenu.getItems().add((Object)copy);
        ContextMenuHelper.setContextMenu((Node)webView, contextMenu);
    }
}

