/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.utils.NullUtils;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import org.eclipse.jdt.annotation.NonNull;

public class CommitOnFocusLostTextFieldTableCell<TABLE_VIEW_ITEM_TYPE>
extends TableCell<TABLE_VIEW_ITEM_TYPE, String> {
    private TextField textField;

    public void commitEdit(@NonNull String item) {
        if (this.isEditing()) {
            super.commitEdit((Object)item);
        } else {
            CommitOnFocusLostTextFieldTableCell.commitEdit(this, this.textField, item);
        }
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.textField = CommitOnFocusLostTextFieldTableCell.startEdit(this);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        CommitOnFocusLostTextFieldTableCell.cancelEdit(this);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        CommitOnFocusLostTextFieldTableCell.updateItem(this, empty, this.textField);
    }

    public static <TABLE_VIEW_ITEM_TYPE> void commitEdit(TableCell<TABLE_VIEW_ITEM_TYPE, String> cell, TextField textField, String item) {
        if (!cell.isEditing()) {
            TableView table = cell.getTableView();
            if (table != null) {
                TablePosition position = new TablePosition(table, cell.getTableRow().getIndex(), cell.getTableColumn());
                TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(table, position, TableColumn.editCommitEvent(), (Object)item);
                Event.fireEvent((EventTarget)cell.getTableColumn(), (Event)editEvent);
            }
            CommitOnFocusLostTextFieldTableCell.updateItem(cell, false, textField);
            if (table != null) {
                table.edit(-1, null);
            }
        }
    }

    public static @NonNull TextField startEdit(@NonNull TableCell<?, String> cell) {
        @NonNull TextField textField = CommitOnFocusLostTextFieldTableCell.createTextField(cell, CommitOnFocusLostTextFieldTableCell.getString(cell));
        cell.setText(null);
        cell.setGraphic((Node)textField);
        textField.selectAll();
        textField.requestFocus();
        return textField;
    }

    public static void cancelEdit(TableCell<?, String> cell) {
        cell.setText((String)cell.getItem());
        cell.setGraphic(null);
    }

    public static void updateItem(TableCell<?, String> cell, boolean empty, TextField textField) {
        if (empty) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (textField != null) {
                textField.setText(CommitOnFocusLostTextFieldTableCell.getString(cell));
            }
            cell.setText(null);
            cell.setGraphic((Node)textField);
        } else {
            cell.setText(CommitOnFocusLostTextFieldTableCell.getString(cell));
            cell.setGraphic(null);
        }
    }

    private static @NonNull TextField createTextField(TableCell<?, String> cell, String cellContent) {
        @NonNull TextField textField = new TextField(cellContent);
        textField.setOnAction(evt -> cell.commitEdit((Object)textField.getText()));
        textField.setMinWidth(cell.getWidth() - cell.getGraphicTextGap() * 2.0);
        ChangeListener changeListener = (observable, oldSelection, newSelection) -> {
            if (!newSelection.booleanValue()) {
                cell.commitEdit((Object)textField.getText());
            }
        };
        textField.focusedProperty().addListener(changeListener);
        textField.setOnKeyPressed(ke -> {
            if (ke.getCode().equals((Object)KeyCode.ESCAPE)) {
                textField.focusedProperty().removeListener(changeListener);
                cell.cancelEdit();
            }
        });
        return textField;
    }

    private static @NonNull String getString(TableCell<?, String> cell) {
        return cell.getItem() == null ? "" : (String)NullUtils.neverNull((Object)((String)cell.getItem()).toString());
    }
}

