/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.util.ComparableWeakReference;
import com.arm.mgd.ui.controllers.ShadersViewController;
import com.arm.mgd.ui.controllers.ShadersViewListItem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.Nullable;

public class ColouredProgramTableCellFactory
implements Callback<TableColumn<ShadersViewListItem, Collection<ComparableWeakReference<GlProgramAsset>>>, TableCell<ShadersViewListItem, Collection<ComparableWeakReference<GlProgramAsset>>>> {
    private final ShadersViewController controller;

    public ColouredProgramTableCellFactory(ShadersViewController controller) {
        this.controller = controller;
    }

    public TableCell<@Nullable ShadersViewListItem, @Nullable Collection<ComparableWeakReference<GlProgramAsset>>> call(TableColumn<@Nullable ShadersViewListItem, @Nullable Collection<ComparableWeakReference<GlProgramAsset>>> column) {
        return new TableCell<ShadersViewListItem, Collection<ComparableWeakReference<GlProgramAsset>>>(){
            private final HBox graphic = new HBox();
            {
                this.setGraphic((Node)this.graphic);
                this.graphic.setVisible(false);
            }

            protected void updateItem(@Nullable Collection<ComparableWeakReference<GlProgramAsset>> item, boolean empty) {
                super.updateItem(item, empty);
                ArrayList<Label> labels = null;
                if (!empty && item != null) {
                    labels = new ArrayList<Label>(item.size());
                    for (WeakReference weakReference : item) {
                        GlProgramAsset program = (GlProgramAsset)weakReference.get();
                        if (program == null) continue;
                        Label label = new Label();
                        int[] channels = program.getColor().getColorAsInt();
                        StringBuilder styleStringBuilder = new StringBuilder();
                        styleStringBuilder.append(String.format("-fx-background-color:#%02x%02x%02x", channels[0], channels[1], channels[2]));
                        styleStringBuilder.append(";");
                        label.setStyle(styleStringBuilder.toString());
                        label.setText(program.getId().toString());
                        String activeAssetStyle = "active-asset";
                        if (ColouredProgramTableCellFactory.this.controller.isProgramActive(program)) {
                            label.getStyleClass().add((Object)"active-asset");
                        }
                        labels.add(label);
                    }
                }
                if (labels == null || labels.size() == 0) {
                    this.graphic.setVisible(false);
                    this.graphic.getChildren().clear();
                } else {
                    this.graphic.setVisible(true);
                    this.graphic.getChildren().setAll(labels);
                }
            }
        };
    }
}

