/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.widgets;

import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BooleanIconTableCell<S>
extends TableCell<S, Boolean> {
    private final @NonNull ImageView imageView;
    private final @Nullable Image falseImage;
    private final @Nullable Image nullImage;
    private final @Nullable Image trueImage;

    public BooleanIconTableCell(@Nullable Image trueImage, @Nullable Image falseImage, @Nullable Image nullImage) {
        assert (trueImage != null || falseImage != null) : "One of trueImage or falseImage must be non-null";
        this.trueImage = trueImage;
        this.falseImage = falseImage;
        this.nullImage = nullImage;
        this.imageView = new ImageView();
        this.imageView.setImage(nullImage);
        this.setGraphic((Node)this.imageView);
    }

    protected void updateItem(@Nullable Boolean value, boolean empty) {
        super.updateItem((Object)value, empty);
        if (value == null || empty) {
            this.imageView.setImage(this.nullImage);
        } else if (value.booleanValue()) {
            this.imageView.setImage(this.trueImage);
        } else {
            this.imageView.setImage(this.falseImage);
        }
    }
}

