/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.vulkan;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.AbstractTableViewThumbnailController;
import com.arm.mgd.ui.controllers.ImagesViewItem;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.utils.RGBAImage;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.ui.views.widgets.ImageTableCellFactory;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ImagesView
extends FXViewPart {
    private final @NonNull AbstractTableViewThumbnailController<ImagesViewItem> controller;
    @FXML
    private VBox rootContainer;
    @FXML
    private TableView<ImagesViewItem> tableView;
    @FXML
    private TableColumn<ImagesViewItem, IImageProvider> imageColumn;
    @FXML
    private TableColumn<ImagesViewItem, Handle> imageHandleColumn;
    @FXML
    private TableColumn<ImagesViewItem, Bitfield> flagsColumn;
    @FXML
    private TableColumn<ImagesViewItem, AbstractConstantOrAliasSpecExtended> imageTypeColumn;
    @FXML
    private TableColumn<ImagesViewItem, AbstractConstantOrAliasSpecExtended> formatColumn;
    @FXML
    private TableColumn<ImagesViewItem, Dimension> extentColumn;
    @FXML
    private TableColumn<ImagesViewItem, Number> widthColumn;
    @FXML
    private TableColumn<ImagesViewItem, Number> heightColumn;
    @FXML
    private TableColumn<ImagesViewItem, Number> depthColumn;
    @FXML
    private TableColumn<ImagesViewItem, Number> mipLevelsColumn;
    @FXML
    private TableColumn<ImagesViewItem, Number> arrayLayersColumn;
    @FXML
    private TableColumn<ImagesViewItem, Bitfield> samplesColumn;
    @FXML
    private TableColumn<ImagesViewItem, AbstractConstantOrAliasSpecExtended> tilingColumn;
    @FXML
    private TableColumn<ImagesViewItem, Bitfield> usageColumn;
    @FXML
    private TableColumn<ImagesViewItem, AbstractConstantOrAliasSpecExtended> sharingModeColumn;
    @FXML
    private TableColumn<ImagesViewItem, AbstractConstantOrAliasSpecExtended> initialLayoutColumn;
    @FXML
    private TableColumn<ImagesViewItem, String> noteColumn;
    @FXML
    private ComboBox<RGBAImage.AlphaMode> alphaMode;
    private final @NonNull ExecutorService executor = NamedExecutors.cachedNumCoresThreadPool((long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("ImagesView Executor", 1));

    public ImagesView() {
        this.controller = new AbstractTableViewThumbnailController<ImagesViewItem>(this.visibleProperty(), KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC){

            @Override
            public @NonNull ImagesViewItem createTableViewItem() {
                return new ImagesViewItem();
            }

            @Override
            public String getClipboardHeader() {
                return "Handle, Flags, Type, Format, Extent, Width, Height, Depth, Mip Levels, Array Layers, Samples, Tiling, Usage, Sharing Mode, Initial Layout, Note";
            }

            @Override
            protected void setTableViewItem(@NonNull ImagesViewItem item, @NonNull IAssetItem assetItem) {
                item.set((VkImageAsset)assetItem);
            }
        };
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        this.tableView.setItems(null);
        this.executor.shutdown();
        super.dispose();
    }

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/imagesView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (VBox)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.tableView.setItems(this.controller.getItemList());
        this.imageColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).imageProviderProperty());
        this.imageColumn.setCellFactory(new ImageTableCellFactory((ReadOnlyObjectProperty<RGBAImage.AlphaMode>)((ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.alphaMode.valueProperty())), this.executor));
        this.imageHandleColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).imageHandleProperty());
        this.flagsColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).flagsProperty());
        this.imageTypeColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).imageTypeProperty());
        this.formatColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).formatProperty());
        this.extentColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).extentProperty());
        this.widthColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).widthProperty());
        this.heightColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).heightProperty());
        this.depthColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).depthProperty());
        this.mipLevelsColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).mipLevelsProperty());
        this.arrayLayersColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).arrayLayersProperty());
        this.samplesColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).samplesProperty());
        this.tilingColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).tilingProperty());
        this.usageColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).usageProperty());
        this.sharingModeColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).sharingModeProperty());
        this.initialLayoutColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).initialLayoutProperty());
        this.noteColumn.setCellValueFactory(item -> ((ImagesViewItem)item.getValue()).noteProperty());
        this.tableView.setTableMenuButtonVisible(true);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.controller.getItemList().addListener((ListChangeListener)new ListChangeListener<ImagesViewItem>(){

            public void onChanged(ListChangeListener.Change<? extends ImagesViewItem> c) {
                ImagesViewItem item = (ImagesViewItem)ImagesView.this.tableView.getSelectionModel().getSelectedItem();
                ImagesView.this.tableView.scrollTo((Object)item);
            }
        });
        ContextMenu contextMenu = new ContextMenu();
        this.loadTableContextMenu(contextMenu);
        this.tableView.setRowFactory(tv -> {
            TableRow rowItem = new TableRow();
            rowItem.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !rowItem.isEmpty()) {
                    ImagesViewItem imageViewItem = (ImagesViewItem)rowItem.getItem();
                    imageViewItem.open();
                }
            });
            return rowItem;
        });
        this.alphaMode.getItems().setAll((Object[])RGBAImage.AlphaMode.values());
        this.alphaMode.getSelectionModel().select(0);
        this.controller.bindSelectedIndices((ObservableList<Integer>)this.tableView.getSelectionModel().getSelectedIndices());
        this.controller.bindComparatorProperty((ObservableValue<Comparator<ImagesViewItem>>)this.tableView.comparatorProperty());
        this.tableView.getSortOrder().add(this.imageHandleColumn);
        return new Scene((Parent)this.rootContainer);
    }

    @Override
    protected void setFxFocus() {
        this.tableView.requestFocus();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.vulkanimagesview";
    }

    private void loadTableContextMenu(@NonNull ContextMenu contextMenu) {
        HashMap<@NonNull ICommand<T>, @NonNull MenuItem> allMenuItems = new HashMap();
        allMenuItems.put(Commands.OPEN_ASSET_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.OPEN_ASSET_COMMAND));
        allMenuItems.put(Commands.EXPORT_SELECTED_IMAGES_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.EXPORT_SELECTED_IMAGES_COMMAND));
        allMenuItems.put(Commands.SHOW_CREATED_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.SHOW_CREATED_LOCATION_COMMAND));
        allMenuItems.put(Commands.SHOW_LAST_MODIFIED_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.SHOW_LAST_MODIFIED_LOCATION_COMMAND));
        allMenuItems.put(this.controller.getCopyCommand(), ContextMenuHelper.addItem(contextMenu, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (ICommandDispatcher)NullUtils.neverNull(this.controller), this.controller.getCopyCommand()));
        contextMenu.showingProperty().addListener(listener -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!this.controller.canDispatchCommand((ICommand<ImagesViewItem>)command))));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.tableView), contextMenu);
    }
}

