/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.statsview;

import com.arm.mgd.core.target.data.memoryreport.MemoryReportChannel;
import com.arm.mgd.ui.controllers.statsview.StatisticsViewMemoryTabController;
import com.arm.mgd.ui.controls.HistogramChart;
import com.arm.mgd.ui.controls.SelectablePieChart;
import com.arm.mgd.ui.controls.SelectablePieChartController;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;

public class StatisticsViewMemoryTab
extends VBox {
    @FXML
    private Button backToPieChartButton;
    @FXML
    private HistogramChart histogram;
    @FXML
    private Label infoLabel;
    @FXML
    private HBox infoLabelContainer;
    @FXML
    private Label memoryReportNoDataLabel;
    @FXML
    private PieChart memoryReportPieChart;
    private final StatisticsViewMemoryTabController controller;
    private final SelectablePieChart<MemoryReportChannel> memoryReportPieChartWrapper;
    private TabPane rootContainer;
    private final ContextMenu histogramMenu = new ContextMenu();

    public StatisticsViewMemoryTab(@NonNull ReadOnlyBooleanProperty enabledProperty) throws IOException {
        this.controller = new StatisticsViewMemoryTabController(enabledProperty);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/statisticsViewMemoryTab.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.load();
        this.backToPieChartButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StatisticsViewMemoryTab.this.controller.showHistogramFor(null);
            }
        });
        this.histogram.setXAxisLabel("Memory range");
        this.histogram.setYAxisLabel("Memory allocations");
        this.histogram.titleProperty().bind((ObservableValue)this.controller.histogramTitleProperty());
        Bindings.bindContent((List)this.histogram.getData(), this.controller.getHistogramSeries());
        Bindings.bindContent((List)this.histogram.getXAxis().getCategories(), this.controller.getHistogramCategories());
        Bindings.bindContent(this.histogram.getCategoryColourMap(), this.controller.getHistogramCategoryColours());
        Bindings.bindContent(this.histogram.getCategoryTooltipMap(), this.controller.getHistogramCategoryTooltips());
        this.setupHistogramMenu();
        this.memoryReportPieChart.titleProperty().bind((ObservableValue)this.controller.currentFrameNameProperty());
        this.memoryReportPieChartWrapper = new SelectablePieChart((PieChart)NullUtils.neverNull((Object)this.memoryReportPieChart));
        SelectablePieChartController<MemoryReportChannel> otherPieChartWrapperController = this.memoryReportPieChartWrapper.getController();
        otherPieChartWrapperController.getSelectedItemProperty().bind(this.controller.selectedChannelProperty());
        this.infoLabel.textProperty().bind((ObservableValue)this.controller.pieChartInfoLabelProperty());
        otherPieChartWrapperController.setOnClickConsumer(channel -> this.controller.selectedChannelProperty().set(channel));
        otherPieChartWrapperController.setOnDoubleClickConsumer(channel -> this.controller.showHistogramFor((MemoryReportChannel)channel));
        otherPieChartWrapperController.setData(this.controller.getMemoryReportPieData());
        this.memoryReportNoDataLabel.visibleProperty().bind((ObservableValue)this.controller.noMemoryReportDataToShowProperty());
        this.histogram.visibleProperty().bind((ObservableValue)this.controller.showHistogramProperty());
        this.backToPieChartButton.visibleProperty().bind((ObservableValue)this.controller.showHistogramProperty());
        this.memoryReportPieChart.visibleProperty().bind((ObservableValue)this.controller.showHistogramProperty().not());
        this.infoLabel.visibleProperty().bind((ObservableValue)this.controller.showHistogramProperty().not().and((ObservableBooleanValue)this.controller.noMemoryReportDataToShowProperty().not()));
        this.infoLabelContainer.visibleProperty().bind((ObservableValue)this.infoLabel.visibleProperty());
        this.infoLabelContainer.managedProperty().bind((ObservableValue)this.infoLabel.visibleProperty());
    }

    private void setupHistogramMenu() {
        MenuItem copyToCSV = new MenuItem("Copy to clipboard (CSV formatted)");
        copyToCSV.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Clipboard cb = Clipboard.getSystemClipboard();
                ClipboardContent csv = new ClipboardContent();
                csv.putString(StatisticsViewMemoryTab.this.controller.getCSVStringProperty().getValue());
                cb.setContent((Map)csv);
            }
        });
        this.histogramMenu.getItems().add((Object)copyToCSV);
        this.histogramMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                StatisticsViewMemoryTab.this.histogramMenu.hide();
            }
        });
        this.histogram.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (MouseButton.PRIMARY.equals((Object)event.getButton())) {
                    StatisticsViewMemoryTab.this.histogramMenu.hide();
                } else if (MouseButton.SECONDARY.equals((Object)event.getButton())) {
                    StatisticsViewMemoryTab.this.histogramMenu.show((Node)StatisticsViewMemoryTab.this.rootContainer, event.getScreenX(), event.getScreenY());
                }
            }
        });
    }

    public void setRootContainer(TabPane rootContainer) {
        this.rootContainer = rootContainer;
        this.rootContainer.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    StatisticsViewMemoryTab.this.histogramMenu.hide();
                }
            }
        });
        ReadOnlyObjectProperty itemProperty = this.rootContainer.getSelectionModel().selectedItemProperty();
        itemProperty.addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> observable, Tab oldValue, Tab newValue) {
                StatisticsViewMemoryTab.this.histogramMenu.hide();
            }
        });
    }

    public void dispose() {
        this.controller.dispose();
    }
}

