/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.statsview;

import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.util.IStatisticType;
import com.arm.mgd.ui.controllers.statsview.StatisticsViewChartsTabController;
import com.arm.mgd.ui.controls.SelectablePieChart;
import com.arm.mgd.ui.controls.SelectablePieChartController;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.chart.PieChart;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import org.eclipse.jdt.annotation.NonNull;

public final class StatisticsViewChartsTab
extends VBox {
    private final StatisticsViewChartsTabController controller;
    @FXML
    private Label dataNotSupportedLabel;
    @FXML
    private Label noDataLabel;
    @FXML
    private PieChart pieChart;
    private final SelectablePieChart<INavigationElement<?>> pieChartWrapper;
    @FXML
    private Label showingNumberLabel;
    @FXML
    private ChoiceBox<IStatisticType> statisticChoiceBox;

    public StatisticsViewChartsTab(@NonNull ReadOnlyBooleanProperty visibleProperty) throws IOException {
        this.controller = new StatisticsViewChartsTabController(visibleProperty);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/statisticsViewChartsTab.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.load();
        this.pieChart.titleProperty().bind((ObservableValue)this.controller.currentParentNameProperty());
        this.pieChartWrapper = new SelectablePieChart((PieChart)NullUtils.neverNull((Object)this.pieChart));
        SelectablePieChartController<INavigationElement<?>> pieChartWrapperController = this.pieChartWrapper.getController();
        pieChartWrapperController.getSelectedItemProperty().bind(this.controller.selectedNavigationElementProperty());
        pieChartWrapperController.setOnClickConsumer(item -> this.controller.select((INavigationElement<?>)item));
        StringBinding numberOfEntriesText = Bindings.createStringBinding(() -> "Showing top " + this.controller.getNumberOfEntriesShownProperty().get() + " (out of " + this.controller.getTotalNumberOfEntriesProperty().get() + ")", (Observable[])new Observable[]{this.controller.getNumberOfEntriesShownProperty(), this.controller.getTotalNumberOfEntriesProperty()});
        this.showingNumberLabel.textProperty().bind((ObservableValue)numberOfEntriesText);
        this.showingNumberLabel.visibleProperty().bind((ObservableValue)this.controller.isSelectedStatisticSupportedProperty());
        pieChartWrapperController.setOnDoubleClickConsumer(item -> this.controller.drillInto((INavigationElement<?>)item));
        pieChartWrapperController.setData(this.controller.getPieData());
        this.dataNotSupportedLabel.visibleProperty().bind((ObservableValue)this.controller.isSelectedStatisticSupportedProperty().not());
        this.noDataLabel.visibleProperty().bind((ObservableValue)this.controller.noDataToShowProperty().and((ObservableBooleanValue)this.controller.isSelectedStatisticSupportedProperty()));
        this.statisticChoiceBox.itemsProperty().bind(this.controller.getAvailableStatistics());
        this.statisticChoiceBox.setConverter((StringConverter)new StringConverter<IStatisticType>(){

            public IStatisticType fromString(String string) {
                return null;
            }

            public String toString(IStatisticType object) {
                return object.getTitle();
            }
        });
        this.controller.selectedStatisticProperty().bind((ObservableValue)this.statisticChoiceBox.getSelectionModel().selectedItemProperty());
        this.statisticChoiceBox.getSelectionModel().selectFirst();
    }

    public void dispose() {
        this.controller.dispose();
    }
}

