/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.framebuffer;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.views.framebuffer.HistogramCrossbarItem;
import java.io.IOException;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class HistogramListCellGraphic {
    private static final @NonNull Image CHART_IMAGE = new Image(HistogramListCellGraphic.class.getResourceAsStream("/resources/chart_preview.png"));
    private static final PseudoClass NON_ACTIVE = PseudoClass.getPseudoClass((String)"NON_ACTIVE");
    private static final PseudoClass DEFAULT = PseudoClass.getPseudoClass((String)"DEFAULT");
    @FXML
    private Label heading;
    @FXML
    private Label subHeading;
    @FXML
    private StackPane imageStack;
    @FXML
    private ImageView imageView;
    private final @NonNull ObjectProperty<@Nullable Node> graphicProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable HistogramCrossbarItem> itemProperty = new SimpleObjectProperty();

    HistogramListCellGraphic() {
        AnchorPane root;
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/framebufferListElement.fxml"));
            fxmlLoader.setController((Object)this);
            root = (AnchorPane)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe(null, (Throwable)e, null);
            throw new AssertionError((Object)e);
        }
        this.itemProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.graphicProperty.set(null);
                this.heading.textProperty().set(null);
                this.subHeading.textProperty().set(null);
                this.imageView.imageProperty().set(null);
            } else {
                this.graphicProperty.set((Object)root);
                this.heading.textProperty().set((Object)"Histogram");
                this.subHeading.textProperty().set((Object)newValue.getTask().getName());
                this.imageView.imageProperty().set((Object)CHART_IMAGE);
            }
        });
        this.imageStack.pseudoClassStateChanged(DEFAULT, true);
        this.imageStack.pseudoClassStateChanged(NON_ACTIVE, true);
    }

    public void setItem(@Nullable HistogramCrossbarItem item) {
        this.itemProperty.set((Object)item);
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Node> graphicProperty() {
        return this.graphicProperty;
    }
}

