/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.framebuffer;

import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.asset.texture.RGBAImageWriter;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.core.util.image.IntegerTextureConverter;
import com.arm.mgd.core.util.image.PixelReader;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.EditorInputManager;
import com.arm.mgd.ui.controllers.framebuffer.AbstractFramebufferPerPixelHistogramInfoTask;
import com.arm.mgd.ui.controllers.framebuffer.FramebufferAttachmentData;
import com.arm.mgd.ui.controllers.framebuffer.FramebuffersViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.controls.HistogramChart;
import com.arm.mgd.ui.controls.HistogramController;
import com.arm.mgd.ui.controls.TextPopup;
import com.arm.mgd.ui.utils.RGBAImage;
import com.arm.mgd.ui.views.FramebufferInfoStringHelper;
import com.arm.mgd.ui.views.framebuffer.CrossBarListCell;
import com.arm.mgd.ui.views.framebuffer.FramebufferAttachmentCrossBarItem;
import com.arm.mgd.ui.views.framebuffer.FramebufferImage;
import com.arm.mgd.ui.views.framebuffer.FramebufferSideBarItem;
import com.arm.mgd.ui.views.framebuffer.HistogramCrossbarItem;
import com.arm.mgd.ui.views.framebuffer.ICrossBarItem;
import com.arm.mgd.ui.views.framebuffer.ICrossBarVisitor;
import com.arm.mgd.ui.views.framebuffer.SideBarListCell;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FramebuffersView
extends FXViewPart {
    @FXML
    private VBox rootContainer;
    @FXML
    private ListView<FramebufferSideBarItem> framebufferSideBar;
    @FXML
    private ListView<ICrossBarItem> framebufferCrossBar;
    @FXML
    private ScrollPane mainImageScrollPane;
    @FXML
    private ImageView mainImage;
    @FXML
    private Label framebufferTargetString;
    @FXML
    private CheckBox actualSizeCheckBox;
    @FXML
    private ComboBox<RGBAImage.AlphaMode> alphaModeComboBox;
    @FXML
    private ProgressIndicator histogramProgressIndicator;
    @FXML
    private HistogramChart histogram;
    private final @NonNull ObjectProperty<@Nullable RGBAImage.AlphaMode> alphaModeProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable FramebuffersViewController.Framebuffers> framebuffersProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable FramebuffersViewController.FramebufferAttachments> framebufferAttachmentsProperty = new SimpleObjectProperty(null);
    private final @NonNull ObjectProperty<@Nullable FramebufferImage> selectedFramebufferAttachmentImageProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable AbstractFramebufferPerPixelHistogramInfoTask> selectedHistogramTask = new SimpleObjectProperty();
    private final @NonNull FramebuffersViewController framebuffersViewController = new FramebuffersViewController(this.visibleProperty());
    private final @NonNull HistogramController histogramController = new HistogramController();
    private final @NonNull ObjectProperty<@Nullable HistogramController.HistogramInformation> histogramInfo = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable Image> proxyMainImage = new SimpleObjectProperty();
    private final @NonNull StringProperty mainImageLoadError = new SimpleStringProperty();
    private final @NonNull ExecutorService executor = NamedExecutors.cachedNumCoresThreadPool((long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("FramebuffersView Executor", 1));

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/framebuffersView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (VBox)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.alphaModeProperty.bind((ObservableValue)this.alphaModeComboBox.valueProperty());
        this.alphaModeComboBox.getItems().setAll((Object[])RGBAImage.AlphaMode.values());
        this.alphaModeComboBox.getSelectionModel().select(0);
        this.setupHistogramMenu();
        this.framebuffersProperty.addListener((observable, oldValue, newValue) -> {
            HashSet oldItems = new HashSet(this.framebufferSideBar.getItems());
            if (newValue != null) {
                ArrayList items = new ArrayList();
                newValue.framebuffers.forEach(item -> {
                    boolean bl = items.add(new FramebufferSideBarItem((FramebuffersViewController.FramebufferInfo)item, this.executor));
                });
                FramebufferSideBarItem oldSelection = (FramebufferSideBarItem)this.framebufferSideBar.getSelectionModel().getSelectedItem();
                FramebufferSideBarItem newSelection = null;
                if (oldSelection != null) {
                    for (FramebufferSideBarItem item2 : items) {
                        if (!item2.getData().getFramebuffer().getId().equals(oldSelection.getData().getFramebuffer().getId())) continue;
                        newSelection = item2;
                        break;
                    }
                }
                if (newSelection == null && items.size() > 0) {
                    newSelection = (FramebufferSideBarItem)items.get(0);
                }
                this.framebufferSideBar.getItems().addAll(items);
                this.framebufferSideBar.getSelectionModel().select((Object)newSelection);
            }
            this.framebufferSideBar.getItems().removeAll(oldItems);
            oldItems.forEach(item -> item.dispose());
        });
        this.framebufferSideBar.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.framebufferAttachmentsProperty.set((Object)(newValue != null ? newValue.getAttachments() : null)));
        this.framebufferAttachmentsProperty.addListener((observable, oldValue, newValue) -> {
            HashSet oldItems = new HashSet(this.framebufferCrossBar.getItems());
            if (newValue != null) {
                final ArrayList attachments = new ArrayList();
                newValue.attachments.forEach(item -> {
                    boolean bl = attachments.add(new FramebufferAttachmentCrossBarItem((FramebufferAttachmentData)item, this.executor, (ReadOnlyObjectProperty<RGBAImage.AlphaMode>)this.alphaModeProperty));
                });
                final ArrayList histograms = new ArrayList();
                newValue.histogramTaskFactories.forEach(item -> {
                    boolean bl = histograms.add(new HistogramCrossbarItem((FramebuffersViewController.HistogramTaskFactory)item));
                });
                ICrossBarItem oldSelection = (ICrossBarItem)this.framebufferCrossBar.getSelectionModel().getSelectedItem();
                ICrossBarItem newSelection = null;
                if (oldSelection != null) {
                    newSelection = oldSelection.accept(new ICrossBarVisitor<ICrossBarItem>(){

                        @Override
                        public ICrossBarItem visit(@NonNull FramebufferAttachmentCrossBarItem attachmentItem) {
                            AbstractConstantOrAliasSpecExtended attachment = attachmentItem.getData().getAttachment();
                            for (FramebufferAttachmentCrossBarItem item : attachments) {
                                if (!item.getData().getAttachment().equals(attachment)) continue;
                                return item;
                            }
                            return null;
                        }

                        @Override
                        public ICrossBarItem visit(@NonNull HistogramCrossbarItem histogramItem) {
                            String oldTaskName = histogramItem.getTask().getName();
                            for (HistogramCrossbarItem item : histograms) {
                                if (!item.getTask().getName().equals(oldTaskName)) continue;
                                return item;
                            }
                            return null;
                        }
                    });
                }
                if (newSelection == null) {
                    if (attachments.size() != 0) {
                        newSelection = (ICrossBarItem)attachments.get(0);
                    } else if (histograms.size() != 0) {
                        newSelection = (ICrossBarItem)histograms.get(0);
                    }
                }
                this.framebufferCrossBar.getItems().addAll(attachments);
                this.framebufferCrossBar.getItems().addAll(histograms);
                this.framebufferCrossBar.getSelectionModel().select((Object)newSelection);
            }
            this.framebufferCrossBar.getItems().removeAll(oldItems);
            oldItems.forEach(item -> item.dispose());
        });
        this.framebufferCrossBar.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                newValue.accept(new ICrossBarVisitor<Void>(){

                    @Override
                    public Void visit(@NonNull FramebufferAttachmentCrossBarItem attachmentItem) {
                        FramebuffersView.this.selectedFramebufferAttachmentImageProperty.set((Object)attachmentItem.getImage());
                        FramebuffersView.this.selectedHistogramTask.set(null);
                        return null;
                    }

                    @Override
                    public Void visit(@NonNull HistogramCrossbarItem histogramItem) {
                        FramebuffersView.this.selectedFramebufferAttachmentImageProperty.set(null);
                        FramebuffersView.this.selectedHistogramTask.set((Object)histogramItem.getTask());
                        return null;
                    }
                });
            } else {
                this.selectedFramebufferAttachmentImageProperty.set(null);
                this.selectedHistogramTask.set(null);
            }
        });
        this.selectedFramebufferAttachmentImageProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.proxyMainImage.bind(newValue.imageProperty());
                this.mainImageLoadError.bind((ObservableValue)newValue.imageLoadErrorProperty());
            } else {
                this.proxyMainImage.unbind();
                this.proxyMainImage.set(null);
                this.mainImageLoadError.unbind();
                this.mainImageLoadError.set(null);
                this.mainImage.setImage(null);
            }
            if (newValue != null && newValue.isAlphaOpacity()) {
                this.alphaModeComboBox.disableProperty().bind((ObservableValue)newValue.imageLoadErrorProperty().isNotEmpty());
            } else {
                this.alphaModeComboBox.disableProperty().unbind();
                this.alphaModeComboBox.setDisable(true);
            }
        });
        this.proxyMainImage.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.mainImage.imageProperty().set(newValue);
            }
        });
        this.mainImageLoadError.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.mainImage.imageProperty().set(null);
            }
        });
        this.actualSizeCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.setImageViewScaling((boolean)newValue));
        this.setImageViewScaling(this.actualSizeCheckBox.isSelected());
        this.selectedHistogramTask.addListener((observable, oldValue, newValue) -> this.histogramController.invokeDataReloaderTask((Task<HistogramController.HistogramInformation>)newValue));
        this.histogramController.getHistogramInfo().addListener((observable, oldValue, newValue) -> {
            HistogramController.HistogramInformation newInfo = null;
            if (newValue != null && newValue.getSeriesToAdd().size() != 0) {
                newInfo = newValue;
            }
            this.histogramInfo.set(newInfo);
        });
        this.histogram.visibleProperty().bind((ObservableValue)this.histogramInfo.isNotNull());
        this.histogramInfo.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                Bindings.unbindContent((Object)this.histogram.getXAxis().getCategories(), oldValue.getCategories());
                this.histogram.getXAxis().getCategories().clear();
                Bindings.unbindContent((Object)this.histogram.getData(), oldValue.getSeriesToAdd());
                this.histogram.getData().clear();
                Bindings.unbindContent(this.histogram.getCategoryColourMap(), oldValue.getCategoryColours());
                this.histogram.getCategoryColourMap().clear();
                this.histogram.getXAxis().labelProperty().unbind();
                this.histogram.getXAxis().labelProperty().set(null);
                this.histogram.getYAxis().labelProperty().unbind();
                this.histogram.getYAxis().labelProperty().set(null);
                this.histogram.setComparator(null);
            }
            if (newValue != null) {
                Bindings.bindContent((List)this.histogram.getXAxis().getCategories(), newValue.getCategories());
                Bindings.bindContent((List)this.histogram.getData(), newValue.getSeriesToAdd());
                Bindings.bindContent(this.histogram.getCategoryColourMap(), newValue.getCategoryColours());
                this.histogram.getXAxis().labelProperty().bind((ObservableValue)newValue.getCategoriesLabel());
                this.histogram.getYAxis().labelProperty().bind((ObservableValue)newValue.getFrequencyLabel());
                this.histogram.setComparator((Comparator)newValue.getComparator().get());
            }
        });
        this.histogramProgressIndicator.progressProperty().bind((ObservableValue)this.histogramController.getProgress());
        this.histogramProgressIndicator.visibleProperty().bind((ObservableValue)this.histogramController.getTaskRunning());
        this.histogramProgressIndicator.managedProperty().bind((ObservableValue)this.histogramController.getTaskRunning());
        this.framebufferSideBar.setCellFactory(listView -> new SideBarListCell());
        this.framebufferCrossBar.setCellFactory(listView -> new CrossBarListCell());
        this.setupPopup();
        this.mainImage.setOnMouseClicked(event -> {
            block5: {
                if (event.getClickCount() == 2) {
                    FramebufferImage image = (FramebufferImage)this.selectedFramebufferAttachmentImageProperty.get();
                    if (image == null) {
                        return;
                    }
                    RGBAImage rawImage = (RGBAImage)image.rawImageProperty().get();
                    if (rawImage != null) {
                        File outFile = null;
                        try {
                            outFile = FileUtils.createTempFile((String)"framebuffer_", (String)".png");
                            RGBAImageWriter.writeAsPng((RGBAImageData)rawImage.getRGBAImageData(), (File)outFile);
                            EditorInputManager.openExternalEditor(outFile);
                        }
                        catch (IOException e) {
                            CoreLogging.userMessage(null, (Level)Level.WARNING, (String)("Unable to write framebuffer to temporary file: " + e.getMessage()));
                            if (outFile == null) break block5;
                            outFile.delete();
                            outFile = null;
                        }
                    }
                }
            }
        });
        this.histogram.setStyle("-fx-background-color: lightgrey");
        this.framebuffersProperty.bind(this.framebuffersViewController.framebuffersProperty());
        return new Scene((Parent)this.rootContainer);
    }

    @Override
    public void dispose() {
        this.alphaModeProperty.unbind();
        this.alphaModeProperty.set(null);
        this.framebuffersProperty.unbind();
        this.framebuffersProperty.set(null);
        this.framebufferAttachmentsProperty.unbind();
        this.framebufferAttachmentsProperty.set(null);
        this.selectedFramebufferAttachmentImageProperty.set(null);
        this.selectedHistogramTask.set(null);
        this.histogramInfo.set(null);
        this.proxyMainImage.set(null);
        this.mainImageLoadError.set(null);
        this.framebuffersViewController.close();
        this.executor.shutdown();
        this.histogramController.dispose();
        super.dispose();
    }

    private void setImageViewScaling(boolean actualSize) {
        if (actualSize) {
            this.mainImage.fitHeightProperty().unbind();
            this.mainImage.fitWidthProperty().unbind();
            this.mainImage.setFitWidth(0.0);
            this.mainImage.setFitHeight(0.0);
        } else {
            this.mainImage.fitWidthProperty().bind((ObservableValue)this.mainImageScrollPane.widthProperty().subtract(this.mainImageScrollPane.getInsets().getLeft()).subtract(this.mainImageScrollPane.getInsets().getRight()));
            this.mainImage.fitHeightProperty().bind((ObservableValue)this.mainImageScrollPane.heightProperty().subtract(this.mainImageScrollPane.getInsets().getTop()).subtract(this.mainImageScrollPane.getInsets().getBottom()));
        }
    }

    private void setupHistogramMenu() {
        MenuItem copyToCSV = new MenuItem("Copy to clipboard (CSV formatted)");
        copyToCSV.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Clipboard cb = Clipboard.getSystemClipboard();
                ClipboardContent csv = new ClipboardContent();
                csv.putString(((HistogramController.HistogramInformation)FramebuffersView.this.histogramController.getHistogramInfo().get()).getCSVString());
                cb.setContent((Map)csv);
            }
        });
        final ContextMenu histogramMenu = new ContextMenu();
        histogramMenu.getItems().add((Object)copyToCSV);
        this.histogram.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (MouseButton.PRIMARY.equals((Object)event.getButton())) {
                    histogramMenu.hide();
                } else if (MouseButton.SECONDARY.equals((Object)event.getButton())) {
                    histogramMenu.show((Node)FramebuffersView.this.rootContainer, event.getScreenX(), event.getScreenY());
                }
            }
        });
        this.rootContainer.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    histogramMenu.hide();
                }
            }
        });
    }

    private void setupPopup() {
        TextPopup popupNode = new TextPopup();
        popupNode.setMouseTransparent(true);
        Popup popup = new Popup();
        popup.getContent().add((Object)popupNode);
        this.mainImage.addEventHandler(MouseEvent.MOUSE_MOVED, event -> {
            RGBAImage rawImage;
            FramebuffersViewController.Framebuffers images;
            FramebufferImage image;
            String tooltipText;
            block13: {
                block17: {
                    block14: {
                        block11: {
                            block16: {
                                block12: {
                                    block9: {
                                        block15: {
                                            block10: {
                                                tooltipText = null;
                                                try {
                                                    image = (FramebufferImage)this.selectedFramebufferAttachmentImageProperty.get();
                                                    images = (FramebuffersViewController.Framebuffers)this.framebuffersProperty.get();
                                                    if (image != null && images != null) break block9;
                                                    if (tooltipText != null) break block10;
                                                }
                                                catch (Throwable throwable) {
                                                    if (tooltipText == null) {
                                                        popup.hide();
                                                    } else {
                                                        popup.show(this.mainImage.getScene().getWindow());
                                                        popupNode.getTextProperty().set(tooltipText);
                                                        popup.setAnchorX(event.getScreenX() + 15.0);
                                                        popup.setAnchorY(event.getScreenY() - 45.0);
                                                    }
                                                    throw throwable;
                                                }
                                                popup.hide();
                                                break block15;
                                            }
                                            popup.show(this.mainImage.getScene().getWindow());
                                            popupNode.getTextProperty().set(tooltipText);
                                            popup.setAnchorX(event.getScreenX() + 15.0);
                                            popup.setAnchorY(event.getScreenY() - 45.0);
                                        }
                                        return;
                                    }
                                    if (this.mainImage.getBoundsInLocal().intersects(event.getX(), event.getY(), 0.0, 0.0)) break block11;
                                    if (tooltipText != null) break block12;
                                    popup.hide();
                                    break block16;
                                }
                                popup.show(this.mainImage.getScene().getWindow());
                                popupNode.getTextProperty().set(tooltipText);
                                popup.setAnchorX(event.getScreenX() + 15.0);
                                popup.setAnchorY(event.getScreenY() - 45.0);
                            }
                            return;
                        }
                        rawImage = (RGBAImage)image.rawImageProperty().get();
                        if (rawImage != null) break block13;
                        if (tooltipText != null) break block14;
                        popup.hide();
                        break block17;
                    }
                    popup.show(this.mainImage.getScene().getWindow());
                    popupNode.getTextProperty().set(tooltipText);
                    popup.setAnchorX(event.getScreenX() + 15.0);
                    popup.setAnchorY(event.getScreenY() - 45.0);
                }
                return;
            }
            int framebufferX = (int)(event.getX() * ((double)(rawImage.getWidth() - 1) / this.mainImage.getBoundsInLocal().getWidth()));
            int framebufferY = (int)(event.getY() * ((double)(rawImage.getHeight() - 1) / this.mainImage.getBoundsInLocal().getHeight()));
            AbstractConstantOrAliasSpecExtended attachment = image.getAttachment();
            ByteBuffer buffer = rawImage.getRGBAImageData().getData().getData();
            PixelReader.IPixelReader pixelReader = IntegerTextureConverter.getRGBA8PixelReader();
            int x = framebufferX;
            int y = rawImage.getHeight() - 1 - framebufferY;
            long[] rgba = pixelReader.getPixelData(buffer, rawImage.getWidth(), x, y);
            tooltipText = FramebufferInfoStringHelper.getPixelInformationString(attachment, x, y, rgba, pixelReader, image.getCaptureMode(), images.fragmentShaders);
            if (tooltipText == null) {
                popup.hide();
            } else {
                popup.show(this.mainImage.getScene().getWindow());
                popupNode.getTextProperty().set((Object)tooltipText);
                popup.setAnchorX(event.getScreenX() + 15.0);
                popup.setAnchorY(event.getScreenY() - 45.0);
            }
        });
        this.mainImage.addEventHandler(MouseEvent.MOUSE_EXITED, event -> {
            if (!this.mainImage.getBoundsInLocal().intersects(event.getX(), event.getY(), 0.0, 0.0)) {
                popup.hide();
            }
        });
    }

    @Override
    protected void setFxFocus() {
        this.mainImage.requestFocus();
    }

    @Override
    public @Nullable String getHelpId() {
        return "com.arm.mgd.help.framebuffersview";
    }
}

