/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.framebuffer;

import com.arm.mgd.ui.controllers.framebuffer.FramebufferData;
import com.arm.mgd.ui.views.framebuffer.FramebufferImage;
import com.arm.mgd.ui.views.framebuffer.IFramebufferImageCellItem;
import com.arm.mgd.utils.NullUtils;
import java.util.concurrent.ExecutorService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class FramebufferSideBarItem
implements IFramebufferImageCellItem {
    private final  @NonNull FramebuffersViewController.FramebufferInfo info;
    private final @NonNull ExecutorService executor;
    private @Nullable FramebufferImage image = null;

    FramebufferSideBarItem( @NonNull FramebuffersViewController.FramebufferInfo info, @NonNull ExecutorService executor) {
        this.info = info;
        this.executor = executor;
    }

    public @NonNull FramebufferData getData() {
        return this.info.framebuffer;
    }

    public  @NonNull FramebuffersViewController.FramebufferAttachments getAttachments() {
        return this.info.attachments;
    }

    @Override
    public @NonNull FramebufferImage getImage() {
        if (this.image == null) {
            this.image = new FramebufferImage(this.getData(), this.executor);
        }
        return (FramebufferImage)NullUtils.neverNull((Object)this.image);
    }

    @Override
    public @NonNull String getHeading() {
        return this.getData().getFramebuffer().getLabelText();
    }

    @Override
    public @NonNull String getSubHeading() {
        return this.getData().getFramebuffer().getSize().toString();
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }
}

