/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.framebuffer;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.views.framebuffer.FramebufferImage;
import com.arm.mgd.ui.views.framebuffer.IFramebufferImageCellItem;
import java.io.IOException;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class FramebufferListCellGraphic {
    private static final PseudoClass ACTIVE = PseudoClass.getPseudoClass((String)"ACTIVE");
    private static final PseudoClass NON_ACTIVE = PseudoClass.getPseudoClass((String)"NON_ACTIVE");
    private static final PseudoClass DEFAULT = PseudoClass.getPseudoClass((String)"DEFAULT");
    private static final PseudoClass NO_IMAGE = PseudoClass.getPseudoClass((String)"NO_IMAGE");
    private static final @NonNull String IMAGE_LOAD_ERROR_INFO = "There is no data available for this framebuffer, this could be because:\n - Frame Capture was not enabled\n - This framebuffer was not drawn to in this render pass\n - For MRTs, Depth, or Stencil attachments, the 'Send All Framebuffer Attachments' mode was not enabled\n";
    @FXML
    private Label heading;
    @FXML
    private Label subHeading;
    @FXML
    private StackPane imageStack;
    @FXML
    private ImageView imageView;
    private final @NonNull ObjectProperty<@Nullable Node> graphicProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable Tooltip> tooltipProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable IFramebufferImageCellItem> itemProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable FramebufferImage> imageProperty = new SimpleObjectProperty();
    private final @NonNull BooleanProperty isImageLoadingProperty = new SimpleBooleanProperty();
    private final @NonNull BooleanProperty isImageLoadedProperty = new SimpleBooleanProperty();
    private final @NonNull BooleanProperty isImageLoadingOrLoadedProperty = new SimpleBooleanProperty();
    private final @NonNull StringProperty imageLoadErrorProperty = new SimpleStringProperty();
    private final @NonNull BooleanProperty isActiveProperty = new SimpleBooleanProperty();
    private final boolean isAttachment;
    private final @NonNull Tooltip framebufferListCellTooltip = new Tooltip();

    FramebufferListCellGraphic(boolean isAttachment) {
        AnchorPane root;
        this.isAttachment = isAttachment;
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/framebufferListElement.fxml"));
            fxmlLoader.setController((Object)this);
            root = (AnchorPane)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            throw new AssertionError((Object)e);
        }
        this.itemProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.graphicProperty.set(null);
                this.heading.textProperty().set(null);
                this.subHeading.textProperty().set(null);
                this.imageProperty.set(null);
            } else {
                this.graphicProperty.set((Object)root);
                this.heading.textProperty().set((Object)newValue.getHeading());
                this.subHeading.textProperty().set((Object)newValue.getSubHeading());
                this.imageProperty.set((Object)newValue.getImage());
            }
        });
        this.imageProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.isActiveProperty.set(false);
                this.imageView.imageProperty().unbind();
                this.imageView.imageProperty().set(null);
                this.imageLoadErrorProperty.unbind();
                this.imageLoadErrorProperty.set(null);
                this.isImageLoadingProperty.unbind();
                this.isImageLoadingProperty.set(false);
                this.isImageLoadedProperty.unbind();
                this.isImageLoadedProperty.set(false);
            } else {
                this.isActiveProperty.set(newValue.isActiveAttachment());
                this.imageView.imageProperty().bind(newValue.imageProperty());
                this.imageLoadErrorProperty.bind((ObservableValue)newValue.imageLoadErrorProperty());
                this.isImageLoadingProperty.bind((ObservableValue)newValue.isImageLoadingProperty());
                this.isImageLoadedProperty.bind((ObservableValue)newValue.isImageLoadedProperty());
            }
        });
        this.isImageLoadingOrLoadedProperty.bind((ObservableValue)this.isImageLoadingProperty.or((ObservableBooleanValue)this.isImageLoadedProperty));
        InvalidationListener imageLoadingOrLoadedListener = observable -> {
            boolean isImageLoadingOrLoaded = this.isImageLoadingOrLoadedProperty.get();
            this.imageStack.pseudoClassStateChanged(DEFAULT, isImageLoadingOrLoaded);
            this.imageStack.pseudoClassStateChanged(NO_IMAGE, !isImageLoadingOrLoaded);
        };
        this.isImageLoadingOrLoadedProperty.addListener(imageLoadingOrLoadedListener);
        imageLoadingOrLoadedListener.invalidated(null);
        InvalidationListener activeAttachmentListener = observable -> {
            boolean isActiveAttachment = this.isActiveProperty.get() && isAttachment;
            this.imageStack.pseudoClassStateChanged(ACTIVE, isActiveAttachment);
            this.imageStack.pseudoClassStateChanged(NON_ACTIVE, !isActiveAttachment);
        };
        this.isActiveProperty.addListener(activeAttachmentListener);
        activeAttachmentListener.invalidated(null);
        InvalidationListener tooltipTextListener = observable -> this.updateTooltip();
        this.isActiveProperty.addListener(tooltipTextListener);
        this.isImageLoadingProperty.addListener(tooltipTextListener);
        this.imageLoadErrorProperty.addListener(tooltipTextListener);
        tooltipTextListener.invalidated(null);
    }

    public void setItem(@Nullable IFramebufferImageCellItem item) {
        this.itemProperty.set((Object)item);
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Node> graphicProperty() {
        return this.graphicProperty;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Tooltip> tooltipProperty() {
        return this.tooltipProperty;
    }

    private void updateTooltip() {
        String tooltipText;
        String imageLoadError;
        String imageInfoText = this.isImageLoadedProperty.get() ? null : (this.isImageLoadingProperty.get() ? "Image is loading" : ((imageLoadError = (String)this.imageLoadErrorProperty.get()) != null && !imageLoadError.isEmpty() ? String.valueOf((String)this.imageLoadErrorProperty.get()) + System.lineSeparator() + IMAGE_LOAD_ERROR_INFO : IMAGE_LOAD_ERROR_INFO));
        if (this.isAttachment) {
            String activeItemText;
            String string = activeItemText = this.isActiveProperty.get() ? "This attachment is currently active" : "This attachment is not currently active";
            tooltipText = imageInfoText != null && !imageInfoText.isEmpty() ? String.valueOf(activeItemText) + System.lineSeparator() + imageInfoText : activeItemText;
        } else {
            tooltipText = imageInfoText;
        }
        if (tooltipText == null || tooltipText.isEmpty()) {
            this.tooltipProperty.set(null);
        } else {
            this.framebufferListCellTooltip.setText(tooltipText);
            this.tooltipProperty.set((Object)this.framebufferListCellTooltip);
        }
    }
}

