/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.framebuffer;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.texture.IGlImageProvider;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.framebuffer.FramebufferAttachmentData;
import com.arm.mgd.ui.controllers.framebuffer.FramebufferData;
import com.arm.mgd.ui.utils.JavaFXImageLoader;
import com.arm.mgd.ui.utils.RGBAImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.Image;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class FramebufferImage {
    private final @NonNull ExecutorService executor;
    private final @NonNull GlFramebufferAsset framebuffer;
    private final @NonNull AbstractConstantOrAliasSpecExtended attachment;
    private final @Nullable Integer multiViewId;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull FramebufferFeature.CaptureMode captureMode;
    private final boolean isActiveAttachment;
    private final boolean isAlphaOpacity;
    private final @NonNull ObjectProperty<@Nullable RGBAImage.AlphaMode> alphaModeProperty = new SimpleObjectProperty();
    private final @NonNull FramebufferImageLoader framebufferLoader;
    private final @NonNull BooleanProperty isImageLoadingProperty = new SimpleBooleanProperty();
    private final @NonNull BooleanProperty isImageLoadedProperty = new SimpleBooleanProperty();
    private final @NonNull ObjectProperty<@Nullable RGBAImage> rawImageProperty = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<@Nullable Image> imageProperty = new SimpleObjectProperty();
    private final @NonNull StringProperty imageLoadErrorProperty = new SimpleStringProperty();

    FramebufferImage(@NonNull FramebufferData data, @NonNull ExecutorService executor) {
        this.executor = executor;
        this.framebuffer = data.getFramebuffer();
        AbstractConstantOrAliasSpecExtended firstAttachment = this.framebuffer.getFirstAvailableCaptureDataAttachment();
        this.attachment = firstAttachment != null ? firstAttachment : KapiSpec.GLES.constants.GL_COLOR_ATTACHMENT0;
        this.multiViewId = null;
        this.captureMode = data.getCaptureMode();
        this.isActiveAttachment = false;
        this.isAlphaOpacity = false;
        this.framebufferLoader = new FramebufferImageLoader(this.framebuffer, this.attachment, this.multiViewId);
        this.isImageLoadingProperty.bind((ObservableValue)this.imageLoadErrorProperty.isNull().and((ObservableBooleanValue)this.imageProperty.isNull()));
        this.isImageLoadedProperty.bind((ObservableValue)this.imageProperty.isNotNull());
        this.alphaModeProperty.set((Object)RGBAImage.AlphaMode.IGNORE_ALPHA);
        this.updateImage();
    }

    FramebufferImage(@NonNull FramebufferAttachmentData data, @NonNull ExecutorService executor, @NonNull ReadOnlyObjectProperty<@Nullable RGBAImage.AlphaMode> alphaModeProperty) {
        this.executor = executor;
        this.framebuffer = data.getFramebuffer();
        this.attachment = data.getAttachment();
        this.multiViewId = data.getMultiViewId();
        this.captureMode = data.getCaptureMode();
        this.isActiveAttachment = data.isActive();
        this.isAlphaOpacity = data.isAlphaOpacity();
        this.framebufferLoader = new FramebufferImageLoader(this.framebuffer, this.attachment, this.multiViewId);
        this.alphaModeProperty.addListener((observable, oldValue, newValue) -> this.updateImage());
        this.isImageLoadingProperty.bind((ObservableValue)this.imageLoadErrorProperty.isNull().and((ObservableBooleanValue)this.imageProperty.isNull()));
        this.isImageLoadedProperty.bind((ObservableValue)this.imageProperty.isNotNull());
        if (this.isAlphaOpacity) {
            this.alphaModeProperty.bind(alphaModeProperty);
        } else {
            this.alphaModeProperty.set((Object)RGBAImage.AlphaMode.IGNORE_ALPHA);
        }
    }

    void dispose() {
        this.framebufferLoader.isCancelled.set(true);
        this.alphaModeProperty.unbind();
        this.alphaModeProperty.set(null);
        this.rawImageProperty.set(null);
        this.imageProperty.set(null);
        this.imageLoadErrorProperty.set(null);
    }

    private void updateImage() {
        assert (Platform.isFxApplicationThread());
        this.imageProperty.set(null);
        this.imageLoadErrorProperty.set(null);
        RGBAImage.AlphaMode alphaMode = (RGBAImage.AlphaMode)((Object)this.alphaModeProperty.get());
        if (alphaMode != null) {
            this.executor.execute(() -> {
                if (this.framebufferLoader.isCancelled.get()) {
                    return;
                }
                RGBAImage rawImage = null;
                Image image = null;
                String loadError = null;
                try {
                    JavaFXImageLoader.JavaFXImage javaFXImage = this.framebufferLoader.getImage(alphaMode);
                    rawImage = javaFXImage.rawImage;
                    image = javaFXImage.image;
                }
                catch (Throwable t) {
                    loadError = t.getMessage();
                }
                RGBAImage finalRawImage = rawImage;
                Image finalImage = image;
                String finalLoadError = loadError;
                Platform.runLater(() -> {
                    RGBAImage.AlphaMode newAlphaMode = (RGBAImage.AlphaMode)((Object)((Object)((Object)this.alphaModeProperty.get())));
                    if (!this.framebufferLoader.isCancelled.get() && newAlphaMode == alphaMode) {
                        this.rawImageProperty.set((Object)finalRawImage);
                        this.imageProperty.set((Object)finalImage);
                        this.imageLoadErrorProperty.set((Object)finalLoadError);
                    }
                });
            });
        }
    }

    public @NonNull GlFramebufferAsset getFramebuffer() {
        return this.framebuffer;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getAttachment() {
        return this.attachment;
    }

    public @Nullable Integer getMultiViewId() {
        return this.multiViewId;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull FramebufferFeature.CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public boolean isActiveAttachment() {
        return this.isActiveAttachment;
    }

    public boolean isAlphaOpacity() {
        return this.isAlphaOpacity;
    }

    public @NonNull ReadOnlyBooleanProperty isImageLoadingProperty() {
        return this.isImageLoadingProperty;
    }

    public @NonNull ReadOnlyBooleanProperty isImageLoadedProperty() {
        return this.isImageLoadedProperty;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable RGBAImage> rawImageProperty() {
        return this.rawImageProperty;
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Image> imageProperty() {
        return this.imageProperty;
    }

    public @NonNull ReadOnlyStringProperty imageLoadErrorProperty() {
        return this.imageLoadErrorProperty;
    }

    private static class FramebufferImageLoader
    extends JavaFXImageLoader {
        private final @NonNull AtomicBoolean isCancelled = new AtomicBoolean();

        private FramebufferImageLoader(@NonNull GlFramebufferAsset framebuffer, @NonNull AbstractConstantOrAliasSpecExtended attachment, @Nullable Integer multiViewId) {
            super((IImageProvider)FramebufferImageLoader.getImageProvider(framebuffer, attachment, multiViewId));
        }

        private static @NonNull IGlImageProvider getImageProvider(@NonNull GlFramebufferAsset framebuffer, @NonNull AbstractConstantOrAliasSpecExtended attachment, @Nullable Integer multiViewId) {
            if (multiViewId != null) {
                return framebuffer.getGlMultiviewAttachmentImageProvider(attachment, multiViewId.intValue());
            }
            return framebuffer.getGlAttachmentImageProvider(attachment);
        }
    }
}

