/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.framebuffer;

import com.arm.mgd.core.asset.GlFramebufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentBinding;
import com.arm.mgd.core.asset.GlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.core.asset.GlRenderbufferAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.ui.controllers.framebuffer.FramebufferAttachmentData;
import com.arm.mgd.ui.views.framebuffer.FramebufferImage;
import com.arm.mgd.ui.views.framebuffer.ICrossBarItem;
import com.arm.mgd.ui.views.framebuffer.ICrossBarVisitor;
import com.arm.mgd.ui.views.framebuffer.IFramebufferImageCellItem;
import com.arm.mgd.utils.NullUtils;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.ReadOnlyObjectProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class FramebufferAttachmentCrossBarItem
implements IFramebufferImageCellItem,
ICrossBarItem {
    private final @NonNull FramebufferAttachmentData data;
    private final @NonNull ExecutorService executor;
    private final @NonNull ReadOnlyObjectProperty< @Nullable RGBAImage.AlphaMode> alphaModeProperty;
    private @Nullable FramebufferImage image = null;

    FramebufferAttachmentCrossBarItem(@NonNull FramebufferAttachmentData data, @NonNull ExecutorService executor, @NonNull ReadOnlyObjectProperty< @Nullable RGBAImage.AlphaMode> alphaModeProperty) {
        this.data = data;
        this.executor = executor;
        this.alphaModeProperty = alphaModeProperty;
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public @NonNull FramebufferAttachmentData getData() {
        return this.data;
    }

    @Override
    public @NonNull FramebufferImage getImage() {
        if (this.image == null) {
            this.image = new FramebufferImage(this.data, this.executor, this.alphaModeProperty);
        }
        return (FramebufferImage)NullUtils.neverNull((Object)this.image);
    }

    @Override
    public @NonNull String getHeading() {
        return (String)NullUtils.neverNull((Object)this.data.getAttachment().toString());
    }

    @Override
    public @NonNull String getSubHeading() {
        GlFramebufferAttachmentBinding attachmentBinding = this.data.getFramebuffer().getAttachmentBinding(this.data.getAttachment());
        if (attachmentBinding == null) {
            return "";
        }
        GlFramebufferAttachmentAsset attachmentAsset = attachmentBinding.getAsset();
        IAssetItem asset = attachmentAsset.getAsset();
        if (asset instanceof GlTextureAsset) {
            GlTextureAsset texture = (GlTextureAsset)asset;
            GlTextureImageAsset imageAsset = texture.getTextureMipmapImage();
            if (imageAsset != null) {
                Integer viewId = this.data.getMultiViewId();
                if (attachmentAsset instanceof GlFramebufferTextureMultiviewAttachmentAsset && viewId != null) {
                    return "View " + viewId + ", " + imageAsset.getInternalFormat().getName() + ", " + imageAsset.getWidth() + " x " + imageAsset.getHeight();
                }
                return String.valueOf(imageAsset.getInternalFormat().getName()) + ", " + imageAsset.getWidth() + " x " + imageAsset.getHeight();
            }
        } else if (asset instanceof GlRenderbufferAsset) {
            GlRenderbufferAsset renderbuffer = (GlRenderbufferAsset)asset;
            return String.valueOf(renderbuffer.getInternalFormat().getName()) + ", " + renderbuffer.getWidth() + " x " + renderbuffer.getHeight();
        }
        return "";
    }

    @Override
    public <T> T accept(@NonNull ICrossBarVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

