/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.framebuffer;

import com.arm.mgd.ui.views.framebuffer.FramebufferAttachmentCrossBarItem;
import com.arm.mgd.ui.views.framebuffer.FramebufferListCellGraphic;
import com.arm.mgd.ui.views.framebuffer.HistogramCrossbarItem;
import com.arm.mgd.ui.views.framebuffer.HistogramListCellGraphic;
import com.arm.mgd.ui.views.framebuffer.ICrossBarItem;
import com.arm.mgd.ui.views.framebuffer.ICrossBarVisitor;
import javafx.scene.control.ListCell;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class CrossBarListCell
extends ListCell<ICrossBarItem> {
    private final @NonNull FramebufferListCellGraphic attachmentGraphic = new FramebufferListCellGraphic(true);
    private final @NonNull HistogramListCellGraphic histogramGraphic = new HistogramListCellGraphic();

    CrossBarListCell() {
    }

    protected void updateItem(@Nullable ICrossBarItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.graphicProperty().unbind();
            this.graphicProperty().set(null);
            this.tooltipProperty().unbind();
            this.tooltipProperty().set(null);
            this.attachmentGraphic.setItem(null);
            this.histogramGraphic.setItem(null);
        } else {
            item.accept(new ICrossBarVisitor<Void>(){

                @Override
                public Void visit(@NonNull FramebufferAttachmentCrossBarItem attachmentItem) {
                    CrossBarListCell.this.graphicProperty().bind(CrossBarListCell.this.attachmentGraphic.graphicProperty());
                    CrossBarListCell.this.tooltipProperty().bind(CrossBarListCell.this.attachmentGraphic.tooltipProperty());
                    CrossBarListCell.this.attachmentGraphic.setItem(attachmentItem);
                    CrossBarListCell.this.histogramGraphic.setItem(null);
                    return null;
                }

                @Override
                public Void visit(@NonNull HistogramCrossbarItem histogramItem) {
                    CrossBarListCell.this.graphicProperty().bind(CrossBarListCell.this.histogramGraphic.graphicProperty());
                    CrossBarListCell.this.tooltipProperty().unbind();
                    CrossBarListCell.this.tooltipProperty().set(null);
                    CrossBarListCell.this.attachmentGraphic.setItem(null);
                    CrossBarListCell.this.histogramGraphic.setItem(histogramItem);
                    return null;
                }
            });
        }
    }
}

