/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views.diffreport;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.diff.ContainerDiffItem;
import com.arm.mgd.core.diff.DiffItem;
import com.arm.mgd.core.diff.MultiValueDiffItem;
import com.arm.mgd.core.diff.SingleValueDiffItem;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.state.StateValue;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.ReverseComparator;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.views.TraceEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;

public class DiffItemDecoratorFactory {
    private static final String _STYLE_DIFFERENT_FG = "_STYLE_DIFFERENT_FG";
    private static final String _STYLE_LINK_MORE_FG = "_STYLE_LINK_MORE_FG";
    private static final String _STYLE_PREVIOUS_FG = "_STYLE_PREVIOUS_FG";
    private static final String _STYLE_NORMAL = "_STYLE_NORMAL_FG";
    private static final StyledString.Styler STYLE_DIFFERENT;
    private static final StyledString.Styler STYLE_LINK_MORE;
    private static final StyledString.Styler STYLE_PREVIOUSLY_CHANGED;
    private static final StyledString.Styler STYLE_NORMAL;

    static {
        ColorRegistry cRegistry = JFaceResources.getColorRegistry();
        cRegistry.put(_STYLE_DIFFERENT_FG, new RGB(160, 0, 32));
        cRegistry.put(_STYLE_PREVIOUS_FG, new RGB(96, 160, 160));
        cRegistry.put(_STYLE_LINK_MORE_FG, new RGB(192, 192, 192));
        cRegistry.put(_STYLE_NORMAL, new RGB(160, 160, 160));
        STYLE_DIFFERENT = StyledString.createColorRegistryStyler((String)_STYLE_DIFFERENT_FG, null);
        STYLE_PREVIOUSLY_CHANGED = StyledString.createColorRegistryStyler((String)_STYLE_PREVIOUS_FG, null);
        STYLE_LINK_MORE = StyledString.createColorRegistryStyler((String)_STYLE_LINK_MORE_FG, null);
        STYLE_NORMAL = StyledString.createColorRegistryStyler((String)_STYLE_NORMAL, null);
    }

    public static @NonNull Control createView(@NonNull Composite parent, @NonNull DiffItem diffItem) {
        if (diffItem instanceof ContainerDiffItem) {
            ContainerDiffItem container = (ContainerDiffItem)diffItem;
            if (container.getType() == ContainerDiffItem.Type.GROUP) {
                return DiffItemDecoratorFactory.createGroupView(parent, container);
            }
            return DiffItemDecoratorFactory.createTreeView(parent, container);
        }
        ArrayList<DiffItem> list = new ArrayList<DiffItem>();
        list.add(diffItem);
        return DiffItemDecoratorFactory.createTreeView(parent, list);
    }

    private static @NonNull Control createGroupView(@NonNull Composite parent, @NonNull ContainerDiffItem diffItem) {
        GridLayout mainLayout = new GridLayout(1, false);
        Composite main = new Composite(parent, 0);
        Label description = new Label(main, 0);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        mainLayout.marginLeft = 0;
        mainLayout.marginRight = 0;
        mainLayout.marginTop = 10;
        mainLayout.marginBottom = 0;
        mainLayout.horizontalSpacing = 0;
        mainLayout.verticalSpacing = 10;
        main.setLayout((Layout)mainLayout);
        description.setLayoutData((Object)new GridData(4, 1, true, false));
        description.setText(diffItem.getDescription());
        DiffItemDecoratorFactory.setFontSizeIncrease(description, 2, true, false);
        if (diffItem.size() == 0) {
            Label noChildren = new Label(main, 0);
            noChildren.setLayoutData((Object)new GridData(4, 1, true, false));
            noChildren.setText("No differences found");
            DiffItemDecoratorFactory.setFontSizeIncrease(description, 0, false, true);
        }
        ArrayList<DiffItem> unassociatedItems = null;
        for (DiffItem child : diffItem) {
            if (child instanceof ContainerDiffItem) {
                if (unassociatedItems != null) {
                    DiffItemDecoratorFactory.createTreeView(main, unassociatedItems);
                    unassociatedItems = null;
                }
                DiffItemDecoratorFactory.createTreeView(main, (ContainerDiffItem)child);
                continue;
            }
            if (unassociatedItems == null) {
                unassociatedItems = new ArrayList<DiffItem>();
            }
            unassociatedItems.add(child);
        }
        if (unassociatedItems != null) {
            DiffItemDecoratorFactory.createTreeView(main, unassociatedItems);
            unassociatedItems = null;
        }
        return main;
    }

    private static @NonNull Control createTreeView(@NonNull Composite parent, @NonNull ContainerDiffItem parentNode) {
        return DiffItemDecoratorFactory.createTreeViewActual(parent, parentNode, parentNode.getDescription());
    }

    private static @NonNull Control createTreeView(@NonNull Composite parent, @NonNull List<DiffItem> parentNode) {
        return DiffItemDecoratorFactory.createTreeViewActual(parent, parentNode, null);
    }

    private static @NonNull Control createTreeViewActual(@NonNull Composite parent, Object parentNode, String labelText) {
        assert (parentNode instanceof ContainerDiffItem || parentNode instanceof List);
        if (labelText != null) {
            Label description = new Label(parent, 0);
            description.setLayoutData((Object)new GridData(4, 1, true, false));
            description.setText(labelText);
            DiffItemDecoratorFactory.setFontSizeIncrease(description, 1, false, false);
        }
        GridLayout mainLayout = new GridLayout(1, false);
        Tree tree = new Tree(parent, 2816);
        final TreeViewer treeViewer = new TreeViewer(tree);
        TreeViewerColumn treeColumn = new TreeViewerColumn(treeViewer, 16384, 0);
        TreeViewerColumn beforeColumn = new TreeViewerColumn(treeViewer, 0x1000000, 1);
        TreeViewerColumn afterColumn = new TreeViewerColumn(treeViewer, 0x1000000, 2);
        TreeViewerColumn functionsColumn = new TreeViewerColumn(treeViewer, 131072, 3);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        mainLayout.marginLeft = 0;
        mainLayout.marginRight = 0;
        mainLayout.marginTop = 10;
        mainLayout.marginBottom = 0;
        mainLayout.verticalSpacing = 10;
        mainLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)mainLayout);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        treeColumn.getColumn().setText("");
        treeColumn.getColumn().setResizable(true);
        treeColumn.getColumn().setMoveable(false);
        treeColumn.getColumn().setWidth(200);
        treeColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TreeLabelProvider()));
        beforeColumn.getColumn().setText("Original value");
        beforeColumn.getColumn().setResizable(true);
        beforeColumn.getColumn().setMoveable(false);
        beforeColumn.getColumn().setWidth(200);
        beforeColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DiffLabelProvider(true)));
        afterColumn.getColumn().setText("Current value");
        afterColumn.getColumn().setResizable(true);
        afterColumn.getColumn().setMoveable(false);
        afterColumn.getColumn().setWidth(200);
        afterColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DiffLabelProvider(false)));
        functionsColumn.getColumn().setText("Related functions");
        functionsColumn.getColumn().setResizable(true);
        functionsColumn.getColumn().setMoveable(false);
        functionsColumn.getColumn().setWidth(200);
        functionsColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new FunctionLinkLabelProvider()));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DiffItemMenuProvider.fill(manager, treeViewer.getSelection());
            }
        });
        treeViewer.getControl().setMenu(menu);
        treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        treeViewer.setInput(parentNode);
        treeColumn.getColumn().pack();
        beforeColumn.getColumn().pack();
        afterColumn.getColumn().pack();
        treeViewer.refresh();
        return tree;
    }

    private static void setFontSizeIncrease(Label label, int inc, boolean bold, boolean italic) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = label.getFont().getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            int style = bold && italic ? 3 : (bold ? 1 : (italic ? 2 : 0));
            element.setHeight(element.getHeight() + inc);
            element.setStyle(style);
            ++n2;
        }
        final Font newFont = new Font((Device)label.getDisplay(), fontData);
        label.setFont(newFont);
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
    }

    private static class DiffItemMenuProvider {
        private static final int MENU_CASCADE_LIMIT = 25;

        private DiffItemMenuProvider() {
        }

        public static void fill(IMenuManager manager, ISelection selection) {
            if (manager == null || selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object element = sSelection.getFirstElement();
            if (element instanceof DiffItem) {
                DiffItem diffItem = (DiffItem)element;
                TreeSet<@NonNull FunctionCall> functions = new TreeSet<FunctionCall>((Comparator<FunctionCall>)new ReverseComparator());
                functions.addAll(diffItem.getRelatedFunctions());
                if (!functions.isEmpty()) {
                    DiffItemMenuProvider.fill(manager, functions);
                }
            }
        }

        private static void fill(IMenuManager manager, SortedSet<@NonNull FunctionCall> functions) {
            MenuManager parentItem = new MenuManager("Jump to related function");
            manager.add((IContributionItem)parentItem);
            if (functions.size() <= 25) {
                DiffItemMenuProvider.fillSubMenu((IMenuManager)parentItem, functions.iterator());
            } else {
                Iterator<FunctionCall> iterator = functions.iterator();
                while (iterator.hasNext()) {
                    MenuManager subItem = new MenuManager("");
                    parentItem.add((IContributionItem)subItem);
                    DiffItemMenuProvider.fillSubMenu((IMenuManager)subItem, iterator);
                    IContributionItem[] childItems = subItem.getItems();
                    ActionContributionItem firstchild = (ActionContributionItem)childItems[0];
                    ActionContributionItem lastchild = (ActionContributionItem)childItems[childItems.length - 1];
                    subItem.setMenuText(String.valueOf(((JumpToFunctionAction)firstchild.getAction()).getFunctionCall().getIndex()) + " - " + ((JumpToFunctionAction)lastchild.getAction()).getFunctionCall().getIndex());
                }
            }
        }

        private static void fillSubMenu(IMenuManager parentItem, Iterator<@NonNull FunctionCall> iterator) {
            int i = 0;
            while (iterator.hasNext() && i < 25) {
                parentItem.add((IAction)new JumpToFunctionAction(iterator.next()));
                ++i;
            }
        }
    }

    private static class DiffLabelProvider
    extends TreeLabelProvider {
        private final boolean first;

        public DiffLabelProvider(boolean first) {
            this.first = first;
        }

        @Override
        public Image getImage(Object arg0) {
            return null;
        }

        @Override
        public StyledString getStyledText(Object element) {
            if (element instanceof MultiValueDiffItem) {
                MultiValueDiffItem mvdi = (MultiValueDiffItem)element;
                StyledString result = new StyledString("[");
                String comma = "";
                for (SingleValueDiffItem child : mvdi) {
                    result.append(comma);
                    comma = ", ";
                    this.setSingleText(result, child);
                }
                result.append("]");
                return result;
            }
            if (element instanceof SingleValueDiffItem) {
                SingleValueDiffItem svdi = (SingleValueDiffItem)element;
                StyledString result = new StyledString();
                this.setSingleText(result, svdi);
                return result;
            }
            return new StyledString();
        }

        private String processValueObjectToString(Object object) {
            if (object == null) {
                return "";
            }
            if (object instanceof StateValue) {
                return this.processValueObjectToString(((StateValue)object).value);
            }
            return object.toString();
        }

        private void setSingleText(StyledString result, SingleValueDiffItem<?> child) {
            String value = this.processValueObjectToString(this.first ? child.getValue1() : child.getValue2());
            switch (child.getClassification()) {
                case PREVIOUSLY_CHANGED: {
                    result.append(value, STYLE_PREVIOUSLY_CHANGED);
                    break;
                }
                case NEVER_CHANGED: {
                    result.append(value, STYLE_NORMAL);
                    break;
                }
                case DIFFERENT: {
                    result.append(value, STYLE_DIFFERENT);
                    break;
                }
            }
        }
    }

    private static class FunctionLinkLabelProvider
    extends TreeLabelProvider {
        private static final int MAX_ITEMS_TO_SHOW = 5;
        private static final int TOOLTIP_NL_LIMIT = 25;

        private FunctionLinkLabelProvider() {
        }

        @Override
        public Image getImage(Object element) {
            return null;
        }

        @Override
        public StyledString getStyledText(Object element) {
            if (element instanceof DiffItem) {
                DiffItem diffItem = (DiffItem)element;
                StyledString result = new StyledString();
                TreeSet functions = new TreeSet(new ReverseComparator());
                functions.addAll(diffItem.getRelatedFunctions());
                int itemsToSkip = Math.max(0, functions.size() - 5);
                int counter = 0;
                String spacer = "";
                for (FunctionCall fc : functions) {
                    result.append(spacer);
                    result.append(String.valueOf(fc.getIndex()));
                    spacer = ", ";
                    if (++counter >= 5) break;
                }
                if (itemsToSkip > 0) {
                    result.append("... and " + itemsToSkip + " more " + StringUtils.formatQuantity((long)itemsToSkip, (String)"function", (String)"functions"), STYLE_LINK_MORE);
                }
                return result;
            }
            return new StyledString();
        }

        public String getToolTipText(Object element) {
            if (element instanceof DiffItem) {
                DiffItem diffItem = (DiffItem)element;
                SortedSet functions = diffItem.getRelatedFunctions();
                StringBuilder result = new StringBuilder();
                int nlCounter = 0;
                String spacer = "";
                for (FunctionCall fc : functions) {
                    if (nlCounter < 25) {
                        result.append(spacer);
                        spacer = ", ";
                        ++nlCounter;
                    } else {
                        result.append(",\n");
                        nlCounter = 0;
                    }
                    result.append(String.valueOf(fc.getIndex()));
                }
                return result.toString();
            }
            return "";
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }
    }

    private static class JumpToFunctionAction
    extends Action {
        private final @NonNull FunctionCall functionCall;

        public JumpToFunctionAction(@NonNull FunctionCall functionCall) {
            this.functionCall = functionCall;
            this.setText(String.format("%s: %s", functionCall.getIndex(), functionCall.getFunctionSpec().getName()));
            this.setEnabled(true);
        }

        public FunctionCall getFunctionCall() {
            return this.functionCall;
        }

        public void run() {
            CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)this.functionCall), (Object)this);
            TraceEditor editor = TargetConnectionManager.findEditorForModel(this.functionCall.getModel());
            if (editor != null) {
                editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
            }
        }
    }

    private static class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object object) {
            if (object != null && object instanceof ContainerDiffItem) {
                return ((ContainerDiffItem)object).toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object object) {
            if (object != null) {
                if (object instanceof ContainerDiffItem) {
                    return ((ContainerDiffItem)object).toArray();
                }
                if (object instanceof Collection) {
                    return ((Collection)object).toArray();
                }
                assert (false);
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object != null && object instanceof ContainerDiffItem) {
                return ((ContainerDiffItem)object).size() > 0;
            }
            return false;
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }

    private static class TreeLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof DiffItem) {
                return new StyledString(((DiffItem)element).getDescription());
            }
            return new StyledString();
        }

        public String getText(Object element) {
            return this.getStyledText(element).toString();
        }
    }
}

