/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.VerticesViewController;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ArrayChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Point3D;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.StringConverter;
import org.eclipse.jdt.annotation.NonNull;

public class VerticesViewGeometryTab
extends AnchorPane {
    @FXML
    private Label geometryNoDataLabel;
    @FXML
    private StackPane geometryPane;
    @FXML
    private AnchorPane axisAnchorPane;
    @FXML
    private Button resetCameraButton;
    @FXML
    private ComboBox<VerticesViewController.VertexAttributeColumnItem> positionAttributeComboBox;
    private final @NonNull VerticesViewController controller;
    private final @NonNull DoubleProperty xTranslateCamera = new SimpleDoubleProperty();
    private final @NonNull DoubleProperty yTranslateCamera = new SimpleDoubleProperty();
    private final @NonNull DoubleProperty zTranslateCamera = new SimpleDoubleProperty();
    private final @NonNull Affine cameraRotation = new Affine();
    private final @NonNull Affine geometryRotation = new Affine();
    private SubScene geometrySubScene;
    private boolean mouseDragged = false;

    public VerticesViewGeometryTab(final @NonNull VerticesViewController controller) {
        this.controller = controller;
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/verticesViewGeometryTab.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return;
        }
        this.geometryNoDataLabel.textProperty().bind((ObservableValue)controller.noGeometryDataReasonProperty());
        this.geometryNoDataLabel.visibleProperty().bind((ObservableValue)controller.geometryDataAvailableProperty().not());
        Group geometryMesh = this.setupGeometry();
        Group axis = VerticesViewGeometryTab.setupAxis();
        AmbientLight axisLight = new AmbientLight();
        axisLight.setColor(Color.WHITE);
        Group axisGroup = new Group(new Node[]{axis, axisLight});
        Translate axisTranslation = new Translate();
        axisTranslation.setX(50.0);
        axisTranslation.setY(50.0);
        AmbientLight geometryLight = new AmbientLight();
        geometryLight.setColor(Color.WHITE);
        Translate geometryTranslation = new Translate();
        geometryTranslation.xProperty().bind((ObservableValue)controller.verticesCenterXProperty());
        geometryTranslation.yProperty().bind((ObservableValue)controller.verticesCenterYProperty());
        geometryTranslation.zProperty().bind((ObservableValue)controller.verticesCenterZProperty());
        Translate inverseGeometryTranslation = new Translate();
        inverseGeometryTranslation.xProperty().bind((ObservableValue)controller.verticesCenterXProperty().negate());
        inverseGeometryTranslation.yProperty().bind((ObservableValue)controller.verticesCenterYProperty().negate());
        inverseGeometryTranslation.zProperty().bind((ObservableValue)controller.verticesCenterZProperty().negate());
        geometryMesh.getTransforms().addAll((Object[])new Transform[]{geometryTranslation, this.geometryRotation, inverseGeometryTranslation});
        axis.getTransforms().addAll((Object[])new Transform[]{axisTranslation, this.geometryRotation});
        Group totalGroup = new Group(new Node[]{geometryMesh, geometryLight});
        this.geometrySubScene = this.createScene3D(totalGroup);
        this.geometrySubScene.disableProperty().bind((ObservableValue)controller.geometryDataAvailableProperty().not());
        this.geometryPane.getChildren().add(0, (Object)this.geometrySubScene);
        this.geometrySubScene.heightProperty().bind((ObservableValue)this.geometryPane.heightProperty());
        this.geometrySubScene.widthProperty().bind((ObservableValue)this.geometryPane.widthProperty());
        this.geometrySubScene.setManaged(false);
        SubScene axisSubScene = new SubScene((Parent)axisGroup, 0.0, 0.0, false, SceneAntialiasing.BALANCED);
        axisSubScene.visibleProperty().bind((ObservableValue)controller.geometryDataAvailableProperty());
        axisSubScene.fillProperty().set((Object)Color.TRANSPARENT);
        axisSubScene.heightProperty().bind((ObservableValue)this.axisAnchorPane.heightProperty());
        axisSubScene.widthProperty().bind((ObservableValue)this.axisAnchorPane.widthProperty());
        axisSubScene.setManaged(false);
        this.axisAnchorPane.getChildren().add((Object)axisSubScene);
        controller.maxDimensionRangeProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                VerticesViewGeometryTab.this.resetCamera();
            }
        });
        controller.verticesCenterProperty().addListener((ChangeListener)new ChangeListener<Point3D>(){

            public void changed(ObservableValue<? extends Point3D> observable, Point3D oldValue, Point3D newValue) {
                VerticesViewGeometryTab.this.resetCamera();
            }
        });
        this.positionAttributeComboBox.setItems(controller.getVertexAttributes());
        this.positionAttributeComboBox.setConverter((StringConverter)new StringConverter<VerticesViewController.VertexAttributeColumnItem>(){

            public String toString(VerticesViewController.VertexAttributeColumnItem object) {
                if (object == null) {
                    return "";
                }
                return String.valueOf(object.getName()) + " (" + object.getType() + ")";
            }

            public VerticesViewController.VertexAttributeColumnItem fromString(String string) {
                return null;
            }
        });
        this.positionAttributeComboBox.getItems().addListener((ListChangeListener)new ListChangeListener<VerticesViewController.VertexAttributeColumnItem>(){

            public void onChanged(ListChangeListener.Change<? extends VerticesViewController.VertexAttributeColumnItem> c) {
                Platform.runLater(() -> {
                    VerticesViewGeometryTab.this.positionAttributeComboBox.getSelectionModel().select(null);
                    VerticesViewGeometryTab.this.positionAttributeComboBox.getSelectionModel().select((Object)controller.getSuggestedPositionColumn());
                });
            }
        });
        this.positionAttributeComboBox.disableProperty().bind((ObservableValue)Bindings.isEmpty(controller.getVertexAttributes()));
        controller.selectedPositionProperty().bind((ObservableValue)this.positionAttributeComboBox.getSelectionModel().selectedItemProperty());
        this.resetCameraButton.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                VerticesViewGeometryTab.this.resetCamera();
            }
        });
        this.resetCameraButton.disableProperty().bind((ObservableValue)controller.geometryDataAvailableProperty().not());
        final ContextMenu contextMenu = new ContextMenu();
        MenuItem exportGeometry = new MenuItem("Export to .obj");
        exportGeometry.setOnAction(event -> controller.exportGeometryToObj());
        exportGeometry.disableProperty().bind((ObservableValue)controller.geometryDataAvailableProperty().not());
        contextMenu.getItems().add((Object)exportGeometry);
        this.geometrySubScene.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY) {
                    contextMenu.hide();
                }
            }
        });
        this.geometrySubScene.addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.SECONDARY) {
                    VerticesViewGeometryTab.this.mouseDragged = true;
                }
            }
        });
        this.geometrySubScene.addEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.SECONDARY && !VerticesViewGeometryTab.this.mouseDragged) {
                    contextMenu.show((Node)VerticesViewGeometryTab.this.geometrySubScene, event.getScreenX(), event.getScreenY());
                }
                VerticesViewGeometryTab.this.mouseDragged = false;
            }
        });
        this.geometrySubScene.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                contextMenu.hide();
            }
        });
    }

    private void resetCamera() {
        assert (Platform.isFxApplicationThread());
        Point3D meshCenter = (Point3D)this.controller.verticesCenterProperty().get();
        this.xTranslateCamera.set(meshCenter.getX());
        this.yTranslateCamera.set(meshCenter.getY());
        this.zTranslateCamera.set(meshCenter.getZ());
        this.cameraRotation.setToIdentity();
        this.geometryRotation.setToIdentity();
        double movementValue = this.controller.maxDimensionRangeProperty().get() * 2.0;
        Point3D movement = new Point3D(0.0, 0.0, -movementValue);
        this.moveCamera(movement);
    }

    private static Group setupAxis() {
        PhongMaterial redMaterial = new PhongMaterial();
        redMaterial.setDiffuseColor(Color.DARKRED);
        redMaterial.setSpecularColor(Color.RED);
        PhongMaterial greenMaterial = new PhongMaterial();
        greenMaterial.setDiffuseColor(Color.DARKGREEN);
        greenMaterial.setSpecularColor(Color.GREEN);
        PhongMaterial blueMaterial = new PhongMaterial();
        blueMaterial.setDiffuseColor(Color.DARKBLUE);
        blueMaterial.setSpecularColor(Color.BLUE);
        Box xAxis = new Box(40.0, 5.0, 5.0);
        xAxis.setMaterial((Material)redMaterial);
        xAxis.setTranslateX(19.0);
        Box yAxis = new Box(5.0, 40.0, 5.0);
        yAxis.setMaterial((Material)greenMaterial);
        yAxis.setTranslateY(19.0);
        Box zAxis = new Box(5.0, 5.0, 40.0);
        zAxis.setMaterial((Material)blueMaterial);
        zAxis.setTranslateZ(19.0);
        return new Group(new Node[]{xAxis, yAxis, zAxis});
    }

    private Group setupGeometry() {
        final TriangleMesh mesh = new TriangleMesh();
        this.controller.getPoints().addListener((ArrayChangeListener)new ArrayChangeListener<ObservableFloatArray>(){

            public void onChanged(ObservableFloatArray observableArray, boolean sizeChanged, int from, int to) {
                mesh.getPoints().setAll(observableArray);
            }
        });
        this.controller.getFaces().addListener((ArrayChangeListener)new ArrayChangeListener<ObservableIntegerArray>(){

            public void onChanged(ObservableIntegerArray observableArray, boolean sizeChanged, int from, int to) {
                mesh.getFaces().setAll(observableArray);
            }
        });
        this.controller.getTexCoords().addListener((ArrayChangeListener)new ArrayChangeListener<ObservableFloatArray>(){

            public void onChanged(ObservableFloatArray observableArray, boolean sizeChanged, int from, int to) {
                mesh.getTexCoords().setAll(observableArray);
            }
        });
        MeshView meshView = new MeshView();
        PhongMaterial blackMaterial = new PhongMaterial(Color.BLACK);
        blackMaterial.setSpecularColor(Color.LIGHTGRAY);
        meshView.setMaterial((Material)blackMaterial);
        meshView.setDrawMode(DrawMode.LINE);
        meshView.setCullFace(CullFace.NONE);
        meshView.setMesh((Mesh)mesh);
        return new Group(new Node[]{meshView});
    }

    private SubScene createScene3D(Group group) {
        SubScene scene3d = new SubScene((Parent)group, 0.0, 0.0, true, SceneAntialiasing.BALANCED);
        scene3d.setFill((Paint)Color.WHITE);
        PerspectiveCamera perspectiveCamera = new PerspectiveCamera(true);
        perspectiveCamera.setNearClip(0.0);
        perspectiveCamera.setFarClip(10000.0);
        Group cameraGroup = new Group(new Node[]{perspectiveCamera});
        ObservableList transforms = cameraGroup.getTransforms();
        group.getChildren().add((Object)cameraGroup);
        Translate cameraTranslation = new Translate();
        cameraTranslation.xProperty().bind((ObservableValue)this.xTranslateCamera);
        cameraTranslation.yProperty().bind((ObservableValue)this.yTranslateCamera);
        cameraTranslation.zProperty().bind((ObservableValue)this.zTranslateCamera);
        transforms.add((Object)cameraTranslation);
        transforms.add((Object)this.cameraRotation);
        scene3d.setCamera((Camera)perspectiveCamera);
        CameraMouseHandler cameraMouseHandler = new CameraMouseHandler();
        scene3d.setOnMouseDragged((EventHandler)cameraMouseHandler);
        scene3d.setOnMousePressed((EventHandler)cameraMouseHandler);
        scene3d.setOnScroll((EventHandler)new CameraScrollHandler());
        scene3d.setOnKeyPressed((EventHandler)new CameraKeyboardHandler());
        return scene3d;
    }

    private void moveCamera(Point3D preTransformedMovement) {
        assert (Platform.isFxApplicationThread());
        Point3D transformedMovement = this.cameraRotation.transform(preTransformedMovement);
        this.xTranslateCamera.set(this.xTranslateCamera.get() + transformedMovement.getX());
        this.yTranslateCamera.set(this.yTranslateCamera.get() + transformedMovement.getY());
        this.zTranslateCamera.set(this.zTranslateCamera.get() + transformedMovement.getZ());
    }

    public void requestFocus() {
        this.geometrySubScene.requestFocus();
    }

    private class CameraKeyboardHandler
    implements EventHandler<KeyEvent> {
        private CameraKeyboardHandler() {
        }

        public void handle(KeyEvent event) {
            Rotate yawRotation;
            Rotate pitchRotation;
            double movementValue = VerticesViewGeometryTab.this.controller.maxDimensionRangeProperty().get() / 10.0;
            Point3D movement = new Point3D(0.0, 0.0, 0.0);
            if (event.getCode().equals((Object)KeyCode.W)) {
                movement = movement.add(new Point3D(0.0, 0.0, movementValue));
            }
            if (event.getCode().equals((Object)KeyCode.S)) {
                movement = movement.add(new Point3D(0.0, 0.0, -movementValue));
            }
            if (event.getCode().equals((Object)KeyCode.A)) {
                movement = movement.add(new Point3D(-movementValue, 0.0, 0.0));
            }
            if (event.getCode().equals((Object)KeyCode.D)) {
                movement = movement.add(new Point3D(movementValue, 0.0, 0.0));
            }
            if (event.getCode().equals((Object)KeyCode.Q)) {
                movement = movement.add(new Point3D(0.0, -movementValue, 0.0));
            }
            if (event.getCode().equals((Object)KeyCode.E)) {
                movement = movement.add(new Point3D(0.0, movementValue, 0.0));
            }
            if (event.getCode().equals((Object)KeyCode.NUMPAD8)) {
                pitchRotation = new Rotate(0.5, Rotate.X_AXIS);
                VerticesViewGeometryTab.this.geometryRotation.append((Transform)pitchRotation);
            }
            if (event.getCode().equals((Object)KeyCode.NUMPAD2)) {
                pitchRotation = new Rotate(-0.5, Rotate.X_AXIS);
                VerticesViewGeometryTab.this.geometryRotation.append((Transform)pitchRotation);
            }
            if (event.getCode().equals((Object)KeyCode.NUMPAD4)) {
                yawRotation = new Rotate(-0.5, Rotate.Y_AXIS);
                VerticesViewGeometryTab.this.geometryRotation.append((Transform)yawRotation);
            }
            if (event.getCode().equals((Object)KeyCode.NUMPAD6)) {
                yawRotation = new Rotate(0.5, Rotate.Y_AXIS);
                VerticesViewGeometryTab.this.geometryRotation.append((Transform)yawRotation);
            }
            VerticesViewGeometryTab.this.moveCamera(movement);
        }
    }

    private class CameraMouseHandler
    implements EventHandler<MouseEvent> {
        private double oldXPosition = 0.0;
        private double oldYPosition = 0.0;

        private CameraMouseHandler() {
        }

        public void handle(MouseEvent event) {
            if (event.getEventType().equals(MouseEvent.MOUSE_PRESSED)) {
                this.oldXPosition = event.getSceneX();
                this.oldYPosition = event.getSceneY();
            } else if (event.getEventType().equals(MouseEvent.MOUSE_DRAGGED)) {
                double deltaX = event.getSceneX() - this.oldXPosition;
                double deltaY = event.getSceneY() - this.oldYPosition;
                this.oldXPosition = event.getSceneX();
                this.oldYPosition = event.getSceneY();
                if (event.isPrimaryButtonDown()) {
                    Rotate geometryPitchRotation = new Rotate();
                    geometryPitchRotation.setAxis(Rotate.X_AXIS);
                    geometryPitchRotation.setAngle(deltaY);
                    Rotate geometryYawRotation = new Rotate();
                    geometryYawRotation.setAxis(Rotate.Y_AXIS);
                    geometryYawRotation.setAngle(-deltaX);
                    VerticesViewGeometryTab.this.geometryRotation.prepend((Transform)geometryYawRotation);
                    VerticesViewGeometryTab.this.geometryRotation.prepend((Transform)geometryPitchRotation);
                } else if (event.isSecondaryButtonDown()) {
                    double movementValue = VerticesViewGeometryTab.this.controller.maxDimensionRangeProperty().get() / 100.0;
                    Point3D movement = new Point3D(0.0, 0.0, 0.0);
                    movement = movement.add(new Point3D(deltaX * movementValue, 0.0, 0.0));
                    movement = movement.add(new Point3D(0.0, deltaY * movementValue, 0.0));
                    VerticesViewGeometryTab.this.moveCamera(movement);
                }
            }
        }
    }

    private class CameraScrollHandler
    implements EventHandler<ScrollEvent> {
        private CameraScrollHandler() {
        }

        public void handle(ScrollEvent event) {
            double movementValue = VerticesViewGeometryTab.this.controller.maxDimensionRangeProperty().get() / 10.0;
            Point3D movement = new Point3D(0.0, 0.0, event.getDeltaY() / event.getMultiplierY() * movementValue);
            VerticesViewGeometryTab.this.moveCamera(movement);
        }
    }
}

