/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.VerticesViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.filterruler.FilterRuler;
import com.arm.mgd.ui.utils.MonospaceTextTableCell;
import com.arm.mgd.ui.views.VerticesViewGeometryTab;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VerticesView
extends FXViewPart {
    @FXML
    private TabPane root;
    @FXML
    private Tab attributesTab;
    @FXML
    private Tab indicesTab;
    @FXML
    private Tab geometryTab;
    @FXML
    private BorderPane attributesBorderPane;
    @FXML
    private TableView<Integer> attributesTable;
    @FXML
    private TextArea indicesTextArea;
    @FXML
    private AnchorPane noDataPane;
    @FXML
    private Label indicesNoDataLabel;
    private final @NonNull VerticesViewController controller = new VerticesViewController(this.visibleProperty());
    private Scene scene;

    @Override
    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/verticesView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.root = (TabPane)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.scene = new Scene((Parent)this.root);
        this.attributesTable.setItems(this.controller.getUniqueVertexIndices());
        this.attributesTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.createContextMenu();
        Label noDataLabel = new Label();
        noDataLabel.textProperty().bind((ObservableValue)this.controller.noIndicesDataReasonProperty());
        this.indicesNoDataLabel.textProperty().bind((ObservableValue)this.controller.noIndicesDataReasonProperty());
        this.attributesTable.setPlaceholder((Node)noDataLabel);
        this.controller.getVertexAttributes().addListener((ListChangeListener)new ListChangeListener<VerticesViewController.VertexAttributeColumnItem>(){

            public void onChanged(// Could not load outer class - annotation placement on inner may be incorrect
            ListChangeListener.Change<? extends @NonNull VerticesViewController.VertexAttributeColumnItem> c) {
                while (c.next()) {
                    VerticesView.this.reloadColumns((List<? extends VerticesViewController.VertexAttributeColumnItem>)c.getList());
                }
            }
        });
        this.reloadColumns((List<? extends VerticesViewController.VertexAttributeColumnItem>)this.controller.getVertexAttributes());
        this.indicesTextArea.textProperty().bind((ObservableValue)this.controller.indicesTextProperty());
        this.noDataPane.visibleProperty().bind((ObservableValue)this.controller.indicesDataAvailableProperty().not());
        this.noDataPane.disableProperty().bind((ObservableValue)this.controller.indicesDataAvailableProperty());
        FilterRuler filterRuler = new FilterRuler();
        filterRuler.setMinWidth(10.0);
        filterRuler.setPrefWidth(10.0);
        filterRuler.setMaxWidth(10.0);
        filterRuler.setMinHeight(0.0);
        filterRuler.setPrefHeight(0.0);
        filterRuler.minimumMarkerValueProperty().bind((ObservableValue)this.controller.firstVertexIndexProperty());
        filterRuler.maximumMarkerValueProperty().bind((ObservableValue)this.controller.lastVertexIndexProperty());
        Bindings.bindContent(filterRuler.markerSetsProperty(), this.controller.markerSetsProperty());
        Tooltip filterRulerTooltip = new Tooltip("Shows the sparseness of the indices buffer. Colored regions are utilized indices.");
        Tooltip.install((Node)filterRuler, (Tooltip)filterRulerTooltip);
        this.attributesBorderPane.setRight((Node)filterRuler);
        BorderPane.setMargin((Node)filterRuler, (Insets)new Insets(0.0, 0.0, 0.0, 2.0));
        VerticesViewGeometryTab geometryTabView = new VerticesViewGeometryTab(this.controller);
        this.geometryTab.setContent((Node)geometryTabView);
        this.root.setOnMouseReleased(event -> {
            if (this.root.getTabs().get(((SingleSelectionModel)this.root.selectionModelProperty().getValue()).selectedIndexProperty().intValue()) == this.geometryTab) {
                geometryTabView.requestFocus();
            }
        });
        return this.scene;
    }

    private void createContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem copy = new MenuItem("Copy");
        copy.setOnAction(e -> this.controller.copyVertexAttibutes((ObservableList<Integer>)this.attributesTable.getSelectionModel().getSelectedItems()));
        copy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        contextMenu.getItems().add((Object)copy);
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.attributesTable), contextMenu);
        ContextMenuHelper.createAndSetContextMenuForTextInputField((TextInputControl)NullUtils.neverNull((Object)this.indicesTextArea), true);
    }

    private void reloadColumns(List<? extends @NonNull VerticesViewController.VertexAttributeColumnItem> attributes) {
        ArrayList<TableColumn> newColumns = new ArrayList<TableColumn>();
        TableColumn vertexColumn = new TableColumn("Vertex");
        vertexColumn.setSortable(false);
        vertexColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Integer, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Integer, String> p) {
                return new ReadOnlyObjectWrapper((Object)((Integer)p.getValue()).toString());
            }
        });
        vertexColumn.setMinWidth(30.0);
        newColumns.add(vertexColumn);
        for (final VerticesViewController.VertexAttributeColumnItem vertexAttributeColumnItem : attributes) {
            String attributeTitle = String.valueOf(vertexAttributeColumnItem.getIndex()) + ": " + vertexAttributeColumnItem.getName();
            String attributeTooltipText = String.valueOf(attributeTitle) + " (" + vertexAttributeColumnItem.getType() + ")";
            Tooltip attributeTooltip = new Tooltip(attributeTooltipText);
            Label attrbiuteTitleLabel = new Label(attributeTitle);
            attrbiuteTitleLabel.setMaxWidth(Double.MAX_VALUE);
            attrbiuteTitleLabel.setMaxHeight(Double.MAX_VALUE);
            attrbiuteTitleLabel.setTooltip(attributeTooltip);
            attrbiuteTitleLabel.setContentDisplay(ContentDisplay.TEXT_ONLY);
            TableColumn attributeColumn = new TableColumn();
            attributeColumn.setSortable(false);
            attributeColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Integer, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<Integer, String> p) {
                    return new ReadOnlyObjectWrapper((Object)VerticesView.this.controller.getVertexAttributeValue((Integer)p.getValue(), 0, vertexAttributeColumnItem));
                }
            });
            attributeColumn.setCellFactory((Callback)new Callback<TableColumn<Integer, String>, TableCell<Integer, String>>(){

                public TableCell<Integer, String> call(TableColumn<Integer, String> param) {
                    return new MonospaceTextTableCell<Integer, String>();
                }
            });
            attributeColumn.setMinWidth(50.0);
            attributeColumn.setGraphic((Node)attrbiuteTitleLabel);
            newColumns.add(attributeColumn);
        }
        this.attributesTable.getColumns().setAll(newColumns);
    }

    @Override
    protected void setFxFocus() {
        this.root.requestFocus();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.verticesview";
    }
}

