/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.NumberValueComparator;
import com.arm.mgd.ui.controllers.UniformsViewController;
import com.arm.mgd.ui.controllers.UniformsViewItem;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.ui.views.widgets.TableHeaderTooltip;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.StringJoiner;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.TreeItemPropertyValueFactory;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class UniformsView
extends FXViewPart {
    private UniformsViewController controller;
    private Scene scene;
    @FXML
    private Parent rootContainer;
    @FXML
    private TreeTableView<UniformsViewItem> treeTableView;
    @FXML
    private TreeTableColumn<UniformsViewItem, String> programColumn;
    @FXML
    private TreeTableColumn<UniformsViewItem, Long> indexColumn;
    @FXML
    private TreeTableColumn<UniformsViewItem, UniformsViewItem.UniformLocation> locationColumn;
    @FXML
    private TreeTableColumn<UniformsViewItem, String> blockNameColumn;
    @FXML
    private TreeTableColumn<UniformsViewItem, Integer> blockIndexColumn;
    @FXML
    private TreeTableColumn<UniformsViewItem, String> nameColumn;
    @FXML
    private TreeTableColumn<UniformsViewItem, String> typeColumn;
    @FXML
    private TreeTableColumn<UniformsViewItem, String> valueColumn;
    private final @NonNull SimpleBooleanProperty isSelectedAssetCreatableAndModifiable = new SimpleBooleanProperty(false);
    private final @NonNull SimpleBooleanProperty isSelectedAssetCreatedByDummy = new SimpleBooleanProperty(false);

    @Override
    protected Scene createFxScene() {
        this.controller = new UniformsViewController(this.visibleProperty());
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/uniformsView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (Parent)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.treeTableView.rootProperty().bind(this.controller.rootProperty());
        this.programColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("program"));
        this.indexColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("index"));
        this.indexColumn.setComparator((Comparator)new NumberValueComparator());
        TableHeaderTooltip.makeHeaderWithTooltip(this.indexColumn, "Uniform index");
        this.locationColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("location"));
        this.locationColumn.setComparator((o1, o2) -> {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            return o1.compareByBlockThenLocation((UniformsViewItem.UniformLocation)o2);
        });
        TableHeaderTooltip.makeHeaderWithTooltip(this.locationColumn, "For uniforms in the default block, this is the location in the program.\nFor buffer-backed uniforms, this is the offset within the buffer.");
        this.blockNameColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("blockName"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.blockNameColumn, "Uniform block name in the program");
        this.blockIndexColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("blockBinding"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.blockIndexColumn, "Uniform block binding point this block is associated with");
        this.nameColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("name"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.nameColumn, "Uniform name in the program");
        this.typeColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("type"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.typeColumn, "Type of the uniform");
        this.valueColumn.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("value"));
        this.locationColumn.setSortType(TreeTableColumn.SortType.ASCENDING);
        this.treeTableView.getSortOrder().add(this.programColumn);
        this.treeTableView.getSortOrder().add(this.indexColumn);
        this.treeTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.loadTableContextMenu();
        this.scene = new Scene(this.rootContainer);
        this.treeTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                ShaderUniform asset;
                UniformsViewItem tableItem = (UniformsViewItem)newValue.getValue();
                if (tableItem != null && (asset = tableItem.getShaderUniform()) != null) {
                    assert (!(asset.getPreviousModificationFunction() instanceof TraceDataModel.DummyFunctionCall));
                    this.isSelectedAssetCreatableAndModifiable.set(true);
                    this.isSelectedAssetCreatedByDummy.set(asset.getCreatedByFunction() instanceof TraceDataModel.DummyFunctionCall);
                }
            } else {
                this.isSelectedAssetCreatableAndModifiable.set(false);
            }
        });
        return this.scene;
    }

    @Override
    protected void setFxFocus() {
        this.treeTableView.requestFocus();
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        this.treeTableView.rootProperty().unbind();
        this.treeTableView.setRoot(null);
        this.scene = null;
        super.dispose();
    }

    private void loadTableContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem showCreatedByFunc = new MenuItem("Show Creating Function");
        showCreatedByFunc.setOnAction(event -> {
            @Nullable ShaderUniform asset = ((UniformsViewItem)((TreeItem)this.treeTableView.getSelectionModel().getSelectedItem()).getValue()).getShaderUniform();
            if (asset == null) {
                return;
            }
            CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)asset.getCreatedByFunction()), (Object)this);
        });
        showCreatedByFunc.disableProperty().bind((ObservableValue)this.isSelectedAssetCreatableAndModifiable.not().or((ObservableBooleanValue)this.isSelectedAssetCreatedByDummy));
        MenuItem showPreviousModifiedFunc = new MenuItem("Show Previous Affecting Function");
        showPreviousModifiedFunc.setOnAction(event -> {
            @Nullable ShaderUniform asset = ((UniformsViewItem)((TreeItem)this.treeTableView.getSelectionModel().getSelectedItem()).getValue()).getShaderUniform();
            if (asset == null) {
                return;
            }
            FunctionCall previousModificationFunction = asset.getPreviousModificationFunction();
            if (previousModificationFunction == null) {
                previousModificationFunction = asset.getCreatedByFunction();
            }
            CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)previousModificationFunction), (Object)this);
        });
        showPreviousModifiedFunc.disableProperty().bind((ObservableValue)this.isSelectedAssetCreatableAndModifiable.not());
        MenuItem copy = new MenuItem("Copy");
        copy.setOnAction(event -> this.copySelected());
        copy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copy.disableProperty().bind((ObservableValue)this.treeTableView.getSelectionModel().selectedItemProperty().isNull());
        contextMenu.getItems().addAll((Object[])new MenuItem[]{showCreatedByFunc, showPreviousModifiedFunc, copy});
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.treeTableView), contextMenu);
    }

    private void copySelected() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        StringJoiner rowBuilder = new StringJoiner("\n");
        ObservableList selectedItems = this.treeTableView.getSelectionModel().getSelectedItems();
        if (!selectedItems.isEmpty()) {
            StringJoiner stringBuilder = new StringJoiner("\t");
            stringBuilder.add("");
            stringBuilder.add("Block Binding");
            stringBuilder.add("Block Name");
            stringBuilder.add("Index");
            stringBuilder.add("Location");
            stringBuilder.add("Name");
            stringBuilder.add("Type");
            stringBuilder.add("Value");
            rowBuilder.add(stringBuilder.toString());
        }
        for (TreeItem tableItem : selectedItems) {
            UniformsViewItem item = (UniformsViewItem)tableItem.getValue();
            if (item == null) continue;
            StringJoiner stringBuilder = new StringJoiner("\t");
            stringBuilder.add(UniformsView.toStringNullable(item.getProgram()));
            stringBuilder.add(UniformsView.toStringNullable(item.getBlockBinding()));
            stringBuilder.add(UniformsView.toStringNullable(item.getBlockName()));
            stringBuilder.add(UniformsView.toStringNullable(item.getIndex()));
            stringBuilder.add(UniformsView.toStringNullable(item.getLocation()));
            stringBuilder.add(UniformsView.toStringNullable(item.getName()));
            stringBuilder.add(UniformsView.toStringNullable(item.getType()));
            stringBuilder.add(UniformsView.toStringNullable(item.getValue()).replace("\n", ""));
            rowBuilder.add(stringBuilder.toString());
        }
        content.putString(rowBuilder.toString());
        clipboard.setContent((Map)content);
    }

    private static @NonNull String toStringNullable(@Nullable Object nullable) {
        if (nullable != null) {
            return (String)NullUtils.neverNull((Object)nullable.toString());
        }
        return "";
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.uniformsview";
    }
}

