/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.target.data.ClEnqueueCall;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.InterestingFunctionCall;
import com.arm.mgd.core.target.data.ScreenshotAttachment;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.TraceOutlineItem;
import com.arm.mgd.ui.controllers.TraceOutlineViewController;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.utils.DynamicTreeItemWrapper;
import com.arm.mgd.ui.utils.FramebufferFeatureIcons;
import com.arm.mgd.ui.utils.RGBAImage;
import com.arm.mgd.ui.utils.WeakSelection;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.ui.views.widgets.GraphicsContextColouredTreeCell;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceOutlineView
extends FXViewPart {
    @FXML
    private BorderPane rootBorderPane;
    @FXML
    private Label traceOutlineNoDataLabel;
    @FXML
    private TreeView<TraceOutlineItem> tree;
    @FXML
    private Button collapseAll;
    @FXML
    private CheckBox filterOutline;
    private TraceOutlineViewController controller;
    private final @NonNull ExecutorService executor = NamedExecutors.cachedNumCoresThreadPool((long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("Filmstrip Executor", 1));
    private final ObjectProperty<WeakSelection<DynamicTreeItemWrapper>> weakSelection = new SimpleObjectProperty();
    private TreeSelectionListener treeSelectionListener;

    @Override
    public void dispose() {
        this.tree.rootProperty().unbind();
        this.tree.rootProperty().set(null);
        this.controller.dispose();
        this.controller = null;
        this.executor.shutdown();
        super.dispose();
    }

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/traceOutlineView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootBorderPane = (BorderPane)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.controller = new TraceOutlineViewController(this.visibleProperty());
        Scene scene = new Scene((Parent)this.rootBorderPane);
        this.tree.rootProperty().bind(this.controller.rootProperty());
        this.tree.setCellFactory((Callback)new Callback<TreeView<TraceOutlineItem>, TreeCell<TraceOutlineItem>>(){

            public TreeCell<TraceOutlineItem> call(TreeView<TraceOutlineItem> param) {
                return new OutlineTreeCell();
            }
        });
        this.treeSelectionListener = new TreeSelectionListener();
        this.weakSelection.bind(this.controller.weakSelectionProperty());
        this.weakSelection.addListener((ChangeListener)new ChangeListener<WeakSelection<DynamicTreeItemWrapper>>(){

            public void changed(ObservableValue<? extends WeakSelection<DynamicTreeItemWrapper>> observable, WeakSelection<DynamicTreeItemWrapper> oldValue, WeakSelection<DynamicTreeItemWrapper> newValue) {
                TraceOutlineView.this.tree.getSelectionModel().clearSelection();
                if (newValue == null) {
                    return;
                }
                @NonNull DynamicTreeItemWrapper referenceItem = newValue.getReferenceItem();
                if (newValue.getSelectionPosition() == WeakSelection.SelectionPosition.EXACT) {
                    TraceOutlineView.this.tree.getSelectionModel().getSelectedItems().removeListener((ListChangeListener)TraceOutlineView.this.treeSelectionListener);
                    TraceOutlineView.this.tree.getSelectionModel().select((Object)referenceItem);
                    TraceOutlineView.this.tree.getSelectionModel().getSelectedItems().addListener((ListChangeListener)TraceOutlineView.this.treeSelectionListener);
                    TraceOutlineView.this.tree.scrollTo(TraceOutlineView.this.tree.getSelectionModel().getSelectedIndex());
                } else {
                    TraceOutlineView.this.expandTreeView(referenceItem);
                    TraceOutlineView.this.tree.scrollTo(TraceOutlineView.this.tree.getRow((TreeItem)referenceItem));
                }
            }
        });
        this.tree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tree.getSelectionModel().getSelectedItems().addListener((ListChangeListener)this.treeSelectionListener);
        this.filterOutline.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue == null) {
                    return;
                }
                TraceOutlineView.this.tree.getSelectionModel().clearSelection();
                TraceOutlineView.this.controller.filterTreeProperty().set(newValue.booleanValue());
            }
        });
        this.collapseAll.disableProperty().bind((ObservableValue)this.controller.collapseAllDisabledProperty());
        this.collapseAll.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TraceOutlineView.this.controller.collapseAll();
            }
        });
        TraceOutlineView.createContextMenu((TraceOutlineViewController)NullUtils.neverNull((Object)this.controller), (TreeView<TraceOutlineItem>)((TreeView)NullUtils.neverNull(this.tree)));
        this.traceOutlineNoDataLabel.visibleProperty().bind((ObservableValue)this.controller.isTraceDataAvailable().not());
        return scene;
    }

    private void expandTreeView(@Nullable TreeItem<?> selectedItem) {
        if (selectedItem != null) {
            this.expandTreeView(selectedItem.getParent());
            if (!selectedItem.isLeaf()) {
                selectedItem.setExpanded(true);
            }
        }
    }

    @Override
    protected void setFxFocus() {
        this.rootBorderPane.requestFocus();
    }

    private static void createContextMenu(@NonNull TraceOutlineViewController controller, @NonNull TreeView<TraceOutlineItem> tree) {
        ContextMenu contextMenu = new ContextMenu();
        HashMap<@NonNull ICommand<INavigationElement<?>>, @NonNull MenuItem> allMenuItems = new HashMap();
        allMenuItems.put(Commands.GENERATE_DIFF_COMMAND, ContextMenuHelper.addItem(contextMenu, controller, Commands.GENERATE_DIFF_COMMAND));
        allMenuItems.put(Commands.EXPORT_FRAMEBUFFERS_COMMAND, ContextMenuHelper.addItem(contextMenu, controller, Commands.EXPORT_FRAMEBUFFERS_COMMAND));
        allMenuItems.put(Commands.EXPORT_SHADERS_FOR_FRAME_COMMAND, ContextMenuHelper.addItem(contextMenu, controller, Commands.EXPORT_SHADERS_FOR_FRAME_COMMAND));
        contextMenu.setOnShowing(event -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!controller.canDispatchCommand((ICommand<? super INavigationElement<?>>)command))));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(tree), contextMenu);
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.traceoutlineview";
    }

    private class OutlineTreeCell
    extends GraphicsContextColouredTreeCell {
        private final HBox hbox = new HBox();
        private final ImageView iconImageView = new ImageView();
        private final ImageView filmstripImageView = new ImageView();
        private final Text label = new Text();
        private final Text statisticsLabel = new Text();
        private final Tooltip tooltip = new Tooltip();
        private final ObjectProperty<WeakSelection.SelectionPosition> selectionPosition = new SimpleObjectProperty();

        public OutlineTreeCell() {
            ObservableList hboxChildren = this.hbox.getChildren();
            hboxChildren.add((Object)this.filmstripImageView);
            hboxChildren.add((Object)this.iconImageView);
            hboxChildren.add((Object)this.label);
            hboxChildren.add((Object)this.statisticsLabel);
            HBox.setMargin((Node)this.label, (Insets)new Insets(0.0, 0.0, 0.0, 2.0));
            HBox.setMargin((Node)this.statisticsLabel, (Insets)new Insets(0.0, 0.0, 0.0, 2.0));
            this.statisticsLabel.getStyleClass().add((Object)"statistics-text");
            this.selectionPosition.addListener((ChangeListener)new ChangeListener<WeakSelection.SelectionPosition>(){

                public void changed(ObservableValue<? extends WeakSelection.SelectionPosition> observable, WeakSelection.SelectionPosition oldValue, WeakSelection.SelectionPosition newValue) {
                    if (newValue == null) {
                        OutlineTreeCell.this.hbox.setStyle("");
                    } else if (newValue == WeakSelection.SelectionPosition.AFTER) {
                        OutlineTreeCell.this.hbox.setStyle("-fx-border-color: -fx-accent; -fx-border-width: 0 0 1 0;");
                    } else if (newValue == WeakSelection.SelectionPosition.BEFORE) {
                        OutlineTreeCell.this.hbox.setStyle("-fx-border-color: -fx-accent; -fx-border-width: 1 0 0 0;");
                    }
                }
            });
        }

        @Override
        protected void updateItem(TraceOutlineItem item, boolean empty) {
            Tooltip tooltipToSet;
            super.updateItem(item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.setTooltip(null);
                this.selectionPosition.unbind();
                this.selectionPosition.set(null);
                return;
            }
            String description = TraceOutlineView.this.controller.getDescriptionForItem(item.getItem());
            StringBuilder sb = new StringBuilder().append(item.getTooltipText());
            if (!description.isEmpty()) {
                if (sb.length() != 0) {
                    sb.append(System.lineSeparator());
                }
                sb.append(description);
            }
            this.tooltip.setText(sb.toString());
            Tooltip currentSetTooltip = this.getTooltip();
            Tooltip tooltip = tooltipToSet = sb.length() == 0 ? null : this.tooltip;
            if (currentSetTooltip != tooltipToSet) {
                this.setTooltip(tooltipToSet);
            }
            if (this.getGraphic() != this.hbox) {
                this.setGraphic((Node)this.hbox);
            }
            this.selectionPosition.bind(item.selectionPositionProperty());
            this.label.setText(item.getLongLabelText());
            this.statisticsLabel.setText(description);
            this.filmstripImageView.imageProperty().unbind();
            this.filmstripImageView.imageProperty().set(null);
            this.hbox.getStyleClass().clear();
            INavigationElement<?> interfaceItem = item.getItem();
            if (interfaceItem instanceof Frame) {
                Frame frame = (Frame)interfaceItem;
                FramebufferFeatureIcons featureIcon = FramebufferFeatureIcons.get(frame);
                this.iconImageView.setImage(featureIcon.image);
                ScreenshotAttachment imageDataProvider = frame.getScreenshot();
                if (imageDataProvider != null) {
                    TraceOutlineView.this.executor.execute(() -> this.lambda$0((IImageProvider)imageDataProvider));
                }
            } else if (interfaceItem instanceof FrameRenderPass) {
                FrameRenderPass renderPass = (FrameRenderPass)interfaceItem;
                FramebufferFeatureIcons featureIcon = FramebufferFeatureIcons.get(renderPass);
                this.iconImageView.setImage(featureIcon.image);
            } else if (interfaceItem instanceof DrawFunctionCall) {
                this.iconImageView.setImage(FXImages.DRAW_CALL);
            } else if (interfaceItem instanceof ClEnqueueCall) {
                this.iconImageView.setImage(FXImages.CL_ENQUEUE_FUNCTION_CALL);
            } else if (interfaceItem instanceof InterestingFunctionCall) {
                this.iconImageView.setImage(FXImages.INTERESTING_FUNCTION_CALL);
            } else {
                this.iconImageView.setImage(null);
            }
        }

        private /* synthetic */ void lambda$0(IImageProvider iImageProvider) {
            try {
                Image image = new RGBAImage(iImageProvider.getImageData()).getImage((RGBAImage.AlphaMode)((Object)NullUtils.neverNull((Object)((Object)RGBAImage.AlphaMode.IGNORE_ALPHA))));
                Platform.runLater(() -> this.filmstripImageView.imageProperty().set((Object)image));
            }
            catch (Throwable t) {
                CoreLogging.warning(null, (Throwable)t, (String)"Could not load frame screenshot");
            }
        }
    }

    private final class TreeSelectionListener
    implements ListChangeListener<TreeItem<TraceOutlineItem>> {
        private TreeSelectionListener() {
        }

        public void onChanged(ListChangeListener.Change<? extends TreeItem<TraceOutlineItem>> change) {
            while (change.next()) {
                List selectedItems = change.getAddedSubList();
                if (selectedItems.size() != 0) {
                    TraceOutlineView.this.controller.select((TreeItem<TraceOutlineItem>)((TreeItem)selectedItems.get(0)));
                }
                TraceOutlineView.this.controller.setSelectedItems((ObservableList<? extends TreeItem<TraceOutlineItem>>)change.getList());
            }
        }
    }
}

