/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.BookmarkModel;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.TimestampUtils;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.TraceEditorController;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controls.FXEditorPart;
import com.arm.mgd.ui.editorinput.TargetEditorInput;
import com.arm.mgd.ui.filterruler.FilterRuler;
import com.arm.mgd.ui.filterruler.MarkerSet;
import com.arm.mgd.ui.utils.ArgumentHierarchyTruncationPrinter;
import com.arm.mgd.ui.utils.FunctionStringConverter;
import com.arm.mgd.ui.utils.MonospaceTextTableCell;
import com.arm.mgd.ui.views.FindFunctionControl;
import com.arm.mgd.ui.views.ICloseOnStartupView;
import com.arm.mgd.ui.views.TraceEditorMarkerSets;
import com.arm.mgd.ui.views.widgets.CommitOnFocusLostTextFieldTableCell;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.ui.views.widgets.GraphicsContextColouredTableCell;
import com.arm.mgd.ui.views.widgets.TableHeaderTooltip;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.HashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class TraceEditor
extends FXEditorPart
implements ICloseOnStartupView {
    private static final @NonNull PseudoClass ROW_BACKGROUND_WITH_NOTE = (PseudoClass)NullUtils.neverNull((Object)PseudoClass.getPseudoClass((String)"traceEditor-notesBackground"));
    private static final @NonNull PseudoClass ROW_BACKGROUND_WITH_ANALYSIS = (PseudoClass)NullUtils.neverNull((Object)PseudoClass.getPseudoClass((String)"traceEditor-analysesBackground"));
    private static final @NonNull PseudoClass ROW_BACKGROUND_WITH_SEARCH_RESULT = (PseudoClass)NullUtils.neverNull((Object)PseudoClass.getPseudoClass((String)"traceEditor-searchBackground"));
    private static final @NonNull FunctionCallIcon DRAW_CALL_ICON = new FunctionCallIcon(FXImages.DRAW_CALL, "Draw Call");
    private static final @NonNull FunctionCallIcon CL_ENQUEUE_FUNCTION_CALL_ICON = new FunctionCallIcon(FXImages.CL_ENQUEUE_FUNCTION_CALL, "OpenCL Enqueue Call");
    private static final @NonNull FunctionCallIcon INTERESTING_FUNCTION_CALL_ICON = new FunctionCallIcon(FXImages.INTERESTING_FUNCTION_CALL, "Interesting Call");
    private static final @NonNull FunctionCallIcon FRAME_END_ICON = new FunctionCallIcon(FXImages.FRAME_END, "End of Frame");
    private static final @NonNull FunctionCallIcon MIDSTREAM_ATTACHMENT_ICON = new FunctionCallIcon(FXImages.MIDSTREAM_ATTACHMENT, "Call has target state information attached");
    private static final int TARGET_MAX_FUNCTION_CALL_CHARACTERS = 125;
    private BorderPane rootBorderPane;
    private TraceEditorController controller;
    private FilterRuler filterRuler;
    @FXML
    private TableView<FunctionCall> traceEditorTableView;
    @FXML
    private TableColumn<FunctionCall, FunctionCallIcon> iconBoxColumn;
    @FXML
    private TableColumn<FunctionCall, Number> functionNumberColumn;
    @FXML
    private TableColumn<FunctionCall, Number> timeStartedColumn;
    @FXML
    private TableColumn<FunctionCall, Number> timeEndedColumn;
    @FXML
    private TableColumn<FunctionCall, Number> cpuTimeColumn;
    @FXML
    private TableColumn<FunctionCall, Number> pidColumn;
    @FXML
    private TableColumn<FunctionCall, Number> tidColumn;
    @FXML
    private TableColumn<FunctionCall, String> errorColumn;
    @FXML
    private TableColumn<FunctionCall, String> returnColumn;
    @FXML
    private TableColumn<FunctionCall, ArgumentHierarchyBranch> functionCallColumn;
    @FXML
    private TableColumn<FunctionCall, String> notesColumn;
    private FindFunctionControl findControl;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        assert (input instanceof TargetEditorInput.ProxyTargetEditor);
        this.controller = new TraceEditorController(this.visibleProperty(), (TargetEditorInput)NullUtils.neverNull((Object)((TargetEditorInput.ProxyTargetEditor)input).getEditor()));
        this.controller.getEditorName().addListener((observable, oldValue, newValue) -> {
            String newName = newValue == null ? "Unknown" : newValue;
            this.setPartName(newName);
            this.firePropertyChange(257);
            this.firePropertyChange(1);
        });
        this.controller.getPreferredTraceSelection().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                TraceEditor.this.traceEditorTableView.getSelectionModel().clearSelection();
                TraceEditor.this.traceEditorTableView.getSelectionModel().select(newValue.intValue());
                TraceEditor.this.traceEditorTableView.scrollTo(newValue.intValue());
            }
        });
        this.controller.refreshUi().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                TraceEditor.this.firePropertyChange(257);
                TraceEditor.this.firePropertyChange(1);
            }
        });
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/traceEditorView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootBorderPane = (BorderPane)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.traceEditorTableView.setItems(this.controller.getFunctionCallList());
        this.controller.currentResolvedLocationProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                int toSelect = newValue.getIndex();
                if (!this.traceEditorTableView.getSelectionModel().getSelectedIndices().contains((Object)toSelect)) {
                    this.traceEditorTableView.getSelectionModel().clearSelection();
                    this.traceEditorTableView.getSelectionModel().select(toSelect);
                    this.traceEditorTableView.scrollTo(toSelect);
                    this.filterRuler.setSelectedMarkerValue(toSelect);
                }
            }
        });
        this.traceEditorTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.controller.bindSelectedFunctionCalls((ReadOnlyObjectProperty<FunctionCall>)((ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.traceEditorTableView.getSelectionModel().selectedItemProperty())), (ObservableList<FunctionCall>)((ObservableList)NullUtils.neverNull((Object)this.traceEditorTableView.getSelectionModel().getSelectedItems())));
        this.setCellFactories();
        this.filterRuler = new FilterRuler();
        this.filterRuler.setMinWidth(10.0);
        this.filterRuler.setPrefWidth(10.0);
        this.filterRuler.setMaxWidth(10.0);
        this.filterRuler.setMinHeight(0.0);
        this.filterRuler.setPrefHeight(0.0);
        this.filterRuler.setMinimumMarkerValue(0);
        this.filterRuler.setOnClickConsumer(index -> this.controller.navigateToNewFunctionNumber((int)index, this));
        this.traceEditorTableView.getItems().addListener(observable -> this.filterRuler.setMaximumMarkerValue(this.controller.getFunctionCallList().size() - 1));
        this.rootBorderPane.setRight((Node)this.filterRuler);
        BorderPane.setMargin((Node)this.filterRuler, (Insets)new Insets(0.0, 0.0, 0.0, 2.0));
        Bindings.bindContent(this.filterRuler.markerSetsProperty(), this.controller.getMarkerSets().markerSetsProperty());
        this.loadTableContextMenu();
        this.configureSearchControl();
        Scene scene = new Scene((Parent)this.rootBorderPane);
        scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (KeyCode.ESCAPE.equals((Object)event.getCode())) {
                    TraceEditor.this.findControl.setVisible(false);
                }
            }
        });
        return scene;
    }

    private void configureSearchControl() {
        this.findControl = new FindFunctionControl(this.controller.getTarget(), this.controller.getMarkerSets().getSearchMarkerSet());
        this.rootBorderPane.setBottom((Node)this.findControl);
        this.findControl.setVisible(false);
    }

    private void setCellFactories() {
        this.functionNumberColumn.setCellValueFactory(p -> new SimpleIntegerProperty(((FunctionCall)p.getValue()).getIndex()));
        this.functionNumberColumn.setCellFactory(p -> new GraphicsContextColouredTableCell());
        this.returnColumn.setCellValueFactory(p -> {
            if (((FunctionCall)p.getValue()).getReturnValue() != null) {
                return new SimpleStringProperty(((FunctionCall)p.getValue()).getReturnValue().toString());
            }
            return null;
        });
        this.returnColumn.setCellFactory(column -> new MonospaceTextTableCell<FunctionCall, String>(){
            private final @NonNull SimpleObjectProperty<@Nullable PseudoClass> currentColour = new SimpleObjectProperty();

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                GraphicsContextColouredTableCell.updateTableCellColour(this, this.currentColour);
            }
        });
        this.functionCallColumn.setCellValueFactory(p -> new SimpleObjectProperty((Object)((FunctionCall)p.getValue()).getArgumentHierarchy()));
        this.functionCallColumn.setCellFactory(column -> new MonospaceTextTableCell<FunctionCall, ArgumentHierarchyBranch>(){
            private final @NonNull SimpleObjectProperty<@Nullable PseudoClass> currentColour = new SimpleObjectProperty();

            @Override
            public void updateItem(ArgumentHierarchyBranch item, boolean empty) {
                super.updateItem(item, empty);
                GraphicsContextColouredTableCell.updateTableCellColour(this, this.currentColour);
            }

            @Override
            protected String getTextFromItem(@NonNull ArgumentHierarchyBranch item) {
                return ArgumentHierarchyTruncationPrinter.printTruncatedArgumentHierarchy((ArgumentHierarchyNode)item, 125);
            }
        });
        this.timeStartedColumn.setCellValueFactory(p -> new SimpleLongProperty(((FunctionCall)p.getValue()).getTimestampStart()));
        this.timeStartedColumn.setCellFactory(GraphicsContextColouredTableCell.forTableColumn(new FunctionStringConverter<Number>(time -> time == null ? null : TimestampUtils.prettyDecimalTimeString((long)time.longValue()))));
        this.timeEndedColumn.setCellValueFactory(p -> new SimpleLongProperty(((FunctionCall)p.getValue()).getTimestampStop()));
        this.timeEndedColumn.setCellFactory(GraphicsContextColouredTableCell.forTableColumn(new FunctionStringConverter<Number>(time -> time == null ? null : TimestampUtils.prettyDecimalTimeString((long)time.longValue()))));
        this.cpuTimeColumn.setCellValueFactory(p -> new SimpleLongProperty(((FunctionCall)p.getValue()).getWaitTime()));
        this.cpuTimeColumn.setCellFactory(p -> new GraphicsContextColouredTableCell());
        this.pidColumn.setCellValueFactory(p -> new SimpleIntegerProperty(((FunctionCall)p.getValue()).getPid()));
        this.pidColumn.setCellFactory(p -> new GraphicsContextColouredTableCell());
        this.tidColumn.setCellValueFactory(p -> new SimpleLongProperty(((FunctionCall)p.getValue()).getTid()));
        this.tidColumn.setCellFactory(p -> new GraphicsContextColouredTableCell());
        this.errorColumn.setCellValueFactory(p -> new SimpleStringProperty(((FunctionCall)p.getValue()).getErrorCodeAsString()));
        this.errorColumn.setCellFactory(column -> new MonospaceTextTableCell<FunctionCall, String>(){
            private final @NonNull SimpleObjectProperty<@Nullable PseudoClass> currentColour = new SimpleObjectProperty();

            @Override
            public void updateItem(String item, boolean empty) {
                super.updateItem(item, empty);
                GraphicsContextColouredTableCell.updateTableCellColour(this, this.currentColour);
            }
        });
        this.notesColumn.setCellValueFactory(this.controller.getNotesCellFactory());
        this.notesColumn.setCellFactory(p -> new CommitOnFocusColouredTableCell());
        this.notesColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<FunctionCall, String>>(){

            public void handle(// Could not load outer class - annotation placement on inner may be incorrect
            TableColumn.CellEditEvent<FunctionCall, @NonNull String> event) {
                FunctionCall fc = (FunctionCall)event.getRowValue();
                String newValue = (String)event.getNewValue();
                BookmarkModel.Bookmark oldBookmark = fc.getModel().getBookmarkModel().getBookmark(fc);
                if (oldBookmark != null || !newValue.isEmpty()) {
                    fc.getModel().getBookmarkModel().addBookmark(fc, newValue);
                }
            }
        });
        this.iconBoxColumn.setCellValueFactory(p -> {
            if (((FunctionCall)p.getValue()).hasError()) {
                return new SimpleObjectProperty((Object)new FunctionCallIcon(FXImages.WARNING, "Error: " + ((FunctionCall)p.getValue()).getErrorCodeAsString()));
            }
            if (((FunctionCall)p.getValue()).getFunctionSpec().isDrawCall()) {
                return new SimpleObjectProperty((Object)DRAW_CALL_ICON);
            }
            if (((FunctionCall)p.getValue()).getFunctionSpec().isClEnqueueCall()) {
                return new SimpleObjectProperty((Object)CL_ENQUEUE_FUNCTION_CALL_ICON);
            }
            if (((FunctionCall)p.getValue()).getFunctionSpec().isInterestingCall()) {
                return new SimpleObjectProperty((Object)INTERESTING_FUNCTION_CALL_ICON);
            }
            if (((FunctionCall)p.getValue()).isFrameEnd()) {
                return new SimpleObjectProperty((Object)FRAME_END_ICON);
            }
            if (((FunctionCall)p.getValue()).hasMidstreamTraceData()) {
                return new SimpleObjectProperty((Object)MIDSTREAM_ATTACHMENT_ICON);
            }
            return null;
        });
        this.iconBoxColumn.setCellFactory(p -> new GraphicsContextColouredTableCell<FunctionCallIcon>(){
            private final ImageView imageView = new ImageView();
            private final Tooltip tooltip = new Tooltip();

            @Override
            public void updateItem(FunctionCallIcon functionCallIcon, boolean empty) {
                if (empty || functionCallIcon == null) {
                    this.setGraphic(null);
                    this.setTooltip(null);
                    return;
                }
                this.imageView.setImage(functionCallIcon.icon);
                this.tooltip.setText(functionCallIcon.description);
                this.setGraphic((Node)this.imageView);
                this.setTooltip(this.tooltip);
            }
        });
        this.traceEditorTableView.setRowFactory((Callback)new Callback<TableView<FunctionCall>, TableRow<FunctionCall>>(){

            public TableRow<FunctionCall> call(TableView<FunctionCall> param) {
                return new TraceEditorTableRow((TraceEditorController)NullUtils.neverNull((Object)TraceEditor.this.controller));
            }
        });
        TableHeaderTooltip.makeHeaderWithTooltip(this.functionNumberColumn, "Function index in the trace");
        TableHeaderTooltip.makeHeaderWithTooltip(this.returnColumn, "Return value of the function call");
        TableHeaderTooltip.makeHeaderWithTooltip(this.functionCallColumn, "Details of the function call such as name and parameters passed");
        TableHeaderTooltip.makeHeaderWithTooltip(this.pidColumn, "ID of the process the function call was called from");
        TableHeaderTooltip.makeHeaderWithTooltip(this.tidColumn, "ID of the thread the function call was called from");
        TableHeaderTooltip.makeHeaderWithTooltip(this.errorColumn, "Errors returned by the function call");
        TableHeaderTooltip.makeHeaderWithTooltip(this.notesColumn, "User defined notes associated with the function call");
        TableHeaderTooltip.makeHeaderWithTooltip(this.iconBoxColumn, "Shows whether a function call is notable. Hover over the icon for more information.");
    }

    private void loadTableContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        HashMap<@NonNull ICommand<Object>, @NonNull MenuItem> allMenuItems = new HashMap<ICommand<Object>, MenuItem>();
        TraceEditorController localController = this.controller;
        if (localController != null) {
            allMenuItems.put(Commands.OPEN_DOCUMENTATION_COMMAND, ContextMenuHelper.addItem(contextMenu, localController, Commands.OPEN_DOCUMENTATION_COMMAND));
            allMenuItems.put(Commands.GENERATE_DIFF_COMMAND, ContextMenuHelper.addItem(contextMenu, localController, Commands.GENERATE_DIFF_COMMAND));
            allMenuItems.put(this.controller.getCopyCommand(), ContextMenuHelper.addItem(contextMenu, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), localController, this.controller.getCopyCommand()));
            contextMenu.getItems().add((Object)new SeparatorMenuItem());
            allMenuItems.put(Commands.EXPORT_FRAMEBUFFERS_COMMAND, ContextMenuHelper.addItem(contextMenu, localController, Commands.EXPORT_FRAMEBUFFERS_COMMAND));
            allMenuItems.put(Commands.EXPORT_TEXTURE_FROM_SELECTED_FUNCTION_CALL_COMMAND, ContextMenuHelper.addItem(contextMenu, localController, Commands.EXPORT_TEXTURE_FROM_SELECTED_FUNCTION_CALL_COMMAND));
            allMenuItems.put(Commands.EXPORT_IMAGES_FROM_SELECTED_FUNCTION_CALL_COMMAND, ContextMenuHelper.addItem(contextMenu, localController, Commands.EXPORT_IMAGES_FROM_SELECTED_FUNCTION_CALL_COMMAND));
            allMenuItems.put(Commands.EXPORT_FUNCTION_CALL_SHADERS_COMMAND, ContextMenuHelper.addItem(contextMenu, localController, Commands.EXPORT_FUNCTION_CALL_SHADERS_COMMAND));
            contextMenu.getItems().add((Object)new SeparatorMenuItem());
            ContextMenuHelper.addItem(contextMenu, "Toggle Bookmark Highlighting", null, (EventHandler<ActionEvent>)((EventHandler)e -> this.controller.toggleNotes()));
            ContextMenuHelper.addItem(contextMenu, "Add Empty Bookmark(s)", null, (EventHandler<ActionEvent>)((EventHandler)e -> this.controller.addEmptyBookmarks()));
            ContextMenuHelper.addItem(contextMenu, "Remove Bookmark(s)", null, (EventHandler<ActionEvent>)((EventHandler)e -> this.controller.removeBookmarks()));
        }
        contextMenu.setOnShowing(event -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!this.controller.canDispatchCommand((ICommand<? super FunctionCall>)command))));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.traceEditorTableView), contextMenu);
    }

    @Override
    protected void setFxFocus() {
        this.traceEditorTableView.requestFocus();
    }

    public @NonNull AbstractTarget getTarget() {
        return this.controller.getTarget();
    }

    public @NonNull TraceEditorMarkerSets getMarkerSets() {
        return this.controller.getMarkerSets();
    }

    public void doSave(IProgressMonitor monitor) {
        if (monitor != null) {
            this.controller.doSave(monitor);
        }
    }

    public void doSaveAs() {
        this.controller.doSaveAs();
    }

    public boolean isDirty() {
        return this.controller.getTraceEditorInput().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return this.controller.isSaveAsAllowed();
    }

    public void showSearchControl() {
        this.findControl.setVisible(true);
        this.findControl.requestFocus();
    }

    public static String getID() {
        return "com.arm.mgd.ui.views.TraceEditor";
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        this.traceEditorTableView.setItems(null);
        this.findControl.dispose();
        this.findControl = null;
        super.dispose();
    }

    @Override
    protected String getHelpId() {
        return "com.arm.mgd.help.traceeditor";
    }

    private class CommitOnFocusColouredTableCell
    extends GraphicsContextColouredTableCell<String> {
        private TextField textField;

        private CommitOnFocusColouredTableCell() {
        }

        public void commitEdit(String item) {
            if (this.isEditing()) {
                super.commitEdit((Object)item);
            } else {
                CommitOnFocusLostTextFieldTableCell.commitEdit(this, this.textField, item);
            }
        }

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.textField = CommitOnFocusLostTextFieldTableCell.startEdit(this);
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            CommitOnFocusLostTextFieldTableCell.cancelEdit(this);
        }

        @Override
        public void updateItem(String item, boolean empty) {
            super.updateItem(item, empty);
            CommitOnFocusLostTextFieldTableCell.updateItem(this, empty, this.textField);
        }
    }

    private static class FunctionCallIcon {
        public final @NonNull Image icon;
        public final @NonNull String description;

        private FunctionCallIcon(@NonNull Image icon, @NonNull String description) {
            this.icon = icon;
            this.description = description;
        }
    }

    private final class TraceEditorTableRow
    extends TableRow<FunctionCall> {
        private static final int CUSTOM_ROW_HEIGHT = 22;
        private final @NonNull MarkerSetRowStyleDecorator notesRowDecorator;
        private final @NonNull MarkerSetRowStyleDecorator analysesRowDecorator;
        private final @NonNull MarkerSetRowStyleDecorator searchRowDecorator;

        public TraceEditorTableRow(TraceEditorController controller) {
            this.setMinHeight(22.0);
            this.setPrefHeight(22.0);
            this.setMaxHeight(22.0);
            TraceEditorMarkerSets markerSets = controller.getMarkerSets();
            this.notesRowDecorator = new MarkerSetRowStyleDecorator(ROW_BACKGROUND_WITH_NOTE, markerSets.getNotesMarkerSet());
            this.analysesRowDecorator = new MarkerSetRowStyleDecorator(ROW_BACKGROUND_WITH_ANALYSIS, markerSets.getAnalysisMarkerSet());
            this.searchRowDecorator = new MarkerSetRowStyleDecorator(ROW_BACKGROUND_WITH_SEARCH_RESULT, markerSets.getSearchMarkerSet());
        }

        protected void updateItem(FunctionCall fc, boolean empty) {
            super.updateItem((Object)fc, empty);
            if (fc != null) {
                Integer fcIndex = NullUtils.intValueOf((int)fc.getIndex());
                this.notesRowDecorator.apply(fcIndex);
                this.analysesRowDecorator.apply(fcIndex);
                this.searchRowDecorator.apply(fcIndex);
            }
        }

        private final class MarkerSetRowStyleDecorator
        implements InvalidationListener {
            private final @NonNull PseudoClass styleClass;
            private final @NonNull MarkerSet markerSet;

            public MarkerSetRowStyleDecorator(@NonNull PseudoClass styleClass, MarkerSet markerSet) {
                this.styleClass = styleClass;
                this.markerSet = markerSet;
                markerSet.addListener((InvalidationListener)new WeakInvalidationListener((InvalidationListener)this));
                markerSet.visibleProperty().addListener((InvalidationListener)new WeakInvalidationListener((InvalidationListener)this));
            }

            public void invalidated(Observable observable) {
                FunctionCall fc = (FunctionCall)TraceEditorTableRow.this.getItem();
                if (fc != null) {
                    this.apply(NullUtils.intValueOf((int)fc.getIndex()));
                } else {
                    TraceEditorTableRow.this.pseudoClassStateChanged(this.styleClass, false);
                }
                TraceEditor.this.firePropertyChange(257);
                TraceEditor.this.firePropertyChange(1);
            }

            public void apply(@NonNull Integer index) {
                boolean active = this.markerSet.getActivePositions().contains(index) && this.markerSet.isVisible();
                TraceEditorTableRow.this.pseudoClassStateChanged(this.styleClass, active);
            }
        }
    }
}

