/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.traceanalyses.TraceAnalysis;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.TraceAnalysisItem;
import com.arm.mgd.ui.controllers.TraceAnalysisViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.Nullable;

public class TraceAnalysisView
extends FXViewPart {
    private final TraceAnalysisViewController controller = new TraceAnalysisViewController(this.visibleProperty());
    @FXML
    private TableView<TraceAnalysisItem> table;
    @FXML
    private TableColumn<TraceAnalysisItem, TraceAnalysis.AnalysisType> iconColumn;
    @FXML
    private TableColumn<TraceAnalysisItem, String> messageColumn;
    @FXML
    private TableColumn<TraceAnalysisItem, Number> countColumn;
    @FXML
    private ContextMenu contextMenu;
    @FXML
    private MenuItem copyMenuItem;

    @Override
    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/traceAnalysisView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.table = (TableView)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        Scene scene = new Scene(this.table);
        this.table.setItems(this.controller.getTraceAnalyses());
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.getSelectionModel().getSelectedItems().addListener((ListChangeListener)this.controller.getSelectionChangeListener());
        this.table.setRowFactory((Callback)new Callback<TableView<TraceAnalysisItem>, TableRow<TraceAnalysisItem>>(){

            public TableRow<TraceAnalysisItem> call(TableView<TraceAnalysisItem> param) {
                return new TableRow<TraceAnalysisItem>(){

                    protected void updateItem(TraceAnalysisItem traceProblem, boolean empty) {
                        super.updateItem((Object)traceProblem, empty);
                        this.setTooltip(null);
                        if (empty || traceProblem == null) {
                            return;
                        }
                        String tooltipMessage = traceProblem.getDescription();
                        if (tooltipMessage != null && !tooltipMessage.isEmpty()) {
                            this.setTooltip(new Tooltip(traceProblem.getDescription()));
                        }
                    }
                };
            }
        });
        this.messageColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TraceAnalysisItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TraceAnalysisItem, String> param) {
                return ((TraceAnalysisItem)param.getValue()).messageProperty();
            }
        });
        this.countColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TraceAnalysisItem, Number>, ObservableValue<Number>>(){

            public ObservableValue<Number> call(TableColumn.CellDataFeatures<TraceAnalysisItem, Number> param) {
                return ((TraceAnalysisItem)param.getValue()).countProperty();
            }
        });
        this.countColumn.setCellFactory((Callback)new Callback<TableColumn<TraceAnalysisItem, Number>, TableCell<TraceAnalysisItem, Number>>(){

            public TableCell<TraceAnalysisItem, Number> call(TableColumn<TraceAnalysisItem, Number> param) {
                return new TableCell<TraceAnalysisItem, Number>(){

                    protected void updateItem(Number item, boolean empty) {
                        if (item == this.getItem()) {
                            return;
                        }
                        super.updateItem((Object)item, empty);
                        if (item == null || item.longValue() == 0L) {
                            super.setText(null);
                            super.setGraphic(null);
                        } else {
                            super.setText(item.toString());
                            super.setGraphic(null);
                        }
                    }
                };
            }
        });
        this.iconColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TraceAnalysisItem, TraceAnalysis.AnalysisType>, ObservableValue<TraceAnalysis.AnalysisType>>(){

            public ObservableValue<TraceAnalysis.AnalysisType> call(TableColumn.CellDataFeatures<TraceAnalysisItem, TraceAnalysis.AnalysisType> param) {
                return new SimpleObjectProperty((Object)((TraceAnalysisItem)param.getValue()).getType());
            }
        });
        this.iconColumn.setCellFactory((Callback)new Callback<TableColumn<TraceAnalysisItem, TraceAnalysis.AnalysisType>, TableCell<TraceAnalysisItem, TraceAnalysis.AnalysisType>>(){

            public TableCell<TraceAnalysisItem, TraceAnalysis.AnalysisType> call(TableColumn<TraceAnalysisItem, TraceAnalysis.AnalysisType> param) {
                return new TableCell<TraceAnalysisItem, TraceAnalysis.AnalysisType>(){

                    public void updateItem(TraceAnalysis.AnalysisType analysisType, boolean empty) {
                        super.updateItem((Object)analysisType, empty);
                        if (empty || analysisType == null) {
                            this.setGraphic(null);
                            return;
                        }
                        switch (analysisType) {
                            case ERROR: {
                                this.setGraphic((Node)new ImageView(FXImages.ERROR));
                                break;
                            }
                            case INFO: {
                                this.setGraphic((Node)new ImageView(FXImages.INFORMATION));
                                break;
                            }
                            case WARNING: {
                                this.setGraphic((Node)new ImageView(FXImages.WARNING));
                                break;
                            }
                        }
                    }
                };
            }
        });
        this.copyMenuItem.setOnAction(this.controller.getCopyHandler());
        this.copyMenuItem.disableProperty().bind((ObservableValue)this.controller.copyEnabledProperty().not());
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.table), (ContextMenu)NullUtils.neverNull((Object)this.contextMenu));
        return scene;
    }

    @Override
    protected void setFxFocus() {
        this.table.requestFocus();
    }

    @Override
    public @Nullable String getHelpId() {
        return "com.arm.mgd.help.traceanalysisview";
    }
}

