/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.ui.controllers.AbstractTableViewThumbnailController;
import com.arm.mgd.ui.controllers.TexturesViewItem;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.utils.RGBAImage;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.ui.views.widgets.ImageTableCellFactory;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TexturesView
extends FXViewPart {
    private final @NonNull AbstractTableViewThumbnailController<TexturesViewItem> controller;
    @FXML
    private VBox rootContainer;
    @FXML
    private TableView<TexturesViewItem> tableView;
    @FXML
    private TableColumn<TexturesViewItem, IImageProvider> imageColumn;
    @FXML
    private TableColumn<TexturesViewItem, Number> textureIdColumn;
    @FXML
    private TableColumn<TexturesViewItem, String> textureTargetColumn;
    @FXML
    private TableColumn<TexturesViewItem, Dimension> sizeColumn;
    @FXML
    private TableColumn<TexturesViewItem, String> internalFormatColumn;
    @FXML
    private TableColumn<TexturesViewItem, String> formatTypePairsColumn;
    @FXML
    private TableColumn<TexturesViewItem, String> noteColumn;
    @FXML
    private ComboBox<RGBAImage.AlphaMode> alphaMode;
    private final @NonNull ExecutorService executor = NamedExecutors.cachedNumCoresThreadPool((long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("TexturesView Executor", 1));

    public TexturesView() {
        this.controller = new AbstractTableViewThumbnailController<TexturesViewItem>(this.visibleProperty(), KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC){

            @Override
            public @NonNull TexturesViewItem createTableViewItem() {
                return new TexturesViewItem();
            }

            @Override
            public String getClipboardHeader() {
                return "Texture, Size, Internal Format, Upload Formats/Types, Note";
            }

            @Override
            public void setTableViewItem(@NonNull TexturesViewItem item, @NonNull IAssetItem assetItem) {
                item.set((GlTextureAsset)assetItem);
            }
        };
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        this.tableView.setItems(null);
        this.executor.shutdown();
        super.dispose();
    }

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/texturesView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (VBox)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.tableView.setItems(this.controller.getItemList());
        this.imageColumn.setCellValueFactory(item -> ((TexturesViewItem)item.getValue()).imageProviderProperty());
        this.imageColumn.setCellFactory(new ImageTableCellFactory((ReadOnlyObjectProperty<RGBAImage.AlphaMode>)((ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.alphaMode.valueProperty())), this.executor));
        this.textureIdColumn.setCellValueFactory(item -> ((TexturesViewItem)item.getValue()).textureIdProperty());
        this.textureTargetColumn.setCellValueFactory(item -> ((TexturesViewItem)item.getValue()).textureTargetProperty());
        this.sizeColumn.setCellValueFactory(item -> ((TexturesViewItem)item.getValue()).sizeProperty());
        this.internalFormatColumn.setCellValueFactory(item -> ((TexturesViewItem)item.getValue()).internalFormatProperty());
        this.formatTypePairsColumn.setCellValueFactory(item -> ((TexturesViewItem)item.getValue()).formatTypePairsProperty());
        this.noteColumn.setCellValueFactory(item -> ((TexturesViewItem)item.getValue()).noteProperty());
        this.tableView.setTableMenuButtonVisible(true);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ContextMenu contextMenu = new ContextMenu();
        this.loadTableContextMenu(contextMenu);
        this.tableView.setRowFactory(tv -> {
            TableRow rowItem = new TableRow();
            rowItem.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !rowItem.isEmpty()) {
                    TexturesViewItem textureViewItem = (TexturesViewItem)rowItem.getItem();
                    textureViewItem.open();
                }
            });
            return rowItem;
        });
        this.alphaMode.getItems().setAll((Object[])RGBAImage.AlphaMode.values());
        this.alphaMode.getSelectionModel().select(0);
        this.controller.bindSelectedIndices((ObservableList<Integer>)this.tableView.getSelectionModel().getSelectedIndices());
        this.controller.bindComparatorProperty((ObservableValue<Comparator<TexturesViewItem>>)this.tableView.comparatorProperty());
        this.tableView.getSortOrder().add(this.textureIdColumn);
        return new Scene((Parent)this.rootContainer);
    }

    @Override
    protected void setFxFocus() {
        this.tableView.requestFocus();
    }

    @Override
    public @Nullable String getHelpId() {
        return "com.arm.mgd.help.texturesview";
    }

    private void loadTableContextMenu(@NonNull ContextMenu contextMenu) {
        HashMap<@NonNull ICommand<T>, @NonNull MenuItem> allMenuItems = new HashMap();
        allMenuItems.put(Commands.OPEN_ASSET_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.OPEN_ASSET_COMMAND));
        allMenuItems.put(Commands.EXPORT_SELECTED_TEXTURES_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.EXPORT_SELECTED_TEXTURES_COMMAND));
        allMenuItems.put(Commands.ADD_TEXTURE_OVERRIDE_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.ADD_TEXTURE_OVERRIDE_COMMAND));
        allMenuItems.put(Commands.REMOVE_TEXTURE_OVERRIDE_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.REMOVE_TEXTURE_OVERRIDE_COMMAND));
        allMenuItems.put(Commands.SHOW_CREATED_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.SHOW_CREATED_LOCATION_COMMAND));
        allMenuItems.put(Commands.SHOW_LAST_MODIFIED_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.SHOW_LAST_MODIFIED_LOCATION_COMMAND));
        allMenuItems.put(this.controller.getCopyCommand(), ContextMenuHelper.addItem(contextMenu, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (ICommandDispatcher)NullUtils.neverNull(this.controller), this.controller.getCopyCommand()));
        contextMenu.showingProperty().addListener(listener -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!this.controller.canDispatchCommand((ICommand<TexturesViewItem>)command))));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.tableView), contextMenu);
    }
}

