/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.TargetStateViewController;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TargetStateView
extends FXViewPart {
    private static final String PLACEHOLDER_NO_FUNCTION = "No function call is selected";
    private static final String PLACEHOLDER_NO_STATE = "The current function call does not have any associated state";
    @FXML
    private StackPane root;
    @FXML
    private TableView<TargetStateViewController.TargetStateViewItem> mainTable;
    @FXML
    private TableColumn<TargetStateViewController.TargetStateViewItem, String> targetStateColumn;
    @FXML
    private TableColumn<TargetStateViewController.TargetStateViewItem, String> valueColumn;
    @FXML
    private TextField filterText;
    @FXML
    private ChoiceBox<TargetStateViewController.StateFilterMode> filterChanged;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private VBox mainContentVBox;
    private Scene scene;
    private TargetStateViewController controller;
    private EventHandler<WindowEvent> contextMenuEventHandler;
    private Label placeholderLabel;
    private static final PseudoClass READ_ONLY_STATE_ITEM_CLASS = PseudoClass.getPseudoClass((String)"read-only-state-item");
    private static final PseudoClass NOT_DEFAULT_VALUE_CLASS = PseudoClass.getPseudoClass((String)"changed-from-default");
    private static final PseudoClass HAS_AFFECTING_FUNCTIONS_CLASS = PseudoClass.getPseudoClass((String)"has-affecting-functions");

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/targetStateView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.root = (StackPane)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.scene = new Scene((Parent)this.root);
        this.placeholderLabel = new Label();
        this.controller = new TargetStateViewController(this.visibleProperty());
        this.targetStateColumn.setSortType(TableColumn.SortType.ASCENDING);
        this.mainTable.getSortOrder().add(this.targetStateColumn);
        this.controller.addComparator((ReadOnlyObjectProperty<Comparator<TargetStateViewController.TargetStateViewItem>>)this.mainTable.comparatorProperty());
        this.controller.bindFilterText(this.filterText.textProperty());
        this.controller.bindFilterOnlySelected((ReadOnlyObjectProperty<TargetStateViewController.StateFilterMode>)this.filterChanged.getSelectionModel().selectedItemProperty());
        this.controller.bindSelectedIndices((ObservableList<Integer>)this.mainTable.getSelectionModel().getSelectedIndices());
        this.mainTable.setItems(this.controller.getData());
        this.filterChanged.getItems().setAll((Object[])TargetStateViewController.StateFilterMode.values());
        this.filterChanged.getSelectionModel().selectFirst();
        this.filterChanged.setConverter((StringConverter)new StringConverter<TargetStateViewController.StateFilterMode>(){

            public String toString(TargetStateViewController.StateFilterMode object) {
                switch (object) {
                    case SHOW_ALL: {
                        return "All states";
                    }
                    case CHANGED: {
                        return "States that have been modified";
                    }
                    case NOT_CHANGED: {
                        return "States that have not been modified";
                    }
                    case CURRENTLY_NOT_DEFAULT: {
                        return "States that are not currently their defaults";
                    }
                    case CHANGED_IN_THIS_FUNCTION: {
                        return "States changed by this function";
                    }
                    case READ_ONLY: {
                        return "Read-only states";
                    }
                }
                return null;
            }

            public TargetStateViewController.StateFilterMode fromString(String string) {
                return null;
            }
        });
        Tooltip filterTextTooltip = new Tooltip();
        filterTextTooltip.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.controller.filterPatternErrorProperty().isEmpty()).then(this.filterText.getPromptText()).otherwise((ObservableStringValue)this.controller.filterPatternErrorProperty()));
        this.filterText.setTooltip(filterTextTooltip);
        final PseudoClass invalidClass = PseudoClass.getPseudoClass((String)"invalid");
        this.controller.isFilterPatternValidProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                TargetStateView.this.filterText.pseudoClassStateChanged(invalidClass, newValue == false);
            }
        });
        this.targetStateColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TargetStateViewController.TargetStateViewItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TargetStateViewController.TargetStateViewItem, String> p) {
                return new ReadOnlyObjectWrapper((Object)((TargetStateViewController.TargetStateViewItem)p.getValue()).getStateName());
            }
        });
        this.valueColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<TargetStateViewController.TargetStateViewItem, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<TargetStateViewController.TargetStateViewItem, String> p) {
                return new ReadOnlyObjectWrapper((Object)((TargetStateViewController.TargetStateViewItem)p.getValue()).getValueString());
            }
        });
        this.valueColumn.setCellFactory((Callback)new Callback<TableColumn<TargetStateViewController.TargetStateViewItem, String>, TableCell<TargetStateViewController.TargetStateViewItem, String>>(){

            public TableCell<TargetStateViewController.TargetStateViewItem, String> call(TableColumn<TargetStateViewController.TargetStateViewItem, String> param) {
                return new TableCell<TargetStateViewController.TargetStateViewItem, String>(){

                    protected void updateItem(String string, boolean empty) {
                        super.updateItem((Object)string, empty);
                        @Nullable TableRow row = this.getTableRow();
                        TargetStateViewController.TargetStateViewItem item = row != null ? (TargetStateViewController.TargetStateViewItem)row.getItem() : null;
                        this.pseudoClassStateChanged(READ_ONLY_STATE_ITEM_CLASS, false);
                        this.pseudoClassStateChanged(NOT_DEFAULT_VALUE_CLASS, false);
                        this.pseudoClassStateChanged(HAS_AFFECTING_FUNCTIONS_CLASS, false);
                        if (item == null || empty) {
                            this.setText(null);
                            this.setTooltip(null);
                        } else {
                            this.setText(item.getValueString());
                            this.setTooltip(null);
                            if (item.isReadOnlyStateItem()) {
                                this.pseudoClassStateChanged(READ_ONLY_STATE_ITEM_CLASS, true);
                                this.setTooltip(new Tooltip("This state item is a driver provided constant value."));
                            } else if (item.isChanged()) {
                                this.pseudoClassStateChanged(NOT_DEFAULT_VALUE_CLASS, true);
                                this.setTooltip(new Tooltip("The current value of this state item is not its default."));
                            } else if (item.isEverChanged()) {
                                this.pseudoClassStateChanged(HAS_AFFECTING_FUNCTIONS_CLASS, true);
                                this.setTooltip(new Tooltip("This state item has been affected by some call in the trace, but is currently its default value."));
                            }
                        }
                    }
                };
            }
        });
        this.loadTableContextMenu();
        this.progressBar.progressProperty().bind((ObservableValue)this.controller.progressProperty());
        this.progressBar.visibleProperty().bind((ObservableValue)this.controller.isNotCurrentProperty());
        this.progressBar.managedProperty().bind((ObservableValue)this.progressBar.visibleProperty());
        this.mainTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.root.cursorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.controller.isNotCurrentProperty().get() ? Cursor.WAIT : Cursor.DEFAULT, (Observable[])new Observable[]{this.controller.isNotCurrentProperty()}));
        this.mainContentVBox.disableProperty().bind((ObservableValue)this.controller.isNotCurrentProperty());
        this.mainTable.setPlaceholder((Node)this.placeholderLabel);
        this.controller.noFunctionCallSelectedProperty().addListener((property, oldValue, newValue) -> {
            if (newValue != null && newValue.booleanValue()) {
                this.placeholderLabel.setText(PLACEHOLDER_NO_FUNCTION);
            } else {
                this.placeholderLabel.setText(PLACEHOLDER_NO_STATE);
            }
        });
        return this.scene;
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        this.controller = null;
        this.contextMenuEventHandler = null;
        super.dispose();
    }

    private void loadTableContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        HashMap<@NonNull ICommand<TargetStateViewController.TargetStateViewItem>, @NonNull MenuItem> allMenuItems = new HashMap<ICommand<TargetStateViewController.TargetStateViewItem>, MenuItem>();
        allMenuItems.put(this.controller.getCopyCommand(), ContextMenuHelper.addItem(contextMenu, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (ICommandDispatcher)NullUtils.neverNull((Object)this.controller), this.controller.getCopyCommand()));
        allMenuItems.put(Commands.SHOW_PREV_STATE_CHANGE_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, (ICommandDispatcher)NullUtils.neverNull((Object)this.controller), Commands.SHOW_PREV_STATE_CHANGE_LOCATION_COMMAND));
        allMenuItems.put(Commands.SHOW_NEXT_STATE_CHANGE_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, (ICommandDispatcher)NullUtils.neverNull((Object)this.controller), Commands.SHOW_NEXT_STATE_CHANGE_LOCATION_COMMAND));
        this.contextMenuEventHandler = event -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!this.controller.canDispatchCommand((ICommand<? super TargetStateViewController.TargetStateViewItem>)command)));
        contextMenu.setOnShowing((EventHandler)new WeakEventHandler(this.contextMenuEventHandler));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.mainTable), contextMenu);
    }

    @Override
    protected void setFxFocus() {
        this.filterText.requestFocus();
    }

    @Override
    public @Nullable String getHelpId() {
        return "com.arm.mgd.help.targetstateview";
    }
}

