/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.ui.controllers.SimpleTableViewController;
import com.arm.mgd.ui.controllers.SimpleTableViewItem;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.HashMap;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;

public class SimpleTableView<CONTROLLER_TYPE extends SimpleTableViewController<SimpleTableViewItem>>
extends TableView<SimpleTableViewItem> {
    protected final @NonNull CONTROLLER_TYPE controller;
    @FXML
    private TableColumn<SimpleTableViewItem, String> nameColumn;
    @FXML
    private TableColumn<SimpleTableViewItem, String> valueColumn;

    public SimpleTableView(@NonNull CONTROLLER_TYPE controller) throws IOException {
        this.controller = controller;
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/simpleTableView.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        fxmlLoader.load();
        this.setItems(((SimpleTableViewController)controller).getItemList());
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.nameColumn.setMinWidth(100.0);
        this.nameColumn.setPrefWidth(300.0);
        this.valueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.valueColumn.getStyleClass().add((Object)"numeric-column-alignment");
        this.valueColumn.setMinWidth(100.0);
        ((SimpleTableViewController)controller).bindSelectedIndices((ObservableList<Integer>)this.getSelectionModel().getSelectedIndices());
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ContextMenu contextMenu = new ContextMenu();
        this.loadTableContextMenu(contextMenu);
    }

    private void loadTableContextMenu(@NonNull ContextMenu contextMenu) {
        HashMap<@NonNull ICommand<T>, @NonNull MenuItem> allMenuItems = new HashMap();
        allMenuItems.put(((SimpleTableViewController)this.controller).getCopyCommand(), ContextMenuHelper.addItem(contextMenu, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (ICommandDispatcher)NullUtils.neverNull(this.controller), ((SimpleTableViewController)this.controller).getCopyCommand()));
        contextMenu.setOnShowing(event -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!((SimpleTableViewController)this.controller).canDispatchCommand(command))));
        ContextMenuHelper.setContextMenu((Node)this, contextMenu);
    }
}

