/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.offlinecompiler.IGlStatistic;
import com.arm.mgd.core.util.CollectionComparator;
import com.arm.mgd.core.util.ComparableWeakReference;
import com.arm.mgd.core.util.NumberValueComparator;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.ShadersViewController;
import com.arm.mgd.ui.controllers.ShadersViewListItem;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.views.widgets.ColouredProgramTableCellFactory;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.ui.views.widgets.DeletedShaderContextualMessage;
import com.arm.mgd.ui.views.widgets.NotAvailableBinaryFormatContextualMessage;
import com.arm.mgd.ui.views.widgets.NotAvailableShaderCompilerStatisticsContextualMessage;
import com.arm.mgd.ui.views.widgets.NotAvailableStatisticsContextualMessage;
import com.arm.mgd.ui.views.widgets.ShadersViewTableCellFactory;
import com.arm.mgd.ui.views.widgets.TableHeaderTooltip;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ShadersViewTab
extends VBox {
    @FXML
    private TableColumn<@Nullable ShadersViewListItem, @Nullable AbstractConstantOrAliasSpecExtended> binaryFormatColumn;
    private final @NonNull ShadersViewController controller;
    @FXML
    private TableColumn<@Nullable ShadersViewListItem, @Nullable Long> instancesRunColumn;
    @FXML
    private TableColumn<@Nullable ShadersViewListItem, @Nullable Collection<ComparableWeakReference<GlProgramAsset>>> linkedProgramsColumn;
    @FXML
    private TableColumn<@Nullable ShadersViewListItem, @Nullable String> noteColumn;
    @FXML
    private TableColumn<@Nullable ShadersViewListItem, @Nullable Float> percentCyclesColumn;
    @FXML
    private TableColumn<@Nullable ShadersViewListItem, @NonNull Long> shaderIDColumn;
    private final List<@NonNull TableColumn<@Nullable ShadersViewListItem, @Nullable Object>> shaderStatisticsColumns = new ArrayList<TableColumn<ShadersViewListItem, Object>>();
    @FXML
    private TableView<ShadersViewListItem> shadersViewTable;
    @FXML
    private TableColumn<@Nullable ShadersViewListItem, @Nullable Float> totalCyclesColumn;
    @FXML
    private Label totalCyclesLabel;
    @FXML
    private CheckBox filterCheckbox;

    protected ShadersViewTab(@NonNull ReadOnlyBooleanProperty visibleProperty, @NonNull AbstractConstantOrAliasSpecExtended targetShaderType) throws IOException {
        this.controller = new ShadersViewController(visibleProperty, targetShaderType);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/resources/shadersViewTab.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.load();
        this.linkedProgramsColumn.setCellValueFactory((Callback)new PropertyValueFactory("linkedPrograms"));
        this.linkedProgramsColumn.setCellFactory((Callback)new ColouredProgramTableCellFactory(this.controller));
        this.linkedProgramsColumn.setComparator((Comparator)new CollectionComparator());
        TableHeaderTooltip.makeHeaderWithTooltip(this.linkedProgramsColumn, "Linked Programs");
        this.shaderIDColumn.setCellValueFactory((Callback)new PropertyValueFactory("shaderId"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.shaderIDColumn, "Shader ID");
        ShadersViewTableCellFactory<@Nullable S, @NonNull T> shaderIDCellFactory = new ShadersViewTableCellFactory(null);
        shaderIDCellFactory.addContextualMessage(new DeletedShaderContextualMessage());
        this.shaderIDColumn.setCellFactory(shaderIDCellFactory);
        this.instancesRunColumn.setCellValueFactory((Callback)new PropertyValueFactory("instancesRun"));
        this.instancesRunColumn.setText(this.getInstancesRunTitle());
        this.instancesRunColumn.setComparator((Comparator)new NumberValueComparator());
        TableHeaderTooltip.makeHeaderWithTooltip(this.instancesRunColumn, this.getInstancesRunTooltip());
        this.instancesRunColumn.getStyleClass().add((Object)"numeric-column-alignment");
        ShadersViewTableCellFactory<@Nullable S, @Nullable T> instancesRunCellFactory = new ShadersViewTableCellFactory(null);
        instancesRunCellFactory.addContextualMessage(new DeletedShaderContextualMessage());
        instancesRunCellFactory.addContextualMessage(new NotAvailableStatisticsContextualMessage(this.controller, null));
        this.instancesRunColumn.setCellFactory(instancesRunCellFactory);
        if (this.isTotalCyclesSupported()) {
            this.totalCyclesColumn.setCellValueFactory((Callback)new PropertyValueFactory("totalCycles"));
            ShadersViewTableCellFactory<@Nullable S, @Nullable T> totalCyclesCellFactory = new ShadersViewTableCellFactory("%.1f");
            this.totalCyclesColumn.setComparator((Comparator)new NumberValueComparator());
            TableHeaderTooltip.makeHeaderWithTooltip(this.totalCyclesColumn, this.getTotalCyclesTooltip());
            this.totalCyclesColumn.getStyleClass().add((Object)"numeric-column-alignment");
            totalCyclesCellFactory.addContextualMessage(new DeletedShaderContextualMessage());
            totalCyclesCellFactory.addContextualMessage(new NotAvailableStatisticsContextualMessage(this.controller, "total cycles"));
            this.totalCyclesColumn.setCellFactory(totalCyclesCellFactory);
            this.percentCyclesColumn.setCellValueFactory((Callback)new PropertyValueFactory("percentCycles"));
            this.percentCyclesColumn.setComparator((Comparator)new NumberValueComparator());
            TableHeaderTooltip.makeHeaderWithTooltip(this.percentCyclesColumn, "Percentage of total cycles of all shaders across all draw calls in current frame, up to and including current selected function");
            this.percentCyclesColumn.getStyleClass().add((Object)"numeric-column-alignment");
            ShadersViewTableCellFactory<@Nullable S, @Nullable T> percentCyclesCellFactory = new ShadersViewTableCellFactory("%.1f%%");
            percentCyclesCellFactory.addContextualMessage(new DeletedShaderContextualMessage());
            percentCyclesCellFactory.addContextualMessage(new NotAvailableStatisticsContextualMessage(this.controller, "percentage cycles"));
            this.percentCyclesColumn.setCellFactory(percentCyclesCellFactory);
        } else {
            this.shadersViewTable.getColumns().remove(this.totalCyclesColumn);
            this.shadersViewTable.getColumns().remove(this.percentCyclesColumn);
            this.totalCyclesColumn = null;
            this.percentCyclesColumn = null;
        }
        this.binaryFormatColumn.setCellValueFactory((Callback)new PropertyValueFactory("binaryFormat"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.binaryFormatColumn, "The binary format used for this shader, or empty if it is a text shader");
        ShadersViewTableCellFactory<@Nullable S, @Nullable T> binaryFormatCellFactory = new ShadersViewTableCellFactory(null);
        binaryFormatCellFactory.addContextualMessage(new DeletedShaderContextualMessage());
        binaryFormatCellFactory.addContextualMessage(new NotAvailableBinaryFormatContextualMessage());
        this.binaryFormatColumn.setCellFactory(binaryFormatCellFactory);
        this.noteColumn.setCellValueFactory((Callback)new PropertyValueFactory("note"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.noteColumn, "Additional information associated with the shader");
        ShadersViewTableCellFactory<@Nullable S, @Nullable T> noteCellFactory = new ShadersViewTableCellFactory(null);
        noteCellFactory.addContextualMessage(new DeletedShaderContextualMessage());
        this.noteColumn.setCellFactory(noteCellFactory);
        this.controller.getShaderCompilerStatistics().addListener((SetChangeListener)new SetChangeListener<IGlStatistic>(){

            public void onChanged(SetChangeListener.Change<? extends IGlStatistic> change) {
                ShadersViewTab.this.fillAdditionalColumns();
            }
        });
        this.fillAdditionalColumns();
        this.controller.statisticsFinishedLoading().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && newValue.booleanValue()) {
                this.shadersViewTable.sort();
            }
        });
        this.shaderIDColumn.setSortType(TableColumn.SortType.ASCENDING);
        this.shadersViewTable.getSortOrder().add(this.shaderIDColumn);
        this.shadersViewTable.setTableMenuButtonVisible(true);
        this.shadersViewTable.setItems(this.controller.getShadersList());
        this.controller.bindSelectedIndices((ObservableList<Integer>)((ObservableList)NullUtils.neverNull((Object)this.shadersViewTable.getSelectionModel().getSelectedIndices())));
        this.shadersViewTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.loadTableContextMenu();
        this.controller.totalCycles().addListener((observable, oldValue, newValue) -> {
            String labelText = newValue != null ? String.format("Total Cycles: %d (cumulative over frame so far)", (long)newValue) : "Total Cycles: N/A";
            this.totalCyclesLabel.setText(labelText);
        });
        this.shadersViewTable.setRowFactory((Callback)new Callback<TableView<ShadersViewListItem>, TableRow<ShadersViewListItem>>(){

            public TableRow<ShadersViewListItem> call(TableView<ShadersViewListItem> param) {
                TableRow<ShadersViewListItem> row = new TableRow<ShadersViewListItem>(){
                    private final PseudoClass flaggedForDeletion = PseudoClass.getPseudoClass((String)"flaggedForDeletion");
                    private final PseudoClass deleted = PseudoClass.getPseudoClass((String)"deleted");

                    protected void updateItem(ShadersViewListItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!empty && item != null) {
                            this.pseudoClassStateChanged(this.flaggedForDeletion, false);
                            this.pseudoClassStateChanged(this.deleted, false);
                            GlShaderAsset shader = item.getShader();
                            if (shader != null) {
                                if (shader.isDeleted()) {
                                    this.pseudoClassStateChanged(this.deleted, true);
                                } else if (shader.isFlaggedForDeletion()) {
                                    this.pseudoClassStateChanged(this.flaggedForDeletion, true);
                                }
                            }
                        }
                    }
                };
                row.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        if (event.isPrimaryButtonDown() && event.getClickCount() == 2) {
                            (this).ShadersViewTab.this.controller.dispatchCommand((ICommand<? super ShadersViewListItem>)Commands.OPEN_ASSET_COMMAND);
                        }
                    }
                });
                return row;
            }
        });
        this.filterCheckbox.selectedProperty().bindBidirectional((Property)ShadersViewController.showActiveOnly);
        this.controller.addComparator((ReadOnlyObjectProperty<Comparator<ShadersViewListItem>>)this.shadersViewTable.comparatorProperty());
    }

    public void dispose() {
        this.controller.dispose();
    }

    protected abstract @NonNull String getInstancesRunTitle();

    protected abstract @NonNull String getInstancesRunTooltip();

    protected abstract @NonNull String getTotalCyclesTooltip();

    protected abstract boolean isTotalCyclesSupported();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void fillAdditionalColumns() {
        this.shadersViewTable.getColumns().removeAll(this.shaderStatisticsColumns);
        this.shaderStatisticsColumns.clear();
        for (IGlStatistic statistic : this.controller.getShaderCompilerStatistics()) {
            @Nullable TableColumn column = new TableColumn(statistic.getGlShaderStatType().getName());
            TableHeaderTooltip.makeHeaderWithTooltip(column, (String)NullUtils.neverNull((Object)statistic.getGlShaderStatType().getDescription()));
            column.setCellValueFactory(c -> {
                SimpleObjectProperty statsProperty = new SimpleObjectProperty();
                SimpleObjectProperty shaderStats = new SimpleObjectProperty();
                shaderStats.addListener((observable, oldValue, newValue) -> {
                    Object stat = null;
                    if (newValue != null) {
                        stat = newValue.getStat(statistic);
                    }
                    statsProperty.set(stat);
                });
                shaderStats.bind(((ShadersViewListItem)c.getValue()).shaderStatsProperty());
                return statsProperty;
            });
            column.setVisible(statistic.getGlShaderStatType().isUseful());
            column.setMinWidth(30.0);
            column.setMaxWidth(5000.0);
            column.setPrefWidth(90.0);
            column.setResizable(true);
            ShadersViewTableCellFactory<@Nullable S, @Nullable T> columnCellFactory = new ShadersViewTableCellFactory(null);
            columnCellFactory.addContextualMessage(new DeletedShaderContextualMessage());
            columnCellFactory.addContextualMessage(new NotAvailableShaderCompilerStatisticsContextualMessage());
            column.setCellFactory(columnCellFactory);
            column.getStyleClass().add((Object)"numeric-column-alignment");
            this.shaderStatisticsColumns.add((TableColumn<ShadersViewListItem, Object>)column);
        }
        this.shadersViewTable.getColumns().addAll(this.shaderStatisticsColumns);
    }

    private void loadTableContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        HashMap<@NonNull ICommand<Object>, @NonNull MenuItem> allMenuItems = new HashMap<ICommand<Object>, MenuItem>();
        allMenuItems.put(Commands.OPEN_ASSET_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.OPEN_ASSET_COMMAND));
        allMenuItems.put(Commands.EXPORT_SELECTED_SHADERS_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.EXPORT_SELECTED_SHADERS_COMMAND));
        allMenuItems.put(Commands.SHOW_CREATED_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.SHOW_CREATED_LOCATION_COMMAND));
        allMenuItems.put(Commands.SHOW_LAST_MODIFIED_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.SHOW_LAST_MODIFIED_LOCATION_COMMAND));
        allMenuItems.put(this.controller.getCopyCommand(), ContextMenuHelper.addItem(contextMenu, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), this.controller, this.controller.getCopyCommand()));
        contextMenu.setOnShowing(event -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!this.controller.canDispatchCommand((ICommand<? super ShadersViewListItem>)command))));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.shadersViewTable), contextMenu);
    }

    public static final class ComputeShadersView
    extends ShadersViewTab {
        public ComputeShadersView(@NonNull ReadOnlyBooleanProperty visibleProperty) throws IOException {
            super(visibleProperty, KapiSpec.GLES.constants.GL_COMPUTE_SHADER);
        }

        @Override
        protected @NonNull String getInstancesRunTitle() {
            return "Work Items";
        }

        @Override
        protected @NonNull String getInstancesRunTooltip() {
            return "The number of work items processed by this shader";
        }

        @Override
        protected @NonNull String getTotalCyclesTooltip() {
            return "The number of work items processed multiplied by the average number of clock cycles executed";
        }

        @Override
        protected boolean isTotalCyclesSupported() {
            return true;
        }
    }

    public static final class FragmentShadersView
    extends ShadersViewTab {
        public FragmentShadersView(@NonNull ReadOnlyBooleanProperty visibleProperty) throws IOException {
            super(visibleProperty, KapiSpec.GLES.constants.GL_FRAGMENT_SHADER);
        }

        @Override
        protected @NonNull String getInstancesRunTitle() {
            return "Fragments";
        }

        @Override
        protected @NonNull String getInstancesRunTooltip() {
            return "The number of fragments processed by this shader";
        }

        @Override
        protected @NonNull String getTotalCyclesTooltip() {
            return "The number of fragments processed multiplied by the average number of clock cycles executed";
        }

        @Override
        protected boolean isTotalCyclesSupported() {
            return true;
        }
    }

    public static final class GeometryShadersView
    extends ShadersViewTab {
        public GeometryShadersView(@NonNull ReadOnlyBooleanProperty visibleProperty) throws IOException {
            super(visibleProperty, KapiSpec.GLES.constants.GL_GEOMETRY_SHADER);
        }

        @Override
        protected @NonNull String getInstancesRunTitle() {
            return "Primitives";
        }

        @Override
        protected @NonNull String getInstancesRunTooltip() {
            return "The number of primitives processed by this shader";
        }

        @Override
        protected @NonNull String getTotalCyclesTooltip() {
            return "The number of primitives processed multiplied by the average number of clock cycles executed";
        }

        @Override
        protected boolean isTotalCyclesSupported() {
            return true;
        }
    }

    public static final class TessellationControlShadersView
    extends ShadersViewTab {
        public TessellationControlShadersView(@NonNull ReadOnlyBooleanProperty visibleProperty) throws IOException {
            super(visibleProperty, KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER);
        }

        @Override
        protected @NonNull String getInstancesRunTitle() {
            return "Patches";
        }

        @Override
        protected @NonNull String getInstancesRunTooltip() {
            return "The number of input patches for this shader";
        }

        @Override
        protected @NonNull String getTotalCyclesTooltip() {
            throw new AssertionError();
        }

        @Override
        protected boolean isTotalCyclesSupported() {
            return false;
        }
    }

    public static final class TessellationEvaluationShadersView
    extends ShadersViewTab {
        public TessellationEvaluationShadersView(@NonNull ReadOnlyBooleanProperty visibleProperty) throws IOException {
            super(visibleProperty, KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER);
        }

        @Override
        protected @NonNull String getInstancesRunTitle() {
            return "Patches";
        }

        @Override
        protected @NonNull String getInstancesRunTooltip() {
            return "The number of input patches for this shader";
        }

        @Override
        protected @NonNull String getTotalCyclesTooltip() {
            throw new AssertionError();
        }

        @Override
        protected boolean isTotalCyclesSupported() {
            return false;
        }
    }

    public static final class VertexShadersView
    extends ShadersViewTab {
        public VertexShadersView(@NonNull ReadOnlyBooleanProperty visibleProperty) throws IOException {
            super(visibleProperty, KapiSpec.GLES.constants.GL_VERTEX_SHADER);
        }

        @Override
        protected @NonNull String getInstancesRunTitle() {
            return "Vertices";
        }

        @Override
        protected @NonNull String getInstancesRunTooltip() {
            return "The number of vertices processed by this shader";
        }

        @Override
        protected @NonNull String getTotalCyclesTooltip() {
            return "The number of vertices processed multiplied by the average number of clock cycles executed";
        }

        @Override
        protected boolean isTotalCyclesSupported() {
            return true;
        }
    }
}

