/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.EditorInputManager;
import com.arm.mgd.ui.controllers.ConsoleTextBuilder;
import com.arm.mgd.ui.controllers.FileExplorerController;
import com.arm.mgd.ui.controllers.IConsoleCommandsHistory;
import com.arm.mgd.ui.controllers.ScriptingViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptingView
extends FXViewPart {
    private static final @NonNull Path SAVED_LOCATIONS_FILENAME = (Path)NullUtils.neverNull((Object)new File("ScriptingView-saved-locations").toPath());
    private static final String EXECFILE_CMD = "execfile";
    @FXML
    private Parent rootContainer;
    @FXML
    private Parent mainParent;
    @FXML
    private Parent disabledParent;
    @FXML
    private Label disabledReason;
    @FXML
    private TextArea outputConsoleTextArea;
    @FXML
    private TextField interactiveConsoleTextArea;
    @FXML
    private Button clearButton;
    @FXML
    private Button interruptButton;
    @FXML
    private Button resetButton;
    @FXML
    private ProgressBar scriptProgressBar;
    @FXML
    private Label scriptProgressBarLabel;
    @FXML
    private Button openFileButton;
    @FXML
    private Button addDirectoryButton;
    @FXML
    private Button removeButton;
    @FXML
    private TreeView<@NonNull FileExplorerController.FileExplorerItem> scriptTree;
    private ScriptingViewController controller;
    private static final Tooltip INACCESSIBLE_TOOLTIP = new Tooltip("This file cannot be read. It may be missing or you might not have permissions to read it.");
    private final @NonNull BooleanProperty topLevelItemSelected = new SimpleBooleanProperty();
    private final @NonNull FileExplorerController fileExplorerController = new FileExplorerController(new Predicate<File>(){

        @Override
        public boolean test(@NonNull File t) {
            String filename = t.getPath();
            return filename.substring(filename.lastIndexOf(46) + 1).equals("py");
        }
    });

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/scriptingView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (Parent)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.rootContainer.getStyleClass().add((Object)"scripting-view");
        this.controller = new ScriptingViewController(this.visibleProperty(), (ProgressBar)NullUtils.neverNull((Object)this.scriptProgressBar), (Label)NullUtils.neverNull((Object)this.scriptProgressBarLabel), (DoubleProperty)NullUtils.neverNull((Object)this.outputConsoleTextArea.scrollTopProperty()));
        this.disabledReason.textProperty().bind((ObservableValue)this.controller.getDisabledReason());
        this.fileExplorerController.loadSavedExplicitlyAddedLocations(Activator.getDefault().getUserFileStore(), SAVED_LOCATIONS_FILENAME);
        BooleanBinding disabled = this.controller.activeLiveTrace().or((ObservableBooleanValue)this.controller.anyTrace().not()).or((ObservableBooleanValue)this.controller.authorised().not());
        this.mainParent.visibleProperty().bind((ObservableValue)disabled.not());
        this.mainParent.managedProperty().bind((ObservableValue)disabled.not());
        this.disabledParent.visibleProperty().bind((ObservableValue)disabled);
        this.disabledParent.managedProperty().bind((ObservableValue)disabled);
        this.outputConsoleTextArea.editableProperty().set(false);
        ContextMenuHelper.createAndSetContextMenuForTextInputField((TextInputControl)NullUtils.neverNull((Object)this.outputConsoleTextArea), true);
        this.interactiveConsoleTextArea.setText(">>> ");
        this.interactiveConsoleTextArea.editableProperty().bind((ObservableValue)this.controller.isInterpreterBusy().not());
        this.interactiveConsoleTextArea.disableProperty().bind((ObservableValue)this.controller.isInterpreterBusy());
        ContextMenuHelper.createAndSetContextMenuForTextInputField((TextInputControl)NullUtils.neverNull((Object)this.interactiveConsoleTextArea), false);
        this.controller.currentLineNumber().addListener((observable, oldValue, newValue) -> {
            @NonNull String content = this.controller.getConsoleText();
            Platform.runLater(() -> {
                this.outputConsoleTextArea.replaceText(0, this.outputConsoleTextArea.getLength(), content);
                this.outputConsoleTextArea.setScrollTop(Double.MAX_VALUE);
            });
        });
        this.outputConsoleTextArea.needsLayoutProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.outputConsoleTextArea.setScrollTop(this.controller.savedConsoleScrollTop().get());
            }
        });
        this.outputConsoleTextArea.focusedProperty().addListener((observable, oldValue, newValue) -> this.controller.savedConsoleScrollTop().set(this.outputConsoleTextArea.scrollTopProperty().get()));
        this.controller.currentConsole().addListener((observable, oldValue, newValue) -> {
            @NonNull String content = this.controller.getConsoleText();
            @NonNull String prompt = (String)NullUtils.neverNull((Object)this.controller.currentPrompt().getValue());
            Platform.runLater(() -> {
                this.outputConsoleTextArea.replaceText(0, this.outputConsoleTextArea.getLength(), content);
                this.interactiveConsoleTextArea.setText(prompt);
            });
        });
        this.interactiveConsoleTextArea.caretPositionProperty().addListener((observable, oldValue, newValue) -> this.interactiveConsoleTextArea.positionCaret(Math.max(">>> ".length(), newValue.intValue())));
        this.interactiveConsoleTextArea.setOnKeyPressed(event -> {
            if (KeyCode.ENTER.equals((Object)event.getCode())) {
                this.executeLine();
            }
            this.handleHistory((KeyEvent)event);
            this.handlePasteFromClipboard((KeyEvent)event);
            this.forceCaretMovementOnArrowKeys((KeyEvent)event);
        });
        this.interactiveConsoleTextArea.selectionProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.getStart() < ">>> ".length()) {
                this.interactiveConsoleTextArea.selectRange(Math.max(">>> ".length(), newValue.getStart()), newValue.getEnd());
            }
        });
        this.clearButton.setOnAction(actionEvent -> {
            this.controller.clear();
            this.outputConsoleTextArea.clear();
        });
        this.clearButton.disableProperty().bind((ObservableValue)this.controller.isInterpreterBusy());
        this.interruptButton.setOnAction(actionEvent -> this.controller.interrupt());
        this.resetButton.setOnAction(actionEvent -> this.controller.reset());
        this.resetButton.disableProperty().bind((ObservableValue)this.controller.isInterpreterBusy());
        final @NonNull Scene scene = new Scene(this.rootContainer);
        this.openFileButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Add " + VersionProperties.FULL_PRODUCT_NAME + " Script File Location");
                FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(String.valueOf(VersionProperties.FULL_PRODUCT_NAME) + " script file (*.py)", new String[]{"*.py"});
                fileChooser.getExtensionFilters().add((Object)extensionFilter);
                fileChooser.setSelectedExtensionFilter(extensionFilter);
                List files = fileChooser.showOpenMultipleDialog(scene.getWindow());
                if (files != null) {
                    for (File file : files) {
                        if (!$assertionsDisabled && file == null) {
                            throw new AssertionError();
                        }
                        ScriptingView.this.fileExplorerController.addFileSystemLocation(file, file.isDirectory());
                    }
                }
            }
        });
        this.addDirectoryButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DirectoryChooser directoryChooser = new DirectoryChooser();
                directoryChooser.setTitle("Add " + VersionProperties.FULL_PRODUCT_NAME + " Script Directory Location");
                File directory = directoryChooser.showDialog(scene.getWindow());
                if (directory != null) {
                    ScriptingView.this.fileExplorerController.addFileSystemLocation(directory, directory.isDirectory());
                }
            }
        });
        this.scriptTree.rootProperty().bind(this.fileExplorerController.treeRootProperty());
        this.removeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                for (TreeItem selectedFileItem : ScriptingView.this.scriptTree.getSelectionModel().getSelectedItems()) {
                    ScriptingView.this.fileExplorerController.removeFileSystemLocation(((FileExplorerController.FileExplorerItem)selectedFileItem.getValue()).getFile());
                }
            }
        });
        this.scriptTree.setCellFactory((Callback)new Callback<TreeView<FileExplorerController.FileExplorerItem>, TreeCell<FileExplorerController.FileExplorerItem>>(){

            /*
             * Exception decompiling
             */
            public TreeCell<@NonNull FileExplorerController.FileExplorerItem> call(TreeView<@NonNull FileExplorerController.FileExplorerItem> param) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.pathIterator()" because the return value of "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.access$300(org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated)" is null
                 *     at org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated$Iterator.moveNested(JavaRefTypeInstance.java:200)
                 *     at org.benf.cfr.reader.entities.attributes.TypePathPartNested.apply(TypePathPartNested.java:14)
                 *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:54)
                 *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:45)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.handleStatement(TypeAnnotationTransformer.java:141)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:144)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:61)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:60)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:55)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.applyTypeAnnotations(Op04StructuredStatement.java:733)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:957)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        this.createContextMenu();
        this.scriptTree.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.topLevelItemSelected.set(newValue != null && ((FileExplorerController.FileExplorerItem)newValue.getValue()).wasExplicitlyAdded()));
        this.removeButton.disableProperty().bind((ObservableValue)this.topLevelItemSelected.not());
        return scene;
    }

    @Override
    public void dispose() {
        this.fileExplorerController.saveExplicitlyAddedLocations(Activator.getDefault().getUserFileStore(), SAVED_LOCATIONS_FILENAME);
        this.fileExplorerController.shutdown();
        if (this.controller != null) {
            this.controller.dispose();
            this.controller = null;
        }
        super.dispose();
    }

    private void createContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem run = ContextMenuHelper.addItem(contextMenu, "Run script", new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[0]), (EventHandler<ActionEvent>)((EventHandler)event -> this.runSelectedFile()));
        MenuItem open = ContextMenuHelper.addItem(contextMenu, "Open script", null, (EventHandler<ActionEvent>)((EventHandler)event -> EditorInputManager.openExternalEditor(((FileExplorerController.FileExplorerItem)((TreeItem)this.scriptTree.getSelectionModel().getSelectedItem()).getValue()).getFile())));
        contextMenu.setOnShowing(event -> {
            boolean isReadableScriptSelected = this.isReadableScriptSelected();
            run.setDisable(!isReadableScriptSelected);
            open.setDisable(!isReadableScriptSelected);
        });
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.scriptTree), contextMenu);
    }

    /*
     * Exception decompiling
     */
    private boolean isReadableScriptSelected() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.pathIterator()" because the return value of "org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated.access$300(org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated)" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance$Annotated$Iterator.moveNested(JavaRefTypeInstance.java:200)
         *     at org.benf.cfr.reader.entities.attributes.TypePathPartNested.apply(TypePathPartNested.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:54)
         *     at org.benf.cfr.reader.bytecode.analysis.types.TypeAnnotationHelper.apply(TypeAnnotationHelper.java:45)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.handleStatement(TypeAnnotationTransformer.java:141)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:61)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.TypeAnnotationTransformer.transform(TypeAnnotationTransformer.java:55)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.applyTypeAnnotations(Op04StructuredStatement.java:733)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:957)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void runSelectedFile() {
        this.interactiveConsoleTextArea.appendText("execfile(\"" + StringEscapeUtils.escapeJava((String)((FileExplorerController.FileExplorerItem)((TreeItem)this.scriptTree.getSelectionModel().getSelectedItem()).getValue()).getFile().getAbsolutePath()) + "\")");
        this.executeLine();
    }

    private void executeLine() {
        @NonNull String lastLine = (String)NullUtils.nonNullOrDefault((Object)this.interactiveConsoleTextArea.getText(), (Object)"");
        @NonNull CompletableFuture<@NonNull String> promptFuture = this.controller.runSourceFromConsole(lastLine);
        promptFuture.thenAccept(prompt -> Platform.runLater(() -> {
            this.interactiveConsoleTextArea.setText(prompt);
            this.interactiveConsoleTextArea.requestFocus();
            this.interactiveConsoleTextArea.deselect();
            this.controller.savedConsoleScrollTop().set(Double.MAX_VALUE);
        }));
    }

    private void forceCaretMovementOnArrowKeys(@NonNull KeyEvent event) {
        if (KeyCode.BACK_SPACE.equals((Object)event.getCode()) && this.interactiveConsoleTextArea.getCaretPosition() <= ">>> ".length() && this.interactiveConsoleTextArea.getSelection().getLength() == 0) {
            event.consume();
        }
    }

    private void handlePasteFromClipboard(@NonNull KeyEvent event) {
        if (event.isShortcutDown() && KeyCode.V.equals((Object)event.getCode())) {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            if (!clipboard.hasString()) {
                return;
            }
            String content = clipboard.getString();
            if (content.isEmpty()) {
                return;
            }
            CompletableFuture.runAsync(() -> {
                String @NonNull [] lines = (String[])NullUtils.neverNull((Object[])content.split(ConsoleTextBuilder.LINE_SEPARATOR));
                assert (lines != null);
                if (lines.length == 0) {
                    return;
                }
                @NonNull String firstLineFromClipboard = (String)NullUtils.nonNullOrDefault((Object)lines[0], (Object)"");
                lines[0] = ScriptingView.replaceTextWithClipboardLine((TextInputControl)NullUtils.neverNull((Object)this.interactiveConsoleTextArea), firstLineFromClipboard);
                Iterator<String> lineIterator = Arrays.asList(lines).iterator();
                while (lineIterator.hasNext()) {
                    @NonNull String line = (String)NullUtils.nonNullOrDefault((Object)lineIterator.next(), (Object)"");
                    if (!lineIterator.hasNext()) continue;
                    try {
                        this.controller.runSourceFromConsole(">>> " + line).get(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | CancellationException | ExecutionException | TimeoutException exception) {
                        // empty catch block
                    }
                }
                String lastLine = lines[lines.length - 1];
                this.interactiveConsoleTextArea.setText(">>> " + lastLine);
                this.interactiveConsoleTextArea.requestFocus();
                this.interactiveConsoleTextArea.positionCaret(this.interactiveConsoleTextArea.getText().length());
            });
            event.consume();
        }
    }

    private static @NonNull String replaceTextWithClipboardLine(@NonNull TextInputControl inputControl, @NonNull String lineFromClipboard) {
        @NonNull StringBuilder firstLineStringBuilder = new StringBuilder(inputControl.getText());
        @NonNull IndexRange selection = (IndexRange)NullUtils.neverNull((Object)inputControl.getSelection());
        if (selection.getLength() > 0) {
            firstLineStringBuilder.replace(selection.getStart(), selection.getEnd(), lineFromClipboard);
        } else {
            firstLineStringBuilder.replace(inputControl.getCaretPosition(), inputControl.getCaretPosition(), lineFromClipboard);
        }
        firstLineStringBuilder.replace(0, ">>> ".length(), "");
        return (String)NullUtils.neverNull((Object)firstLineStringBuilder.toString());
    }

    private void handleHistory(@NonNull KeyEvent event) {
        if (!ScriptingView.isHistoryKey(event)) {
            return;
        }
        @Nullable IConsoleCommandsHistory consoleCommandsHistory = this.controller.getConsoleCommandsHistory();
        if (consoleCommandsHistory == null) {
            return;
        }
        int start = ">>> ".length();
        int end = this.interactiveConsoleTextArea.getLength();
        assert (start <= end);
        String line = this.interactiveConsoleTextArea.getText();
        if (KeyCode.UP.equals((Object)event.getCode())) {
            this.interactiveConsoleTextArea.replaceText(start, end, consoleCommandsHistory.getPrevious(String.valueOf(line.substring(">>> ".length(), line.length())) + ConsoleTextBuilder.LINE_SEPARATOR));
        } else if (KeyCode.DOWN.equals((Object)event.getCode())) {
            this.interactiveConsoleTextArea.replaceText(start, end, consoleCommandsHistory.getNext(String.valueOf(line.substring(">>> ".length(), line.length())) + ConsoleTextBuilder.LINE_SEPARATOR));
        }
        this.interactiveConsoleTextArea.positionCaret(this.interactiveConsoleTextArea.getLength());
        event.consume();
    }

    private static boolean isHistoryKey(@NonNull KeyEvent event) {
        return KeyCode.UP.equals((Object)event.getCode()) || KeyCode.DOWN.equals((Object)event.getCode());
    }

    @Override
    protected void setFxFocus() {
        assert (this.interactiveConsoleTextArea != null);
        this.interactiveConsoleTextArea.requestFocus();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.scriptingview";
    }

    private static final class FileTreeCell
    extends TreeCell<FileExplorerController.FileExplorerItem> {
        private static final PseudoClass file = PseudoClass.getPseudoClass((String)"file-node");
        private static final PseudoClass directory = PseudoClass.getPseudoClass((String)"directory-node");
        private static final PseudoClass inaccessible = PseudoClass.getPseudoClass((String)"inaccessible");
        private final BooleanProperty accessible = new SimpleBooleanProperty(true);

        FileTreeCell() {
            this.accessible.addListener(e -> this.pseudoClassStateChanged(inaccessible, !this.accessible.get()));
            this.accessible.addListener(e -> {
                if (this.accessible.get()) {
                    this.setTooltip(null);
                } else {
                    this.setTooltip(INACCESSIBLE_TOOLTIP);
                }
            });
        }

        public void updateItem(@NonNull FileExplorerController.FileExplorerItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.pseudoClassStateChanged(file, false);
                this.pseudoClassStateChanged(directory, false);
                this.accessible.unbind();
                this.accessible.set(true);
                return;
            }
            if (item.wasExplicitlyAdded()) {
                this.setText(item.getFile().toString());
            } else {
                this.setText(item.getFile().getName());
            }
            this.accessible.bind((ObservableValue)item.accessible());
            this.pseudoClassStateChanged(file, !item.isDirectory());
            this.pseudoClassStateChanged(directory, item.isDirectory());
        }
    }
}

