/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.lightweight.asset.gles.GlRenderbufferAsset;
import com.arm.mgd.ui.controllers.RenderbuffersViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import java.io.IOException;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.eclipse.jdt.annotation.Nullable;

public class RenderbuffersView
extends FXViewPart {
    private TableView<GlRenderbufferAsset.Value> rootContainer;
    @FXML
    private TableColumn<GlRenderbufferAsset.Value, String> renderbufferNameCol;
    @FXML
    private TableColumn<GlRenderbufferAsset.Value, String> renderbufferWidthCol;
    @FXML
    private TableColumn<GlRenderbufferAsset.Value, String> renderbufferHeightCol;
    @FXML
    private TableColumn<GlRenderbufferAsset.Value, String> renderbufferInternalFormatCol;
    @FXML
    private TableColumn<GlRenderbufferAsset.Value, String> renderbufferSamplesCol;
    private final RenderbuffersViewController controller = new RenderbuffersViewController(this.visibleProperty());

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/renderbuffersView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (TableView)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.renderbufferNameCol.setCellValueFactory(cellData -> new SimpleStringProperty("" + ((GlRenderbufferAsset)((GlRenderbufferAsset.Value)cellData.getValue()).getAssetObject()).getId()));
        this.renderbufferWidthCol.setCellValueFactory(cellData -> new SimpleStringProperty("" + ((GlRenderbufferAsset.Value)cellData.getValue()).getWidth().getValue()));
        this.renderbufferHeightCol.setCellValueFactory(cellData -> new SimpleStringProperty("" + ((GlRenderbufferAsset.Value)cellData.getValue()).getHeight().getValue()));
        this.renderbufferInternalFormatCol.setCellValueFactory(cellData -> new SimpleStringProperty("" + ((GlRenderbufferAsset.Value)cellData.getValue()).getInternalFormat().getValue()));
        this.renderbufferSamplesCol.setCellValueFactory(cellData -> new SimpleStringProperty("" + ((GlRenderbufferAsset.Value)cellData.getValue()).getSamples().getValue()));
        this.rootContainer.setItems(this.controller.getFilteredTableData());
        Scene scene = new Scene(this.rootContainer);
        return scene;
    }

    @Override
    protected void setFxFocus() {
        this.rootContainer.requestFocus();
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.renderbuffersview";
    }
}

