/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.renderpassdependencies.IRenderPassDependency;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.RenderPassDependencyViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import java.io.IOException;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.Nullable;

public class RenderPassDependencyView
extends FXViewPart {
    @FXML
    private BorderPane rootContainer;
    @FXML
    private StackPane treeStackPane;
    @FXML
    private TreeView<IRenderPassDependency> dependencyTree;
    @FXML
    private Button generateButton;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Label noContentLabel;
    private RenderPassDependencyViewController controller;

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/renderPassDependencyView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (BorderPane)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        Scene scene = new Scene((Parent)this.rootContainer);
        this.controller = new RenderPassDependencyViewController(this.visibleProperty());
        this.dependencyTree.rootProperty().bind(this.controller.getRootProperty());
        this.dependencyTree.setCellFactory((Callback)new Callback<TreeView<IRenderPassDependency>, TreeCell<IRenderPassDependency>>(){

            public TreeCell<IRenderPassDependency> call(TreeView<IRenderPassDependency> param) {
                return new RenderPassDependencyCell();
            }
        });
        this.generateButton.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                RenderPassDependencyView.this.controller.generateTree();
            }
        });
        this.generateButton.disableProperty().bind((ObservableValue)this.controller.isGenerateButtonDisabled());
        this.generateButton.setTooltip(new Tooltip("Analyse the current selected frame and generate dependency report"));
        this.dependencyTree.visibleProperty().bind((ObservableValue)this.controller.progressVisible().not());
        this.progressBar.visibleProperty().bind((ObservableValue)this.controller.progressVisible());
        this.progressBar.managedProperty().bind((ObservableValue)this.controller.progressVisible());
        this.progressBar.progressProperty().bind((ObservableValue)this.controller.progress());
        this.noContentLabel.visibleProperty().bind((ObservableValue)this.controller.contentToDisplay().not());
        return scene;
    }

    @Override
    protected void setFxFocus() {
        this.dependencyTree.requestFocus();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.renderpassdependenciesview";
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    private static final class RenderPassDependencyCell
    extends TreeCell<IRenderPassDependency> {
        private RenderPassDependencyCell() {
        }

        public void updateItem(IRenderPassDependency item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.setText(item.getAsString());
            }
        }
    }
}

