/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.FunctionCallInformationViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionCallView
extends FXViewPart {
    @FXML
    private TabPane rootContainer;
    @FXML
    private Tab argumentsTab;
    @FXML
    private Tab addtionalInfoTab;
    @FXML
    private Tab documentationTab;
    @FXML
    private WebView argumentsBrowser;
    @FXML
    private WebView documentationBrowser;
    @FXML
    private TableView<AbstractMap.SimpleImmutableEntry<String, String>> additionalInfoTable;
    @FXML
    private TableColumn<AbstractMap.SimpleImmutableEntry<String, String>, String> nameColumn;
    @FXML
    private TableColumn<AbstractMap.SimpleImmutableEntry<String, String>, String> valueColumn;
    @FXML
    private Label documentationNoFunctionLabel;
    @FXML
    private Label argumentsNoFunctionLabel;
    private FunctionCallInformationViewController controller = new FunctionCallInformationViewController(this.visibleProperty());

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/functionCallView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (TabPane)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.additionalInfoTable.setPlaceholder((Node)new Label("The selected function call has no additional information"));
        this.additionalInfoTable.setItems(this.controller.getAdditionalInformationItems());
        this.nameColumn.setCellValueFactory(p -> new SimpleStringProperty((String)((AbstractMap.SimpleImmutableEntry)p.getValue()).getKey()));
        this.valueColumn.setCellValueFactory(p -> new SimpleStringProperty((String)((AbstractMap.SimpleImmutableEntry)p.getValue()).getValue()));
        final WebEngine argumentsWebEngine = this.argumentsBrowser.getEngine();
        try {
            URL url = FileLocator.resolve((URL)this.getClass().getResource("/resources/argumentsWebView.css"));
            argumentsWebEngine.setUserStyleSheetLocation(url.toString());
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        this.controller.argumentsHTMLProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue == null) {
                    argumentsWebEngine.load(null);
                } else {
                    argumentsWebEngine.loadContent(FunctionCallView.getHtml(newValue));
                }
            }
        });
        this.controller.documentationURLProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FunctionCallView.this.documentationBrowser.getEngine().load(newValue);
            }
        });
        this.argumentsNoFunctionLabel.visibleProperty().bind((ObservableValue)this.controller.noFunctionCallSelectedProperty());
        this.documentationNoFunctionLabel.visibleProperty().bind((ObservableValue)this.controller.noFunctionCallSelectedProperty());
        ContextMenuHelper.createAndSetContextMenuForWebView((WebView)NullUtils.neverNull((Object)this.argumentsBrowser));
        ContextMenuHelper.createAndSetContextMenuForWebView((WebView)NullUtils.neverNull((Object)this.documentationBrowser));
        return new Scene((Parent)this.rootContainer);
    }

    private static @NonNull String getHtml(@NonNull String htmlContent) {
        return "<!DOCTYPE html><html><body>" + htmlContent + "</body></html>";
    }

    @Override
    protected void setFxFocus() {
        this.rootContainer.requestFocus();
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    @Override
    public @Nullable String getHelpId() {
        return "com.arm.mgd.help.functioncallinformationview";
    }
}

