/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.image.PixelReader;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FramebufferInfoStringHelper {
    public static int SATURATION_OVERDRAW_FACTOR = 10;
    public static final String SATURATION_OVERDRAW_FACTOR_LABEL = ">" + SATURATION_OVERDRAW_FACTOR + "x";

    public static String getPixelInformationString(AbstractConstantOrAliasSpecExtended currentAttachment, int x, int y, long[] rgba, PixelReader.IPixelReader pixelReader, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable FramebufferFeature.CaptureMode frameFeature, List<@NonNull GlShaderAsset> selectedFragmentShaders) {
        String coordString = "(" + x + "," + y + ") ";
        if (frameFeature == null) {
            return coordString;
        }
        StringBuilder infoStringBuilder = new StringBuilder(coordString);
        switch (frameFeature) {
            case SHADER_MAP: {
                if (rgba[0] == 0L && rgba[1] == 0L && rgba[2] == 0L || selectedFragmentShaders == null) break;
                int minDistance = Integer.MAX_VALUE;
                GlShaderAsset selectedShader = null;
                for (GlShaderAsset fragmentShader : selectedFragmentShaders) {
                    for (GlProgramAsset program : fragmentShader.getLinkedToProgramList()) {
                        int[] shaderColor = program.getColor().getColorAsInt();
                        int distance = (int)(Math.abs((long)shaderColor[0] - rgba[0]) + Math.abs((long)shaderColor[1] - rgba[1]) + Math.abs((long)shaderColor[2] - rgba[2]));
                        if (distance >= minDistance) continue;
                        minDistance = distance;
                        selectedShader = fragmentShader;
                    }
                }
                if (selectedShader == null) break;
                infoStringBuilder.append("Fragment Shader ").append(selectedShader.getId());
                break;
            }
            case OVERDRAW: {
                String numOverdraws = FramebufferInfoStringHelper.getOverdrawFactor(rgba);
                infoStringBuilder.append(numOverdraws).append(" Overdraw");
                break;
            }
            default: {
                String rgbString = FramebufferInfoStringHelper.getRGBAInfoForAttachment(rgba, currentAttachment, pixelReader);
                infoStringBuilder.append(rgbString);
            }
        }
        return infoStringBuilder.toString();
    }

    public static String getOverdrawFactor(long[] rgba) {
        long green = rgba[1];
        if (green > 250L) {
            return SATURATION_OVERDRAW_FACTOR_LABEL;
        }
        return String.format("%dx", (int)Math.round((double)green / (255.0 / (double)SATURATION_OVERDRAW_FACTOR)));
    }

    public static String getRGBAInfoForAttachment(long[] rgba, AbstractConstantOrAliasSpecExtended currentAttachment, PixelReader.IPixelReader pixelReader) {
        if (currentAttachment.equals(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT)) {
            assert (pixelReader != null);
            double divisorR = pixelReader.getRMax();
            double divisorB = pixelReader.getBMax();
            if (rgba[3] > 0L) {
                if (rgba[0] > 0L) {
                    assert (rgba[2] == 0L);
                    return String.format("[%.8f] ", (double)rgba[0] / divisorR);
                }
                if (rgba[2] > 0L) {
                    assert (rgba[0] == 0L);
                    return String.format("[%.8f] ", (double)(-rgba[2]) / divisorB);
                }
                return "[0.0] ";
            }
            return "";
        }
        if (currentAttachment.equals(KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT)) {
            String hex = Integer.toHexString((int)(rgba[0] & 0xFFL));
            return String.format("[0x%s%s] ", hex.length() == 1 ? "0" : "", hex);
        }
        assert (pixelReader != null);
        StringBuilder builder = new StringBuilder().append("[").append(rgba[0]).append(", ").append(rgba[1]).append(", ").append(rgba[2]).append(", ");
        if (pixelReader.hasAlpha()) {
            builder.append(rgba[3]);
        }
        return builder.append("] ").toString();
    }
}

