/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.FrameOverridesViewController;
import com.arm.mgd.ui.controllers.FrameOverridesViewListItem;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.views.widgets.BooleanIconTableCell;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.ui.views.widgets.StyleOverridableTableRow;
import com.arm.mgd.ui.views.widgets.TableHeaderTooltip;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FrameOverridesView
extends FXViewPart {
    @FXML
    private TableView<FrameOverridesViewListItem> tableView;
    @FXML
    private TableColumn<@Nullable FrameOverridesViewListItem, @Nullable Boolean> activeInFrameColumn;
    @FXML
    private TableColumn<@Nullable FrameOverridesViewListItem, @NonNull String> typeColumn;
    @FXML
    private TableColumn<@Nullable FrameOverridesViewListItem, @Nullable String> assetColumn;
    @FXML
    private Button addButton;
    @FXML
    private Button removeButton;
    private final @NonNull FrameOverridesViewController controller = new FrameOverridesViewController(this.visibleProperty());

    @Override
    public void dispose() {
        this.controller.dispose();
        super.dispose();
    }

    @Override
    protected Scene createFxScene() {
        VBox rootContainer;
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/frameOverridesView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            rootContainer = (VBox)fxmlLoader.load();
        }
        catch (IOException e2) {
            CoreLogging.severe((Throwable)e2);
            return null;
        }
        this.activeInFrameColumn.setCellValueFactory((Callback)new PropertyValueFactory("activeInFrame"));
        this.activeInFrameColumn.setCellFactory(column -> new BooleanIconTableCell(FXImages.TICK, null, null));
        TableHeaderTooltip.makeHeaderWithTooltip(this.activeInFrameColumn, "This override is active in the selected replay frame");
        this.typeColumn.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.typeColumn, "The type of override");
        this.assetColumn.setCellValueFactory((Callback)new PropertyValueFactory("asset"));
        TableHeaderTooltip.makeHeaderWithTooltip(this.assetColumn, "The object being overridden");
        this.tableView.setRowFactory(new StyleOverridableTableRow<FrameOverridesViewListItem>(this.tableView.getRowFactory(), new StyleUpdate()));
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, e -> this.tryRemoveButtonFire((KeyEvent)e));
        this.controller.bindItems((List)NullUtils.neverNull((Object)this.tableView.getItems()));
        this.controller.bindSelectedIndices((ObservableList<Integer>)((ObservableList)NullUtils.neverNull((Object)this.tableView.getSelectionModel().getSelectedIndices())));
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.addButton.disableProperty().bind((ObservableValue)this.controller.addButtonDisabledProperty());
        this.addButton.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                FrameOverridesView.this.controller.onAddNewOverrideClicked();
            }
        });
        this.removeButton.disableProperty().bind((ObservableValue)this.controller.removeButtonDisabledProperty());
        this.removeButton.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                FrameOverridesView.this.controller.onRemoveSelectedOverridesClicked();
            }
        });
        this.loadTableContextMenu();
        return new Scene((Parent)rootContainer);
    }

    @Override
    protected void setFxFocus() {
        this.tableView.requestFocus();
    }

    private void loadTableContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        HashMap<@NonNull ICommand<FrameOverridesViewListItem>, @NonNull MenuItem> allMenuItems = new HashMap<ICommand<FrameOverridesViewListItem>, MenuItem>();
        allMenuItems.put(Commands.EDIT_OVERRIDE_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.EDIT_OVERRIDE_COMMAND));
        allMenuItems.put(Commands.REMOVE_OVERRIDE_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.REMOVE_OVERRIDE_COMMAND));
        allMenuItems.put(Commands.VIEW_OVERRIDE_COMMAND, ContextMenuHelper.addItem(contextMenu, this.controller, Commands.VIEW_OVERRIDE_COMMAND));
        contextMenu.setOnShowing(event -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!this.controller.canDispatchCommand((ICommand<? super FrameOverridesViewListItem>)command))));
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.tableView), contextMenu);
    }

    private void tryRemoveButtonFire(KeyEvent e) {
        if (e.getCode() == KeyCode.DELETE && !this.removeButton.isDisabled()) {
            this.removeButton.fire();
        }
    }

    @Override
    public @Nullable String getHelpId() {
        return "com.arm.mgd.help.framereplayoverridesview";
    }

    private static final class StyleUpdate
    implements StyleOverridableTableRow.IStyleUpdater<FrameOverridesViewListItem> {
        private static final String DELETED = "deleted";

        private StyleUpdate() {
        }

        private static void addStyle(TableRow<FrameOverridesViewListItem> row, String styleClass) {
            if (!row.getStyleClass().contains((Object)styleClass)) {
                row.getStyleClass().add((Object)styleClass);
            }
        }

        private static void removeStyle(TableRow<FrameOverridesViewListItem> row, String styleClass) {
            row.getStyleClass().remove((Object)styleClass);
        }

        @Override
        public synchronized void update(TableRow<FrameOverridesViewListItem> row, Number oldRowID, Number newRowID) {
            FrameOverridesViewListItem item;
            int index = newRowID.intValue();
            ObservableList list = row.getTableView().getItems();
            FrameOverridesViewListItem frameOverridesViewListItem = item = index >= 0 && index < list.size() ? (FrameOverridesViewListItem)list.get(index) : null;
            if (item == null) {
                StyleUpdate.removeStyle(row, DELETED);
                row.setTooltip(null);
            } else {
                if (row.getTooltip() == null) {
                    row.setTooltip(new Tooltip());
                }
                if (!item.isDeleted()) {
                    StyleUpdate.removeStyle(row, DELETED);
                    if (((Boolean)item.activeInFrameProperty().get()).booleanValue()) {
                        row.getTooltip().setText("This override was used on the selected frame");
                    } else {
                        row.getTooltip().setText("This override will be applied on the next replayed frame");
                    }
                } else {
                    StyleUpdate.addStyle(row, DELETED);
                    row.getTooltip().setText("This override was used on the selected frame but has been deleted from the list of overrides to apply");
                }
            }
        }
    }
}

