/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.VulkanImageCompositor;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.ui.FXImages;
import com.arm.mgd.ui.controllers.FrameCaptureViewController;
import com.arm.mgd.ui.controllers.FrameCaptureViewData;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.utils.ArgumentHierarchyHTMLPrinter;
import com.arm.mgd.ui.utils.RGBAImage;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FrameCaptureView
extends FXViewPart {
    @FXML
    private VBox rootContainer;
    @FXML
    private SplitPane capturePane;
    @FXML
    private TreeView<FrameCaptureViewData.VulkanFrameCaptureTreeItemData> assetTree;
    @FXML
    private WebView infoBrowser;
    @FXML
    private BorderPane drawCallImagesPane;
    @FXML
    private ScrollPane mainImageViewScrollPane;
    @FXML
    private StackPane mainImageViewStackPane;
    @FXML
    private ImageView mainImageView;
    @FXML
    private ListView<FrameCaptureViewData.FrameCaptureViewAttachmentImage> attachmentImageList;
    @FXML
    private CheckBox actualSizeCheckBox;
    @FXML
    private ComboBox<RGBAImage.AlphaMode> alphaModeComboBox;
    @FXML
    private Label nonCapturedFrameLabel;
    @FXML
    private Label noSelectedCallText;
    @FXML
    private Label noSubmitInfosText;
    private FrameCaptureViewController controller = new FrameCaptureViewController(this.visibleProperty());
    private final @NonNull ObjectProperty<FrameCaptureViewController.FrameCaptureViewRoot> root = new SimpleObjectProperty();
    private final @NonNull BooleanProperty emptyRoot = new SimpleBooleanProperty();
    private final @NonNull BooleanProperty isCapturedFrame = new SimpleBooleanProperty();
    private final @NonNull ObjectProperty<FrameCaptureViewData.VulkanFrameCaptureTreeItemData> selectedNonDrawCallData = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<FrameCaptureViewData.DrawCallData> selectedDrawCallData = new SimpleObjectProperty();
    private final @NonNull ObjectProperty<Image> proxyMainImage = new SimpleObjectProperty();
    private final @NonNull StringProperty mainImageErrorMessage = new SimpleStringProperty();
    private final @NonNull ExecutorService executor = NamedExecutors.cachedNumCoresThreadPool((long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("FrameCaptureView Executor", 1));

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/vulkanFrameCaptureView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (VBox)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        WebEngine infoBrowserEngine = this.infoBrowser.getEngine();
        try {
            URL url = FileLocator.resolve((URL)this.getClass().getResource("/resources/argumentsWebView.css"));
            infoBrowserEngine.setUserStyleSheetLocation(url.toString());
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
        }
        this.attachmentImageList.setCellFactory(param -> new AttachmentImageListCell());
        this.assetTree.setCellFactory(param -> new CaptureDataTreeCell((ReadOnlyBooleanProperty)this.isCapturedFrame));
        this.alphaModeComboBox.getItems().setAll((Object[])RGBAImage.AlphaMode.values());
        this.alphaModeComboBox.getSelectionModel().select(0);
        this.mainImageViewStackPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"DEFAULT"), true);
        ContextMenuHelper.createAndSetContextMenuForWebView((WebView)NullUtils.neverNull((Object)this.infoBrowser));
        this.root.addListener((observable, oldValue, newValue) -> {
            assert (Platform.isFxApplicationThread());
            FrameCaptureViewController.VulkanFrameCaptureTreeItem newRoot = newValue == null ? null : newValue.treeRoot;
            this.assetTree.rootProperty().set((Object)newRoot);
            this.assetTree.getSelectionModel().selectFirst();
            this.emptyRoot.set(newRoot == null ? false : newRoot.getChildren().size() == 0);
            this.isCapturedFrame.set(newValue == null ? false : newValue.isCaptured);
        });
        this.noSelectedCallText.visibleProperty().bind((ObservableValue)this.root.isNull());
        this.noSubmitInfosText.visibleProperty().bind((ObservableValue)this.emptyRoot);
        this.capturePane.visibleProperty().bind((ObservableValue)this.root.isNotNull().and((ObservableBooleanValue)this.emptyRoot.not()));
        this.assetTree.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            FrameCaptureViewData.VulkanFrameCaptureTreeItemData newData = newValue != null ? (FrameCaptureViewData.VulkanFrameCaptureTreeItemData)newValue.getValue() : null;
            this.selectedNonDrawCallData.set((Object)(!(newData instanceof FrameCaptureViewData.DrawCallData) ? newData : null));
            this.selectedDrawCallData.set((Object)(newData instanceof FrameCaptureViewData.DrawCallData ? (FrameCaptureViewData.DrawCallData)newData : null));
        });
        this.infoBrowser.visibleProperty().bind((ObservableValue)this.selectedNonDrawCallData.isNotNull());
        this.drawCallImagesPane.visibleProperty().bind((ObservableValue)this.selectedDrawCallData.isNotNull().and((ObservableBooleanValue)this.isCapturedFrame));
        this.nonCapturedFrameLabel.visibleProperty().bind((ObservableValue)this.selectedDrawCallData.isNotNull().and((ObservableBooleanValue)this.isCapturedFrame.not()));
        this.selectedNonDrawCallData.addListener((observable, oldValue, newValue) -> {
            ArgumentHierarchyNode hierarchy;
            infoBrowserEngine.load(null);
            ArgumentHierarchyNode argumentHierarchyNode = hierarchy = newValue == null ? null : newValue.getArgumentHierarchy();
            if (hierarchy != null) {
                ArgumentHierarchyHTMLPrinter htmlPrinter = new ArgumentHierarchyHTMLPrinter();
                hierarchy.accept((ArgumentHierarchyNode.IArgumentHierarchyVisitor)htmlPrinter);
                infoBrowserEngine.loadContent(htmlPrinter.getHTML());
            }
        });
        this.selectedDrawCallData.addListener((observable, oldValue, newValue) -> {
            this.attachmentImageList.getItems().forEach(image -> image.dispose());
            if (newValue != null) {
                @NonNull VulkanImageCompositor compositor = ((FrameCaptureViewController.FrameCaptureViewRoot)this.root.get()).snapshot.getModel().getAsynchronousDataModel().getVulkanImageCompositor();
                @NonNull List< @NonNull FrameCaptureViewData.AttachmentImageData> imageData = newValue.getAttachmentImageData();
                @NonNull ArrayList<@NonNull E> newImages = new ArrayList();
                imageData.forEach(data -> newImages.add(new FrameCaptureViewData.FrameCaptureViewAttachmentImage(this.executor, compositor, (FrameCaptureViewData.AttachmentImageData)data, (ReadOnlyObjectProperty<RGBAImage.AlphaMode>)((ReadOnlyObjectProperty)NullUtils.neverNull((Object)this.alphaModeComboBox.getSelectionModel().selectedItemProperty())))));
                int lastSelected = Math.max(0, this.attachmentImageList.getSelectionModel().getSelectedIndex());
                if (oldValue == null || !newValue.getSubPass().equals(oldValue.getSubPass())) {
                    this.attachmentImageList.getItems().clear();
                }
                this.attachmentImageList.getItems().setAll(newImages);
                this.attachmentImageList.getSelectionModel().select(lastSelected >= imageData.size() ? 0 : lastSelected);
            } else {
                this.attachmentImageList.getItems().clear();
                this.mainImageView.setImage(null);
            }
        });
        this.attachmentImageList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.proxyMainImage.unbind();
            this.mainImageErrorMessage.unbind();
            this.mainImageErrorMessage.set(null);
            if (newValue != null) {
                if (!newValue.isImageLoading()) {
                    this.mainImageView.setImage(null);
                }
                this.proxyMainImage.bind(newValue.imageProperty());
                this.mainImageErrorMessage.bind((ObservableValue)newValue.imageLoadErrorProperty());
            }
        });
        this.proxyMainImage.addListener((imageObservable, oldImage, newImage) -> {
            if (newImage != null) {
                this.mainImageView.setImage(newImage);
            }
        });
        this.mainImageErrorMessage.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.mainImageView.setImage(null);
            }
        });
        this.actualSizeCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.setImageViewScaling((boolean)newValue));
        this.setImageViewScaling(this.actualSizeCheckBox.isSelected());
        this.root.bind(this.controller.rootProperty());
        return new Scene((Parent)this.rootContainer);
    }

    @Override
    public void dispose() {
        this.root.unbind();
        this.root.set(null);
        this.controller.dispose();
        this.controller = null;
        this.executor.shutdown();
        super.dispose();
    }

    private void setImageViewScaling(boolean actualSize) {
        if (actualSize) {
            this.mainImageView.fitHeightProperty().unbind();
            this.mainImageView.fitWidthProperty().unbind();
            this.mainImageView.setFitWidth(0.0);
            this.mainImageView.setFitHeight(0.0);
        } else {
            this.mainImageView.fitWidthProperty().bind((ObservableValue)this.mainImageViewScrollPane.widthProperty().subtract(this.mainImageViewScrollPane.getInsets().getLeft()).subtract(this.mainImageViewScrollPane.getInsets().getRight()));
            this.mainImageView.fitHeightProperty().bind((ObservableValue)this.mainImageViewScrollPane.heightProperty().subtract(this.mainImageViewScrollPane.getInsets().getTop()).subtract(this.mainImageViewScrollPane.getInsets().getBottom()));
        }
    }

    @Override
    protected void setFxFocus() {
        this.rootContainer.requestFocus();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.vulkanframecaptureview";
    }

    private static class AttachmentImageListCell
    extends ListCell<FrameCaptureViewData.FrameCaptureViewAttachmentImage> {
        private final @NonNull ImageView cellImageView = new ImageView();
        private final @NonNull StackPane stackPane = new StackPane(new Node[]{this.cellImageView});
        private final @NonNull Label attachmentName = new Label();
        private final @NonNull HBox attachmentNameBox = new HBox(new Node[]{this.attachmentName});
        private final @NonNull Label attachmentFormat = new Label();
        private final @NonNull HBox attachmentFormatBox = new HBox(new Node[]{this.attachmentFormat});
        private final @NonNull VBox textBox = new VBox(new Node[]{this.attachmentNameBox, this.attachmentFormatBox});
        private final @NonNull BorderPane borderPane = new BorderPane((Node)this.stackPane, (Node)this.textBox, null, null, null);
        private final @NonNull Tooltip tooltip = new Tooltip();
        private final @NonNull ObjectProperty<Image> proxyCellImage = new SimpleObjectProperty();
        private final @NonNull StringProperty cellImageErrorMessage = new SimpleStringProperty();

        private AttachmentImageListCell() {
            this.cellImageView.setPreserveRatio(true);
            this.cellImageView.fitWidthProperty().bind((ObservableValue)this.stackPane.widthProperty());
            this.cellImageView.fitHeightProperty().bind((ObservableValue)this.stackPane.heightProperty());
            this.stackPane.setMinSize(200.0, 130.0);
            this.stackPane.setMaxSize(200.0, 130.0);
            this.stackPane.setPrefSize(200.0, 130.0);
            this.stackPane.getStyleClass().add((Object)"vulkan-frame-capture-image");
            BorderPane.setAlignment((Node)this.stackPane, (Pos)Pos.CENTER);
            this.attachmentName.setAlignment(Pos.CENTER);
            this.attachmentNameBox.setAlignment(Pos.CENTER);
            this.attachmentFormat.setAlignment(Pos.CENTER);
            this.attachmentFormatBox.setAlignment(Pos.CENTER);
            BorderPane.setAlignment((Node)this.textBox, (Pos)Pos.CENTER);
            this.borderPane.setMaxWidth(200.0);
            this.borderPane.setMinWidth(200.0);
            this.borderPane.setPrefWidth(200.0);
            this.borderPane.setPadding(new Insets(4.0));
            this.setGraphic((Node)this.borderPane);
            this.proxyCellImage.addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    this.cellImageView.setImage(newValue);
                }
            });
            this.cellImageErrorMessage.addListener((observable, oldValue, newValue) -> {
                if (newValue != null && !newValue.isEmpty()) {
                    this.tooltip.setText(newValue);
                    this.setTooltip(this.tooltip);
                    this.stackPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"DEFAULT"), false);
                    this.stackPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"NOT_SUPPORTED"), true);
                    this.cellImageView.setImage(null);
                } else {
                    this.setTooltip(null);
                    this.stackPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"DEFAULT"), true);
                    this.stackPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"NOT_SUPPORTED"), false);
                }
            });
        }

        protected void updateItem(FrameCaptureViewData.FrameCaptureViewAttachmentImage item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.attachmentName.setText(null);
                this.attachmentFormat.setText(null);
                this.proxyCellImage.unbind();
                this.proxyCellImage.set(null);
                this.cellImageView.setImage(null);
                this.cellImageErrorMessage.unbind();
                this.cellImageErrorMessage.set(null);
                this.stackPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"DEFAULT"), false);
                this.stackPane.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"NOT_SUPPORTED"), false);
            } else {
                FrameCaptureViewData.AttachmentInfo info = item.getData().getAttachmentInfo();
                this.attachmentName.setText("Attachment " + info.attachmentIndex);
                this.attachmentFormat.setText(info.imageFormat.toString().replace("VK_FORMAT_", ""));
                if (!item.isImageLoading()) {
                    this.cellImageView.setImage(null);
                }
                this.proxyCellImage.bind(item.imageProperty());
                this.cellImageErrorMessage.bind((ObservableValue)item.imageLoadErrorProperty());
            }
        }
    }

    private static class CaptureDataTreeCell
    extends TreeCell<FrameCaptureViewData.VulkanFrameCaptureTreeItemData> {
        private final @NonNull ImageView hasDataImageView = new ImageView();
        private final @NonNull ReadOnlyBooleanProperty isCapturedFrame;

        private CaptureDataTreeCell(@NonNull ReadOnlyBooleanProperty isCapturedFrame) {
            this.isCapturedFrame = isCapturedFrame;
        }

        protected void updateItem(FrameCaptureViewData.VulkanFrameCaptureTreeItemData item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
                this.setIcon(null, null);
            } else {
                ReadOnlyBooleanProperty iconVisibleProperty;
                Image iconImage;
                this.setText(item.getName());
                if (!this.isCapturedFrame.get()) {
                    iconImage = null;
                    iconVisibleProperty = null;
                } else {
                    iconVisibleProperty = item.hasImageDataProperty();
                    iconImage = item instanceof FrameCaptureViewData.DrawCallData ? FXImages.FILM : FXImages.FILMS;
                }
                this.setIcon(iconImage, iconVisibleProperty);
            }
        }

        private void setIcon(@Nullable Image image, @Nullable ReadOnlyBooleanProperty visibleProperty) {
            this.hasDataImageView.setImage(image);
            this.setGraphic((Node)(image != null ? this.hasDataImageView : null));
            if (visibleProperty != null) {
                this.hasDataImageView.visibleProperty().bind((ObservableValue)visibleProperty);
            } else {
                this.hasDataImageView.visibleProperty().unbind();
                this.hasDataImageView.visibleProperty().set(false);
            }
        }
    }
}

