/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.util.BinarySearch;
import com.arm.mgd.core.util.FunctionCallSearcher;
import com.arm.mgd.core.util.SearchListener;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.UIUpdateTimerListener;
import com.arm.mgd.ui.filterruler.MarkerSet;
import com.arm.mgd.ui.utils.TogglableFXNavigationChangedListener;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FindFunctionControlController
implements SearchListener,
UIUpdateTimerListener {
    private final @NonNull TogglableFXNavigationChangedListener navigationChangedListener;
    private final @NonNull WeakReference<AbstractTarget> target;
    private final @NonNull FunctionCallSearcher searcher;
    private final @NonNull MarkerSet searchMarkerSet;
    private final @NonNull ReadOnlyDoubleWrapper progressValue = new ReadOnlyDoubleWrapper(-1.0);
    private final @NonNull ReadOnlyBooleanWrapper progressVisible = new ReadOnlyBooleanWrapper(false);
    private final @NonNull StringProperty searchResults = new SimpleStringProperty();
    private final @NonNull StringProperty searchText = new SimpleStringProperty();
    private final @NonNull BooleanProperty searchIsVisible = new SimpleBooleanProperty(false);
    private final @NonNull BooleanProperty includeParameters = new SimpleBooleanProperty();
    private final @NonNull ObjectProperty<@Nullable Pattern> currentPattern = new SimpleObjectProperty();
    private final @NonNull StringProperty searchPatternError = new SimpleStringProperty();
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FunctionCallSearcher.SearchParameters lastSearchedForParameters = null;
    private @NonNull WeakReference<@Nullable FunctionCall> functionCall = NullUtils.emptyWeakReference();

    public FindFunctionControlController(@NonNull ReadOnlyBooleanProperty enabledProperty, @NonNull AbstractTarget target, @NonNull MarkerSet searchMarkerSet) {
        this.target = new WeakReference<AbstractTarget>(target);
        this.searchMarkerSet = searchMarkerSet;
        this.searcher = new FunctionCallSearcher((SearchListener)this);
        this.searchText.addListener((observable, oldValue, newValue) -> this.updateSearchPattern((String)newValue));
        this.currentPattern.addListener((observable, oldValue, newValue) -> this.reloadSearchResults());
        this.progressValue.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue == null || newValue.doubleValue() < 0.0 || newValue.doubleValue() >= 1.0) {
                    FindFunctionControlController.this.progressVisible.set(false);
                } else {
                    FindFunctionControlController.this.progressVisible.set(true);
                }
            }
        });
        searchMarkerSet.visibleProperty().bindBidirectional((Property)this.searchIsVisible);
        Activator.uiUpdateTimer.addListener(this);
        this.navigationChangedListener = new TogglableFXNavigationChangedListener(CoreInstance.getNavigationManager(), enabledProperty, event -> this.onNavigationChanged(event));
    }

    public void dispose() {
        this.navigationChangedListener.dispose();
        Activator.uiUpdateTimer.removeListener(this);
        this.lastSearchedForParameters = null;
        this.searcher.terminate();
    }

    public void goToNextSearchMarker() {
        FunctionCall fc = (FunctionCall)this.functionCall.get();
        if (fc != null) {
            BinarySearch.BinarySearchNeighbours found = BinarySearch.findNeighbours(this.searchMarkerSet.getActivePositions(), (int)fc.getIndex());
            if (found.next != null) {
                CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)fc.getModel().getCallItem(found.next.intValue())), (Object)this);
            }
        }
    }

    public void goToPreviousSearchMarker() {
        FunctionCall fc = (FunctionCall)this.functionCall.get();
        if (fc != null) {
            BinarySearch.BinarySearchNeighbours found = BinarySearch.findNeighbours(this.searchMarkerSet.getActivePositions(), (int)fc.getIndex());
            if (found.previous != null) {
                CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)fc.getModel().getCallItem(found.previous.intValue())), (Object)this);
            }
        }
    }

    private void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewResolvedFunctionCall(newFunctionCall -> {
            TraceDataModel newModel;
            TraceDataModel traceDataModel = newModel = newFunctionCall != null ? newFunctionCall.getModel() : null;
            if (newModel != null && newModel.getParentProcessTarget().getParentTarget() == this.target.get()) {
                Platform.runLater(() -> {
                    this.functionCall = new WeakReference<FunctionCall>((FunctionCall)newFunctionCall);
                    this.reloadSearchResults();
                });
            }
            return null;
        });
    }

    @Override
    public void onTick() {
        Platform.runLater(() -> {
            this.reloadSearchResults();
            this.progressValue.set(this.searcher.getCurrentSearchProgress());
        });
    }

    public @NonNull ReadOnlyDoubleProperty progressValueProperty() {
        return this.progressValue.getReadOnlyProperty();
    }

    public @NonNull ReadOnlyBooleanProperty progressVisibleProperty() {
        return this.progressVisible.getReadOnlyProperty();
    }

    public @NonNull ReadOnlyStringProperty searchPatternErrorProperty() {
        return this.searchPatternError;
    }

    public void searchItemsFound(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull FunctionCallSearcher.SearchResults results) {
        Platform.runLater(() -> {
            if (searchResults.parameters.equals((Object)this.lastSearchedForParameters)) {
                this.searchMarkerSet.setActivePositions(searchResults.results);
                this.searchResults.set((Object)(String.valueOf(searchResults.results.size()) + " found"));
            }
        });
    }

    public ObservableValue<String> searchResults() {
        return this.searchResults;
    }

    public StringProperty searchTextProperty() {
        return this.searchText;
    }

    private void updateSearchPattern(@Nullable String searchString) {
        Pattern searchPattern = null;
        if (searchString == null || searchString.isEmpty()) {
            this.searchPatternError.set(null);
            this.currentPattern.set(null);
        } else {
            try {
                searchPattern = Pattern.compile(searchString, 2);
            }
            catch (PatternSyntaxException exception) {
                this.searchPatternError.set((Object)("This regular expression is invalid. Specifically:\n\n" + exception.getMessage() + "\n\nSee the Help for more information."));
            }
            if (searchPattern != null) {
                this.currentPattern.set((Object)searchPattern);
                this.searchPatternError.set(null);
            }
        }
    }

    private void reloadSearchResults() {
        assert (Platform.isFxApplicationThread());
        FunctionCall fc = (FunctionCall)this.functionCall.get();
        Pattern newPattern = (Pattern)this.currentPattern.get();
        if (fc == null || newPattern == null) {
            this.lastSearchedForParameters = null;
            this.searchMarkerSet.clearActivePositions();
            this.searchResults.set(null);
        } else {
            FunctionCallSearcher.SearchParameters parameters;
            this.lastSearchedForParameters = parameters = new FunctionCallSearcher.SearchParameters(newPattern, fc.getModel(), this.includeParameters.get());
            this.searcher.searchFor(parameters);
        }
    }

    public @NonNull BooleanProperty searchIsVisibleProperty() {
        return this.searchIsVisible;
    }

    public BooleanProperty includeParametersProperty() {
        return this.includeParameters;
    }
}

