/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.IReplayableListener;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class DiagnosticsView
extends ViewPart {
    Text outputPane;
    private Job job;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        Button go = new Button(parent, 8);
        go.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        go.setText("Check Replay");
        go.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceDataModel model;
                AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
                TraceDataModel traceDataModel = model = connection != null ? connection.getActiveModel() : null;
                if (model != null) {
                    DiagnosticsView.this.calculateReplayability(model);
                }
            }
        });
        this.outputPane = new Text(parent, 2048);
        this.outputPane.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        this.outputPane.setEditable(false);
    }

    void calculateReplayability(final TraceDataModel model) {
        this.job = new Job("Replay-calculator"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Calculating replayability", model.getFrames().count());
                ReplayResultListener listener = new ReplayResultListener();
                for (Frame frame : model.getFrames().getFrames()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    frame.isFrameReplayable((IReplayableListener)listener);
                    monitor.worked(1);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(true);
        this.job.schedule();
    }

    void appendText(final String textToSet) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!DiagnosticsView.this.outputPane.isDisposed()) {
                    DiagnosticsView.this.outputPane.append(textToSet);
                }
            }
        });
    }

    public void setFocus() {
    }

    class ReplayResultListener
    implements IReplayableListener {
        int nFramesEvaluated = 0;
        int nFramesReplayable = 0;

        ReplayResultListener() {
        }

        public void onReplayStateUpdated(TraceDataModel traceDataModel, Frame updatedFrame) {
            ++this.nFramesEvaluated;
            if (updatedFrame.isFrameReplayable(null)) {
                ++this.nFramesReplayable;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((ReplayResultListener)ReplayResultListener.this).DiagnosticsView.this.outputPane.setText("Checked: " + ReplayResultListener.this.nFramesEvaluated + ", replayable: " + ReplayResultListener.this.nFramesReplayable);
                }
            });
        }
    }
}

