/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.ConsoleViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Map;
import java.util.logging.LogRecord;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.VBox;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ConsoleView
extends FXViewPart {
    @FXML
    private VBox recordListBox;
    @FXML
    private ListView<LogRecord> recordList;
    private ConsoleViewController controller;

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/consoleView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.recordListBox = (VBox)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.controller = new ConsoleViewController();
        this.recordList.setCellFactory(view -> new LogRecordCellFactory((ListView<LogRecord>)view));
        this.recordList.setItems(this.controller.getRecordList());
        this.recordList.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ContextMenu contextMenu = new ContextMenu();
        final MenuItem copy = new MenuItem("Copy");
        copy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copy.setOnAction(event -> {
            StringBuilder sb = new StringBuilder();
            this.recordList.getSelectionModel().getSelectedItems().forEach(record -> {
                if (record != null) {
                    sb.append(ConsoleView.getDisplayString(record)).append(System.lineSeparator());
                }
            });
            if (sb.length() != 0) {
                ClipboardContent content = new ClipboardContent();
                content.putString(sb.toString());
                Clipboard.getSystemClipboard().setContent((Map)content);
            }
        });
        this.recordList.getSelectionModel().getSelectedItems().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                copy.setDisable(ConsoleView.this.recordList.getSelectionModel().getSelectedItems().size() == 0);
            }
        });
        contextMenu.getItems().add((Object)copy);
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.recordList), contextMenu);
        return new Scene((Parent)this.recordListBox);
    }

    private static @NonNull String getDisplayString(@NonNull LogRecord logRecord) {
        String msg = logRecord.getMessage();
        String levelName = logRecord.getLevel().getLocalizedName();
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(levelName).append("]: ").append(' ').append(msg);
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public void dispose() {
        this.controller.dispose();
        this.controller = null;
        super.dispose();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.consoleview";
    }

    @Override
    protected void setFxFocus() {
        this.recordList.requestFocus();
    }

    private static class LogRecordCellFactory
    extends ListCell<LogRecord> {
        private Text text = new Text();

        private LogRecordCellFactory(ListView<LogRecord> recordList) {
            this.text.wrappingWidthProperty().bind((ObservableValue)recordList.widthProperty().subtract(30));
            this.text.setFontSmoothingType(FontSmoothingType.LCD);
        }

        protected void updateItem(LogRecord item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setGraphic(null);
            } else {
                this.text.setText(ConsoleView.getDisplayString(item));
                this.setGraphic((Node)this.text);
            }
        }
    }
}

